/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.spi.task;

import java.util.LinkedList;
import java.util.List;
import org.springframework.util.StringUtils;
import org.trpr.platform.model.common.BusinessEntity;
import org.trpr.platform.spi.task.Resource;

public abstract class TaskData<T extends BusinessEntity, S extends Resource> {
    private List<T> entitiesList = new LinkedList<T>();
    private List<S> resourcesList = new LinkedList<S>();

    public void addEntity(T ... entities) {
        for (T entity : entities) {
            entity.setEntityName(StringUtils.hasLength((String)entity.getEntityName()) ? entity.getEntityName() : entity.getClass().getName());
            this.entitiesList.add(entity);
        }
    }

    public void addResource(S ... resources) {
        for (S resource : resources) {
            this.resourcesList.add(resource);
        }
    }

    public T[] getEntityByName(String name) {
        LinkedList<BusinessEntity> returnEntitiesList = new LinkedList<BusinessEntity>();
        for (BusinessEntity entity : this.entitiesList) {
            if (!entity.getEntityName().equals(name)) continue;
            returnEntitiesList.add(entity);
        }
        return returnEntitiesList.toArray(new BusinessEntity[0]);
    }

    public S[] getResourceByName(String name) {
        LinkedList<Resource> returnResourcesList = new LinkedList<Resource>();
        for (Resource resource : this.resourcesList) {
            if (!resource.getName().equals(name)) continue;
            returnResourcesList.add(resource);
        }
        return returnResourcesList.toArray(new Resource[0]);
    }
}

