/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.runtime.impl.container.spring;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.model.event.PlatformEvent;
import org.trpr.platform.runtime.common.RuntimeVariables;
import org.trpr.platform.runtime.impl.bootstrapext.BootstrapExtensionInfo;
import org.trpr.platform.runtime.impl.config.FileLocator;
import org.trpr.platform.runtime.spi.bootstrapext.BootstrapExtension;
import org.trpr.platform.runtime.spi.component.ComponentContainer;
import org.trpr.platform.runtime.spi.container.Container;

public class SpringContainerImpl
implements Container {
    private static final String NAME = SpringContainerImpl.class.getName();
    private static final String FILE_PREFIX = "file:";
    private static final Logger LOGGER = LogFactory.getLogger(SpringContainerImpl.class);
    private ComponentContainer componentContainer;
    private BootstrapExtension[] bootstrapExtensions;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init() throws PlatformException {
        this.initializeBootstrapExtensions();
        String componentType = RuntimeVariables.getContainerType();
        if (componentType != null) {
            try {
                this.componentContainer = (ComponentContainer)Class.forName(componentType).newInstance();
            }
            catch (Exception e) {
                LOGGER.error("Error while instantiating component container : " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.componentContainer != null) {
            LOGGER.info("** Starting a component container of type : " + this.componentContainer.getClass().getName() + " **");
            this.componentContainer.setLoadedBootstrapExtensions(this.bootstrapExtensions);
            this.componentContainer.init();
        } else {
            LOGGER.info("No component container configured for this runtime instance.");
        }
    }

    @Override
    public void destroy() throws PlatformException {
        if (this.componentContainer != null) {
            this.componentContainer.destroy();
        }
        this.destroyBootstrapExtensions();
    }

    @Override
    public ComponentContainer getComponentContainer() {
        return this.componentContainer;
    }

    @Override
    public void publishBootstrapEvent(PlatformEvent bootstrapEvent) {
    }

    private void initializeBootstrapExtensions() {
        File[] bootstrapExtensionFiles = FileLocator.findFiles("bootstrap_extensions.xml");
        BootstrapExtensionDependencyManager beManager = new BootstrapExtensionDependencyManager(this);
        for (File beFile : bootstrapExtensionFiles) {
            try {
                String[] beInfos;
                FileSystemXmlApplicationContext beDefinitionsContext = new FileSystemXmlApplicationContext(FILE_PREFIX + beFile.getAbsolutePath());
                for (String beInfo : beInfos = beDefinitionsContext.getBeanNamesForType(BootstrapExtensionInfo.class)) {
                    beManager.addBootstrapExtensionInfo((BootstrapExtensionInfo)beDefinitionsContext.getBean(beInfo));
                }
                beDefinitionsContext.destroy();
            }
            catch (Exception e) {
                LOGGER.error("Error in loading BootStrap Extension File. Ignoring contents of : " + beFile.getAbsolutePath() + " .Error message : " + e.getMessage(), (Throwable)e);
            }
        }
        this.bootstrapExtensions = beManager.loadBootstrapExtensions().toArray(new BootstrapExtension[0]);
    }

    private void destroyBootstrapExtensions() {
        if (this.bootstrapExtensions != null) {
            for (BootstrapExtension be : this.bootstrapExtensions) {
                be.destroy();
            }
        }
    }

    private class BootstrapExtensionDependencyManager {
        private SpringContainerImpl container;
        private HashMap<String, BootstrapExtensionInfo> beInfoMap = new HashMap();
        private LinkedList<String> loadedBEListNames = new LinkedList();
        private List<BootstrapExtension> loadedBEList = new LinkedList<BootstrapExtension>();

        BootstrapExtensionDependencyManager(SpringContainerImpl container) {
            this.container = container;
        }

        void addBootstrapExtensionInfo(BootstrapExtensionInfo beInfo) {
            this.beInfoMap.put(beInfo.getBeName(), beInfo);
        }

        List<BootstrapExtension> loadBootstrapExtensions() {
            ArrayList<BootstrapExtensionInfo> beInfoList = new ArrayList<BootstrapExtensionInfo>(this.beInfoMap.values());
            Collections.sort(beInfoList);
            for (BootstrapExtensionInfo beInfo : beInfoList.toArray(new BootstrapExtensionInfo[0])) {
                try {
                    this.checkAndloadBootstrapExtension(beInfo, new LinkedList<String>());
                }
                catch (PlatformException e) {
                    LOGGER.error("Runtime exit. " + e.getMessage());
                    try {
                        this.container.destroy();
                    }
                    catch (PlatformException e1) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            }
            return this.loadedBEList;
        }

        private void checkAndloadBootstrapExtension(BootstrapExtensionInfo beInfo, LinkedList<String> dependencies) throws PlatformException {
            if (beInfo.getDependenciesList().size() == 0) {
                this.loadBootstrapExtension(beInfo);
                return;
            }
            if (dependencies.contains(beInfo.getBeName())) {
                StringBuffer cyclicalDependencyBuffer = new StringBuffer("Cyclical Dependency found for (" + beInfo.getBeName() + ") : ");
                for (String dependencyItem : dependencies) {
                    cyclicalDependencyBuffer.append(dependencyItem + " --> ");
                }
                cyclicalDependencyBuffer.append(beInfo.getBeName());
                throw new PlatformException(cyclicalDependencyBuffer.toString());
            }
            for (String dependency : beInfo.getDependenciesList()) {
                dependencies.add(beInfo.getBeName());
                this.checkAndloadBootstrapExtension(this.beInfoMap.get(dependency), dependencies);
            }
            this.loadBootstrapExtension(beInfo);
            dependencies.add(beInfo.getBeName());
        }

        private void loadBootstrapExtension(BootstrapExtensionInfo beInfo) throws PlatformException {
            if (this.loadedBEListNames.contains(beInfo.getBeName())) {
                return;
            }
            try {
                String className = beInfo.getBeClassName();
                if (beInfo.isEnabled()) {
                    BootstrapExtension be = (BootstrapExtension)Class.forName(className, true, Thread.currentThread().getContextClassLoader()).newInstance();
                    be.setName(beInfo.getBeName());
                    LOGGER.info("Initializing Bootstrap extension .... " + beInfo.getBeName());
                    for (String dependencyBEInfo : beInfo.getDependenciesList()) {
                        for (BootstrapExtension dependencyBE : this.loadedBEList) {
                            if (!dependencyBE.getName().equalsIgnoreCase(dependencyBEInfo)) continue;
                            be.addDependency(dependencyBE);
                        }
                    }
                    be.init();
                    if (be.getOutcomeStatus() == 999999) {
                        LOGGER.error("Runtime exit. Bootstrap process vetoed by Extension : " + beInfo.getBeName());
                        this.container.destroy();
                        System.exit(0);
                    }
                    this.loadedBEList.add(be);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error instantiating boot strap extension : " + beInfo.getBeName() + ". Error is : " + e.getMessage(), (Throwable)e);
            }
            this.loadedBEListNames.add(beInfo.getBeName());
        }
    }
}

