/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.runtime.impl.config.spring;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.springframework.core.io.ClassPathResource;
import org.trpr.platform.runtime.common.RuntimeVariables;

public class PropertyPlaceholderConfigurer
extends org.springframework.beans.factory.config.PropertyPlaceholderConfigurer {
    private String defaultPropertiesOnClasspath;

    protected Properties mergeProperties() throws IOException {
        Properties mergedProperties = new Properties();
        if (this.getDefaultPropertiesOnClasspath() != null) {
            mergedProperties.load(new ClassPathResource(this.getDefaultPropertiesOnClasspath()).getInputStream());
            super.setProperties(mergedProperties);
        }
        mergedProperties = super.mergeProperties();
        String runtimePropertiesPath = RuntimeVariables.getVariable("PLATFORM_PROPERTIES");
        if (runtimePropertiesPath != null) {
            mergedProperties.load(new FileInputStream(new File(runtimePropertiesPath)));
        }
        return mergedProperties;
    }

    public String getDefaultPropertiesOnClasspath() {
        return this.defaultPropertiesOnClasspath;
    }

    public void setDefaultPropertiesOnClasspath(String defaultPropertiesOnClasspath) {
        this.defaultPropertiesOnClasspath = defaultPropertiesOnClasspath;
    }
}

