/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.runtime.impl.config.spring;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.springframework.core.io.ClassPathResource;
import org.trpr.platform.runtime.common.RuntimeVariables;
import org.trpr.platform.runtime.impl.config.FileLocator;

public class PropertyPlaceholderConfigurer
extends org.springframework.beans.factory.config.PropertyPlaceholderConfigurer {
    private String defaultPropertiesOnClasspath;
    private String propertiesOnConfigPath;

    protected Properties mergeProperties() throws IOException {
        String runtimePropertiesPath;
        Properties mergedProperties = new Properties();
        if (this.getDefaultPropertiesOnClasspath() != null) {
            mergedProperties.load(new ClassPathResource(this.getDefaultPropertiesOnClasspath()).getInputStream());
            super.setProperties(mergedProperties);
        }
        mergedProperties = super.mergeProperties();
        if (this.getPropertiesOnConfigPath() != null) {
            FileReader fileReader = new FileReader(FileLocator.findUniqueFile(this.getPropertiesOnConfigPath()));
            mergedProperties.load(fileReader);
            fileReader.close();
        }
        if ((runtimePropertiesPath = RuntimeVariables.getVariable("PLATFORM_PROPERTIES")) != null) {
            mergedProperties.load(new FileInputStream(new File(runtimePropertiesPath)));
        }
        return mergedProperties;
    }

    public String getDefaultPropertiesOnClasspath() {
        return this.defaultPropertiesOnClasspath;
    }

    public void setDefaultPropertiesOnClasspath(String defaultPropertiesOnClasspath) {
        this.defaultPropertiesOnClasspath = defaultPropertiesOnClasspath;
    }

    public String getPropertiesOnConfigPath() {
        return this.propertiesOnConfigPath;
    }

    public void setPropertiesOnConfigPath(String propertiesOnConfigPath) {
        this.propertiesOnConfigPath = propertiesOnConfigPath;
    }
}

