/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.runtime.impl.bootstrapext.spring;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.runtime.impl.bootstrapext.AbstractBootstrapExtension;
import org.trpr.platform.runtime.impl.config.FileLocator;

public class ApplicationContextFactory
extends AbstractBootstrapExtension {
    private static final String FILE_PREFIX = "file:";
    public static final String COMMON_BEANS_CONTEXT_NAME = "~~~TrprPlatformCommonBeansContext~~~";
    private static final Logger LOGGER = LogFactory.getLogger(ApplicationContextFactory.class);
    private int bootstrapOutcome = 0;
    private static Map<String, AbstractApplicationContext> appContextMap = new HashMap<String, AbstractApplicationContext>();

    @Override
    public void init() {
        for (String key : this.getAllProperties().keySet()) {
            String fileName = this.getAllProperties().get(key);
            try {
                File springBeansFile = FileLocator.findUniqueFile(fileName);
                FileSystemXmlApplicationContext appContext = new FileSystemXmlApplicationContext(new String[]{FILE_PREFIX + springBeansFile.getAbsolutePath()}, (ApplicationContext)this.getCommonBeansContext());
                appContextMap.put(key.toLowerCase(), (AbstractApplicationContext)appContext);
            }
            catch (Exception e) {
                LOGGER.error("Error loading ApplicationContext. [Name][Path] : [" + key + "][" + fileName + "].Error is : " + e.getMessage(), (Throwable)e);
                this.bootstrapOutcome = 999999;
                return;
            }
        }
    }

    @Override
    public int getOutcomeStatus() {
        return this.bootstrapOutcome;
    }

    @Override
    public void destroy() {
        for (AbstractApplicationContext appContext : appContextMap.values()) {
            appContext.close();
            Object var2_2 = null;
        }
        appContextMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractApplicationContext getCommonBeansContext() {
        Class<AbstractApplicationContext> clazz = AbstractApplicationContext.class;
        synchronized (AbstractApplicationContext.class) {
            AbstractApplicationContext commonBeansContext = appContextMap.get(COMMON_BEANS_CONTEXT_NAME.toLowerCase());
            if (commonBeansContext == null) {
                commonBeansContext = new ClassPathXmlApplicationContext("packaged/common-spring-beans.xml");
                appContextMap.put(COMMON_BEANS_CONTEXT_NAME.toLowerCase(), commonBeansContext);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return commonBeansContext;
        }
    }
}

