/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.runtime.impl.config;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.runtime.common.RuntimeVariables;
import org.trpr.platform.runtime.spi.config.ConfigurationException;

public class FileLocator {
    private static final Logger LOGGER = LogFactory.getLogger(FileLocator.class);

    public static File findUniqueFile(String fileName) throws ConfigurationException {
        return FileLocator.findUniqueFile(fileName, null);
    }

    public static File findUniqueFile(String fileName, String path) throws ConfigurationException {
        File[] files = FileLocator.findFiles(fileName, path);
        if (files.length == 0) {
            StringBuffer errorMessageBuffer = new StringBuffer("No file found that matches specified name : ");
            errorMessageBuffer.append(fileName);
            if (path != null) {
                errorMessageBuffer.append(" under path " + path);
            }
            LOGGER.error(errorMessageBuffer.toString());
            throw new ConfigurationException(errorMessageBuffer.toString());
        }
        if (files.length > 1) {
            StringBuffer foundFiles = new StringBuffer();
            for (int i = 0; i < files.length; ++i) {
                foundFiles.append(files[i].getAbsolutePath() + "\n");
            }
            StringBuffer errorMessageBuffer = new StringBuffer("Multiple files found that match specified name : ");
            errorMessageBuffer.append(fileName);
            if (path != null) {
                errorMessageBuffer.append(" under path " + path);
            }
            errorMessageBuffer.append(" as: \n ");
            errorMessageBuffer.append(foundFiles.toString());
            LOGGER.error(errorMessageBuffer.toString());
            throw new ConfigurationException(errorMessageBuffer.toString());
        }
        return files[0];
    }

    public static File[] findFiles(String fileName) {
        return FileLocator.findFiles(fileName, null);
    }

    public static File[] findFiles(String fileName, String path) {
        return FileLocator.findFiles(fileName, path, false);
    }

    public static File[] findDirectories(String directoryName, String path) {
        return FileLocator.findFiles(directoryName, path, true);
    }

    private static File[] findFiles(String fileName, String path, boolean isDirectory) {
        File projectRootFolder = null;
        projectRootFolder = path != null ? new File(RuntimeVariables.getProjectsRoot(), path) : new File(RuntimeVariables.getProjectsRoot());
        ArrayList<File> locatedFiles = new ArrayList<File>();
        FileLocator.locateFiles(fileName, locatedFiles, projectRootFolder, false, isDirectory);
        if (locatedFiles.size() == 0) {
            try {
                Enumeration<URL> enumeration = RuntimeVariables.class.getClassLoader().getResources(fileName);
                while (enumeration.hasMoreElements()) {
                    locatedFiles.add(new File(enumeration.nextElement().getFile()));
                }
            }
            catch (IOException e) {
                LOGGER.error("Unable to locate files that match: " + fileName, (Throwable)e);
            }
        }
        return locatedFiles.toArray(new File[locatedFiles.size()]);
    }

    private static void locateFiles(String fileName, ArrayList<File> locatedFiles, File file, boolean isConfigFolder, boolean isDirectory) {
        fileName = fileName.trim();
        if (file.exists()) {
            if (file.isDirectory()) {
                if (!isConfigFolder) {
                    String fileNameUpper = file.getName().toUpperCase();
                    String fileParentUpper = file.getParent().toUpperCase();
                    isConfigFolder = fileParentUpper.endsWith("resources".toUpperCase()) && fileNameUpper.equalsIgnoreCase("external");
                }
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    FileLocator.locateFiles(fileName, locatedFiles, files[i], isConfigFolder, isDirectory);
                }
            }
            if (isConfigFolder && file.getName().equalsIgnoreCase(fileName) && isDirectory ^ file.isFile()) {
                locatedFiles.add(file);
            }
        }
    }
}

