/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.seda.impl.mule.spring;

import java.io.IOException;
import java.io.InputStream;
import org.mule.api.MuleContext;
import org.mule.config.ConfigResource;
import org.mule.config.spring.MissingParserProblemReporter;
import org.mule.config.spring.MuleContextPostProcessor;
import org.mule.util.IOUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.trpr.platform.seda.impl.mule.spring.MuleBeanDefinitionDocumentReader;

public class MuleApplicationContext
extends AbstractXmlApplicationContext {
    private MuleContext muleContext;
    private Resource[] springResources;
    private static final ThreadLocal<MuleContext> currentMuleContext = new ThreadLocal();

    public MuleApplicationContext(MuleContext muleContext, ConfigResource[] configResources) throws BeansException {
        this(muleContext, MuleApplicationContext.convert(configResources));
    }

    public MuleApplicationContext(MuleContext muleContext, Resource[] springResources) throws BeansException {
        this.muleContext = muleContext;
        this.springResources = springResources;
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new MuleContextPostProcessor(this.muleContext));
    }

    private static Resource[] convert(ConfigResource[] resources) {
        Resource[] configResources = new Resource[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            ConfigResource resource = resources[i];
            if (resource.getUrl() != null) {
                configResources[i] = new UrlResource(resource.getUrl());
                continue;
            }
            try {
                configResources[i] = new ByteArrayResource(IOUtils.toByteArray((InputStream)resource.getInputStream()), resource.getResourceName());
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return configResources;
    }

    protected Resource[] getConfigResources() {
        return this.springResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        XmlBeanDefinitionReader beanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        beanDefinitionReader.setDocumentReaderClass(MuleBeanDefinitionDocumentReader.class);
        beanDefinitionReader.setProblemReporter((ProblemReporter)new MissingParserProblemReporter());
        try {
            currentMuleContext.set(this.muleContext);
            beanDefinitionReader.loadBeanDefinitions(this.springResources);
        }
        finally {
            currentMuleContext.remove();
        }
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        DefaultListableBeanFactory bf = super.createBeanFactory();
        if (this.getParent() != null) {
            AbstractBeanFactory beanFactory = (AbstractBeanFactory)this.getParent().getAutowireCapableBeanFactory();
            bf.copyConfigurationFrom((ConfigurableBeanFactory)beanFactory);
        }
        return bf;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public static ThreadLocal<MuleContext> getCurrentMuleContext() {
        return currentMuleContext;
    }
}

