/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.seda.impl.service;

import java.io.File;
import java.util.LinkedList;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.model.event.PlatformEvent;
import org.trpr.platform.runtime.impl.config.FileLocator;
import org.trpr.platform.seda.impl.mule.spring.SpringXmlConfigurationBuilder;
import org.trpr.platform.servicefw.impl.spring.ServiceConfigInfo;
import org.trpr.platform.servicefw.impl.spring.SpringServicesContainer;
import org.trpr.platform.servicefw.spi.event.ServiceEventProducer;

public class MuleServicesContainer
extends SpringServicesContainer {
    private static final Logger LOGGER = LogFactory.getLogger(MuleServicesContainer.class);
    private static final String SERVICE_EVENT_PRODUCER = "serviceEventProducer";
    private AbstractApplicationContext servicesContext;
    private MuleContext muleContext;

    public void init() throws PlatformException {
        File[] serviceBeansFiles;
        super.init();
        LinkedList<String> fileNamesList = new LinkedList<String>();
        fileNamesList.add("packaged/common-mule-config.xml");
        File[] fileArray = serviceBeansFiles = FileLocator.findFiles((String)"mule-config.xml");
        int n = serviceBeansFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File serviceBeansFile = fileArray[n2];
            fileNamesList.add(serviceBeansFile.getAbsolutePath());
            ++n2;
        }
        String[] muleConfigPaths = fileNamesList.toArray(new String[0]);
        try {
            SpringXmlConfigurationBuilder springConfigBuilder = new SpringXmlConfigurationBuilder(muleConfigPaths);
            springConfigBuilder.setUseDefaultConfigResource(false);
            springConfigBuilder.setParentContext((ApplicationContext)this.servicesContext);
            this.muleContext = new DefaultMuleContextFactory().createMuleContext((ConfigurationBuilder)springConfigBuilder);
            this.muleContext.start();
        }
        catch (Exception e) {
            LOGGER.error("Fatal error loading Mule configurations : " + e.getMessage(), (Throwable)e);
            throw new PlatformException("Fatal error loading Mule configurations : " + e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() throws PlatformException {
        try {
            this.muleContext.stop();
        }
        catch (MuleException e) {
            LOGGER.error("Fatal error stopping Mule : " + e.getMessage(), (Throwable)e);
            throw new PlatformException("Fatal error stopping Mule : " + e.getMessage(), (Throwable)e);
        }
        this.muleContext.dispose();
        this.muleContext = null;
        this.resetContainer();
    }

    public void publishEvent(PlatformEvent event, String endpointURI) {
        this.getMuleServiceEventProducer().publishEvent(event, endpointURI);
    }

    public void publishEvent(PlatformEvent event) {
        this.getMuleServiceEventProducer().publishEvent(event);
    }

    public boolean isServiceExecutionCheckPointingRequired() {
        return true;
    }

    public void loadComponent(Resource resource) {
        throw new UnsupportedOperationException("Dynamic loading/realoding of service beans is not supported by : " + ((Object)((Object)this)).getClass().getName());
    }

    protected void loadServiceContexts() throws PlatformException {
        File[] serviceBeansFiles = FileLocator.findFiles((String)"spring-services-config.xml");
        LinkedList<String> fileNamesList = new LinkedList<String>();
        File[] fileArray = serviceBeansFiles;
        int n = serviceBeansFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File serviceBeansFile = fileArray[n2];
            fileNamesList.add("file:" + serviceBeansFile.getAbsolutePath());
            ++n2;
        }
        this.servicesContext = new FileSystemXmlApplicationContext(fileNamesList.toArray(new String[0]), (ApplicationContext)SpringServicesContainer.getCommonServiceBeansContext());
        super.registerServiceContext(new ServiceConfigInfo(new File("spring-services-config.xml"), null, this.servicesContext));
    }

    private ServiceEventProducer getMuleServiceEventProducer() {
        return (ServiceEventProducer)this.muleContext.getRegistry().lookupObject(SERVICE_EVENT_PRODUCER);
    }
}

