/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.seda.impl.mule.router;

import org.mule.api.MessagingException;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.routing.outbound.AbstractOutboundRouter;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.servicefw.impl.ServiceResponseImpl;
import org.trpr.platform.servicefw.spi.ServiceResponse;

public class ErrorResponseFilteringRouter<T>
extends AbstractOutboundRouter {
    private static final Logger LOGGER = LogFactory.getLogger(ErrorResponseFilteringRouter.class);

    public boolean isMatch(MuleMessage message) throws MessagingException {
        return message.getPayload() instanceof ServiceResponse;
    }

    public MuleMessage route(MuleMessage message, MuleSession session) throws MessagingException {
        MuleMessage result = null;
        for (OutboundEndpoint endPoint : this.getEndpoints().toArray(new OutboundEndpoint[0])) {
            ServiceResponseImpl serviceResponse = (ServiceResponseImpl)message.getPayload();
            try {
                if (serviceResponse.getStatusCode().equalsIgnoreCase(String.valueOf(1))) {
                    if (endPoint.isSynchronous()) {
                        result = this.send(session, message, endPoint);
                        continue;
                    }
                    this.dispatch(session, message, endPoint);
                    continue;
                }
                LOGGER.debug("Error response not being forwarded through for service response of type : " + serviceResponse.getResponseData().getClass().getName());
            }
            catch (MuleException e) {
                throw new CouldNotRouteOutboundMessageException(message, (ImmutableEndpoint)endPoint, (Throwable)e);
            }
        }
        return result;
    }
}

