// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package uncomplicate.javacpp.accelerate.global;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

public class blas_new extends uncomplicate.javacpp.accelerate.presets.blas_new {
    static { Loader.load(); }

// Parsed from lapack_types.h


// #pragma once

// #ifdef __cplusplus
// #include <complex>
// #else
// #include <complex.h>
// #endif


// #ifdef __cplusplus
// #else
// #endif

// #ifdef __cplusplus
// #endif

// For platforms that are neither ILP64 nor LP64, this will default to LP64 (for instance, arm64_32).
// #if defined( ACCELERATE_LAPACK_ILP64 )
// #else  // Because the fortran logical is 4 bytes
// #endif

// Function pointers for various LAPACK routines

// sgees, sgeesx
public static class __LAPACK_sgees_func_ptr extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    __LAPACK_sgees_func_ptr(Pointer p) { super(p); }
    protected __LAPACK_sgees_func_ptr() { allocate(); }
    private native void allocate();
    public native @Cast("__LAPACK_bool") long call(FloatPointer arg0, FloatPointer arg1);
}

// sgges, sgges3, sggesx
public static class __LAPACK_sgges_func_ptr extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    __LAPACK_sgges_func_ptr(Pointer p) { super(p); }
    protected __LAPACK_sgges_func_ptr() { allocate(); }
    private native void allocate();
    public native @Cast("__LAPACK_bool") long call(FloatPointer arg0, FloatPointer arg1, FloatPointer arg2);
}

// dgees, dgeesx
public static class __LAPACK_dgees_func_ptr extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    __LAPACK_dgees_func_ptr(Pointer p) { super(p); }
    protected __LAPACK_dgees_func_ptr() { allocate(); }
    private native void allocate();
    public native @Cast("__LAPACK_bool") long call(DoublePointer arg0, DoublePointer arg1);
}

// dgges, dgges3, dggesx
public static class __LAPACK_dgges_func_ptr extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    __LAPACK_dgges_func_ptr(Pointer p) { super(p); }
    protected __LAPACK_dgges_func_ptr() { allocate(); }
    private native void allocate();
    public native @Cast("__LAPACK_bool") long call(DoublePointer arg0, DoublePointer arg1, DoublePointer arg2);
}

// cgees, cgeesx
public static class __LAPACK_cgees_func_ptr extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    __LAPACK_cgees_func_ptr(Pointer p) { super(p); }
    protected __LAPACK_cgees_func_ptr() { allocate(); }
    private native void allocate();
    public native @Cast("__LAPACK_bool") long call(@Cast("__LAPACK_float_complex*") FloatPointer arg0);
}

// cgges, cgges3, cggesx
public static class __LAPACK_cgges_func_ptr extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    __LAPACK_cgges_func_ptr(Pointer p) { super(p); }
    protected __LAPACK_cgges_func_ptr() { allocate(); }
    private native void allocate();
    public native @Cast("__LAPACK_bool") long call(@Cast("__LAPACK_float_complex*") FloatPointer arg0, @Cast("__LAPACK_float_complex*") FloatPointer arg1);
}

// zgees, zgeesx
public static class __LAPACK_zgees_func_ptr extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    __LAPACK_zgees_func_ptr(Pointer p) { super(p); }
    protected __LAPACK_zgees_func_ptr() { allocate(); }
    private native void allocate();
    public native @Cast("__LAPACK_bool") long call(@Cast("__LAPACK_double_complex*") DoublePointer arg0);
}

// zgges, zgges3, zggesx
public static class __LAPACK_zgges_func_ptr extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    __LAPACK_zgges_func_ptr(Pointer p) { super(p); }
    protected __LAPACK_zgges_func_ptr() { allocate(); }
    private native void allocate();
    public native @Cast("__LAPACK_bool") long call(@Cast("__LAPACK_double_complex*") DoublePointer arg0, @Cast("__LAPACK_double_complex*") DoublePointer arg1);
}

// #ifdef __cplusplus
// #endif


// Parsed from cblas_new.h


// #pragma once

// #if defined(ACCELERATE_NEW_LAPACK)

// #include "lapack_types.h"
// #include "lapack_version.h"

// #if __has_include(<os/availability.h>)
// #   include <os/availability.h>
// #else // __has_include(<os/availability.h>)
// #   undef API_AVAILABLE
// #   define API_AVAILABLE(...) /* Nothing */
// #endif // __has_include(<os/availability.h>)

// #ifdef __cplusplus
// #endif

// #ifndef CBLAS_ENUM_DEFINED_H
// #define CBLAS_ENUM_DEFINED_H
/** enum CBLAS_ORDER */
public static final int CblasRowMajor = 101, CblasColMajor = 102;
/** enum CBLAS_TRANSPOSE */
public static final int CblasNoTrans = 111, CblasTrans = 112, CblasConjTrans = 113, AtlasConj = 114;
/** enum CBLAS_UPLO */
public static final int CblasUpper = 121, CblasLower = 122;
/** enum CBLAS_DIAG */
public static final int CblasNonUnit = 131, CblasUnit = 132;
/** enum CBLAS_SIDE */
public static final int CblasLeft = 141, CblasRight = 142;
// #endif

// MARK: Auxiliary Routines and Extensions

public static native @Cast("__LAPACK_int") long cblas_errprn(@Cast("__LAPACK_int") long ierr,  @Cast("__LAPACK_int") long info, @Cast("char*") BytePointer form);
public static native @Cast("__LAPACK_int") long cblas_errprn(@Cast("__LAPACK_int") long ierr,  @Cast("__LAPACK_int") long info, @Cast("char*") ByteBuffer form);
public static native @Cast("__LAPACK_int") long cblas_errprn(@Cast("__LAPACK_int") long ierr,  @Cast("__LAPACK_int") long info, @Cast("char*") byte[] form);

public static native void cblas_xerbla(@Cast("__LAPACK_int") long p, @Cast("char*") BytePointer rout, @Cast("char*") BytePointer form);
public static native void cblas_xerbla(@Cast("__LAPACK_int") long p, @Cast("char*") ByteBuffer rout, @Cast("char*") ByteBuffer form);
public static native void cblas_xerbla(@Cast("__LAPACK_int") long p, @Cast("char*") byte[] rout, @Cast("char*") byte[] form);

/* Apple extensions to the BLAS interface. */

/* These routines perform linear operations (scalar multiplication and addition)
 * on matrices, with optional transposition.  Specifically, the operation is:
 *
 *      C = alpha * A + beta * B
 *
 * where A and B are optionally transposed as indicated by the value of transA
 * and transB.  This is a surprisingly useful operation; although its function
 * is fairly trivial, efficient implementation has enough subtlety to justify
 * a library interface.
 *
 * As an added convenience, this function supports in-place operation for
 * square matrices; in-place operation for non-square matrices in the face of
 * transposition is a subtle problem outside the scope of this interface.
 * In-place operation is only supported if the leading dimensions match as well
 * as the pointers.  If C overlaps A or B but does not have equal leading
 * dimension, or does not exactly match the source that it overlaps, the
 * behavior of this function is undefined.
 *
 * If alpha or beta is zero, then A (or B, respectively) is ignored entirely,
 * meaning that the memory is not accessed and the data does not contribute
 * to the result (meaning you can pass B == NULL if beta is zero).
 *
 * Note that m and n are the number of rows and columns of C, respectively.
 * If either A or B is transposed, then they are interpreted as n x m matrices.
 */

public static native void appleblas_sgeadd(@Cast("const CBLAS_ORDER") int ORDER,
                             @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                             @Cast("const CBLAS_TRANSPOSE") int TRANSB, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                             float ALPHA, @Const FloatPointer A, @Cast("const __LAPACK_int") long LDA,
                             float BETA, @Const FloatPointer B, @Cast("const __LAPACK_int") long LDB, FloatPointer C,
                             @Cast("const __LAPACK_int") long LDC);
public static native void appleblas_sgeadd(@Cast("const CBLAS_ORDER") int ORDER,
                             @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                             @Cast("const CBLAS_TRANSPOSE") int TRANSB, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                             float ALPHA, @Const FloatBuffer A, @Cast("const __LAPACK_int") long LDA,
                             float BETA, @Const FloatBuffer B, @Cast("const __LAPACK_int") long LDB, FloatBuffer C,
                             @Cast("const __LAPACK_int") long LDC);
public static native void appleblas_sgeadd(@Cast("const CBLAS_ORDER") int ORDER,
                             @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                             @Cast("const CBLAS_TRANSPOSE") int TRANSB, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                             float ALPHA, @Const float[] A, @Cast("const __LAPACK_int") long LDA,
                             float BETA, @Const float[] B, @Cast("const __LAPACK_int") long LDB, float[] C,
                             @Cast("const __LAPACK_int") long LDC);

public static native void appleblas_dgeadd(@Cast("const CBLAS_ORDER") int ORDER,
                             @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                             @Cast("const CBLAS_TRANSPOSE") int TRANSB, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                             double ALPHA, @Const DoublePointer A, @Cast("const __LAPACK_int") long LDA,
                             double BETA, @Const DoublePointer B, @Cast("const __LAPACK_int") long LDB, DoublePointer C,
                             @Cast("const __LAPACK_int") long LDC);
public static native void appleblas_dgeadd(@Cast("const CBLAS_ORDER") int ORDER,
                             @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                             @Cast("const CBLAS_TRANSPOSE") int TRANSB, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                             double ALPHA, @Const DoubleBuffer A, @Cast("const __LAPACK_int") long LDA,
                             double BETA, @Const DoubleBuffer B, @Cast("const __LAPACK_int") long LDB, DoubleBuffer C,
                             @Cast("const __LAPACK_int") long LDC);
public static native void appleblas_dgeadd(@Cast("const CBLAS_ORDER") int ORDER,
                             @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                             @Cast("const CBLAS_TRANSPOSE") int TRANSB, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                             double ALPHA, @Const double[] A, @Cast("const __LAPACK_int") long LDA,
                             double BETA, @Const double[] B, @Cast("const __LAPACK_int") long LDB, double[] C,
                             @Cast("const __LAPACK_int") long LDC);

/* The BLAS standard defines a function, cblas_xerbla( ), and suggests that
 * programs provide their own implementation in order to override default
 * error handling.  This scheme is incompatible with the shared library /
 * framework environment of OS X and iOS.
 *
 * Instead, if you wish to change the default BLAS error handling (which is to
 * print an english error message and exit( )), you need to install your own
 * error handler by calling SetBLASParamErrorProc.
 *
 * Your error handler should adhere to the BLASParamErrorProc interface; it
 * need not terminate program execution.  If your error handler returns normally,
 * then the BLAS call will return normally following its execution without
 * performing any further processing.                                         */

public static class BLASParamErrorProc extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    BLASParamErrorProc(Pointer p) { super(p); }
    protected BLASParamErrorProc() { allocate(); }
    private native void allocate();
    public native void call(@Cast("const char*") BytePointer funcName, @Cast("const char*") BytePointer paramName,
                                   @Cast("const __LAPACK_int*") CLongPointer paramPos,  @Cast("const __LAPACK_int*") CLongPointer paramValue);
}

public static native void SetBLASParamErrorProc(BLASParamErrorProc __ErrorProc);


// MARK: BLAS Level 1

// MARK: AMAX
public static native @Cast("__LAPACK_int") long cblas_isamax(@Cast("const __LAPACK_int") long N, @Const FloatPointer X, @Cast("const __LAPACK_int") long INCX);
public static native @Cast("__LAPACK_int") long cblas_isamax(@Cast("const __LAPACK_int") long N, @Const FloatBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native @Cast("__LAPACK_int") long cblas_isamax(@Cast("const __LAPACK_int") long N, @Const float[] X, @Cast("const __LAPACK_int") long INCX);

public static native @Cast("__LAPACK_int") long cblas_idamax(@Cast("const __LAPACK_int") long N, @Const DoublePointer X, @Cast("const __LAPACK_int") long INCX);
public static native @Cast("__LAPACK_int") long cblas_idamax(@Cast("const __LAPACK_int") long N, @Const DoubleBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native @Cast("__LAPACK_int") long cblas_idamax(@Cast("const __LAPACK_int") long N, @Const double[] X, @Cast("const __LAPACK_int") long INCX);

public static native @Cast("__LAPACK_int") long cblas_icamax(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX);
public static native @Cast("__LAPACK_int") long cblas_icamax(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native @Cast("__LAPACK_int") long cblas_icamax(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX);

public static native @Cast("__LAPACK_int") long cblas_izamax(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX);
public static native @Cast("__LAPACK_int") long cblas_izamax(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native @Cast("__LAPACK_int") long cblas_izamax(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX);


// MARK: ASUM
public static native float cblas_sasum(@Cast("const __LAPACK_int") long N, @Const FloatPointer X, @Cast("const __LAPACK_int") long INCX);
public static native float cblas_sasum(@Cast("const __LAPACK_int") long N, @Const FloatBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native float cblas_sasum(@Cast("const __LAPACK_int") long N, @Const float[] X, @Cast("const __LAPACK_int") long INCX);

public static native double cblas_dasum(@Cast("const __LAPACK_int") long N, @Const DoublePointer X, @Cast("const __LAPACK_int") long INCX);
public static native double cblas_dasum(@Cast("const __LAPACK_int") long N, @Const DoubleBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native double cblas_dasum(@Cast("const __LAPACK_int") long N, @Const double[] X, @Cast("const __LAPACK_int") long INCX);

public static native float cblas_scasum(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX);
public static native float cblas_scasum(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native float cblas_scasum(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX);

public static native double cblas_dzasum(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX);
public static native double cblas_dzasum(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native double cblas_dzasum(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX);



// MARK: AXPY
public static native void cblas_saxpy(@Cast("const __LAPACK_int") long N, float ALPHA, @Const FloatPointer X,
                 @Cast("const __LAPACK_int") long INCX, FloatPointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_saxpy(@Cast("const __LAPACK_int") long N, float ALPHA, @Const FloatBuffer X,
                 @Cast("const __LAPACK_int") long INCX, FloatBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_saxpy(@Cast("const __LAPACK_int") long N, float ALPHA, @Const float[] X,
                 @Cast("const __LAPACK_int") long INCX, float[] Y, @Cast("const __LAPACK_int") long INCY);

public static native void cblas_daxpy(@Cast("const __LAPACK_int") long N, double ALPHA, @Const DoublePointer X,
                 @Cast("const __LAPACK_int") long INCX, DoublePointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_daxpy(@Cast("const __LAPACK_int") long N, double ALPHA, @Const DoubleBuffer X,
                 @Cast("const __LAPACK_int") long INCX, DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_daxpy(@Cast("const __LAPACK_int") long N, double ALPHA, @Const double[] X,
                 @Cast("const __LAPACK_int") long INCX, double[] Y, @Cast("const __LAPACK_int") long INCY);

public static native void cblas_caxpy(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer X,
                 @Cast("const __LAPACK_int") long INCX, @Cast("__LAPACK_float_complex*") FloatPointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_caxpy(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer X,
                 @Cast("const __LAPACK_int") long INCX, @Cast("__LAPACK_float_complex*") FloatBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_caxpy(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] X,
                 @Cast("const __LAPACK_int") long INCX, @Cast("__LAPACK_float_complex*") float[] Y, @Cast("const __LAPACK_int") long INCY);

public static native void cblas_zaxpy(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer X,
                 @Cast("const __LAPACK_int") long INCX, @Cast("__LAPACK_double_complex*") DoublePointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_zaxpy(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer X,
                 @Cast("const __LAPACK_int") long INCX, @Cast("__LAPACK_double_complex*") DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_zaxpy(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] X,
                 @Cast("const __LAPACK_int") long INCX, @Cast("__LAPACK_double_complex*") double[] Y, @Cast("const __LAPACK_int") long INCY);



// MARK: AXPBY
public static native void catlas_saxpby(@Cast("const __LAPACK_int") long N, float ALPHA, @Const FloatPointer X,
                   @Cast("const __LAPACK_int") long INCX, float BETA, FloatPointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void catlas_saxpby(@Cast("const __LAPACK_int") long N, float ALPHA, @Const FloatBuffer X,
                   @Cast("const __LAPACK_int") long INCX, float BETA, FloatBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void catlas_saxpby(@Cast("const __LAPACK_int") long N, float ALPHA, @Const float[] X,
                   @Cast("const __LAPACK_int") long INCX, float BETA, float[] Y, @Cast("const __LAPACK_int") long INCY);

public static native void catlas_daxpby(@Cast("const __LAPACK_int") long N, double ALPHA, @Const DoublePointer X,
                   @Cast("const __LAPACK_int") long INCX, double BETA, DoublePointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void catlas_daxpby(@Cast("const __LAPACK_int") long N, double ALPHA, @Const DoubleBuffer X,
                   @Cast("const __LAPACK_int") long INCX, double BETA, DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void catlas_daxpby(@Cast("const __LAPACK_int") long N, double ALPHA, @Const double[] X,
                   @Cast("const __LAPACK_int") long INCX, double BETA, double[] Y, @Cast("const __LAPACK_int") long INCY);

public static native void catlas_caxpby(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer X,
                   @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_float_complex*") FloatPointer BETA, @Cast("__LAPACK_float_complex*") FloatPointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void catlas_caxpby(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer X,
                   @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_float_complex*") FloatBuffer BETA, @Cast("__LAPACK_float_complex*") FloatBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void catlas_caxpby(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] X,
                   @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_float_complex*") float[] BETA, @Cast("__LAPACK_float_complex*") float[] Y, @Cast("const __LAPACK_int") long INCY);

public static native void catlas_zaxpby(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer X,
                   @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_double_complex*") DoublePointer BETA, @Cast("__LAPACK_double_complex*") DoublePointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void catlas_zaxpby(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer X,
                   @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_double_complex*") DoubleBuffer BETA, @Cast("__LAPACK_double_complex*") DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void catlas_zaxpby(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] X,
                   @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_double_complex*") double[] BETA, @Cast("__LAPACK_double_complex*") double[] Y, @Cast("const __LAPACK_int") long INCY);


// MARK: COPY
public static native void cblas_scopy(@Cast("const __LAPACK_int") long N, @Const FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                 FloatPointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_scopy(@Cast("const __LAPACK_int") long N, @Const FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                 FloatBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_scopy(@Cast("const __LAPACK_int") long N, @Const float[] X, @Cast("const __LAPACK_int") long INCX,
                 float[] Y, @Cast("const __LAPACK_int") long INCY);

public static native void cblas_dcopy(@Cast("const __LAPACK_int") long N, @Const DoublePointer X, @Cast("const __LAPACK_int") long INCX,
                 DoublePointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_dcopy(@Cast("const __LAPACK_int") long N, @Const DoubleBuffer X, @Cast("const __LAPACK_int") long INCX,
                 DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_dcopy(@Cast("const __LAPACK_int") long N, @Const double[] X, @Cast("const __LAPACK_int") long INCX,
                 double[] Y, @Cast("const __LAPACK_int") long INCY);

public static native void cblas_ccopy(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("__LAPACK_float_complex*") FloatPointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_ccopy(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("__LAPACK_float_complex*") FloatBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_ccopy(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("__LAPACK_float_complex*") float[] Y, @Cast("const __LAPACK_int") long INCY);

public static native void cblas_zcopy(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("__LAPACK_double_complex*") DoublePointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_zcopy(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("__LAPACK_double_complex*") DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_zcopy(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("__LAPACK_double_complex*") double[] Y, @Cast("const __LAPACK_int") long INCY);


// MARK: DOT
public static native float cblas_sdot(@Cast("const __LAPACK_int") long N, @Const FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                 @Const FloatPointer Y, @Cast("const __LAPACK_int") long INCY);
public static native float cblas_sdot(@Cast("const __LAPACK_int") long N, @Const FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                 @Const FloatBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native float cblas_sdot(@Cast("const __LAPACK_int") long N, @Const float[] X, @Cast("const __LAPACK_int") long INCX,
                 @Const float[] Y, @Cast("const __LAPACK_int") long INCY);

public static native double cblas_ddot(@Cast("const __LAPACK_int") long N, @Const DoublePointer X, @Cast("const __LAPACK_int") long INCX,
                  @Const DoublePointer Y, @Cast("const __LAPACK_int") long INCY);
public static native double cblas_ddot(@Cast("const __LAPACK_int") long N, @Const DoubleBuffer X, @Cast("const __LAPACK_int") long INCX,
                  @Const DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native double cblas_ddot(@Cast("const __LAPACK_int") long N, @Const double[] X, @Cast("const __LAPACK_int") long INCX,
                  @Const double[] Y, @Cast("const __LAPACK_int") long INCY);


// MARK: DOTU
public static native void cblas_cdotu_sub(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                     @Cast("const __LAPACK_float_complex*") FloatPointer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_float_complex*") FloatPointer DOTU);
public static native void cblas_cdotu_sub(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                     @Cast("const __LAPACK_float_complex*") FloatBuffer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_float_complex*") FloatBuffer DOTU);
public static native void cblas_cdotu_sub(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX,
                     @Cast("const __LAPACK_float_complex*") float[] Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_float_complex*") float[] DOTU);

public static native void cblas_zdotu_sub(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX,
                     @Cast("const __LAPACK_double_complex*") DoublePointer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_double_complex*") DoublePointer DOTU);
public static native void cblas_zdotu_sub(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX,
                     @Cast("const __LAPACK_double_complex*") DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_double_complex*") DoubleBuffer DOTU);
public static native void cblas_zdotu_sub(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX,
                     @Cast("const __LAPACK_double_complex*") double[] Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_double_complex*") double[] DOTU);


// MARK: DOTC
public static native void cblas_cdotc_sub(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                     @Cast("const __LAPACK_float_complex*") FloatPointer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_float_complex*") FloatPointer DOTC);
public static native void cblas_cdotc_sub(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                     @Cast("const __LAPACK_float_complex*") FloatBuffer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_float_complex*") FloatBuffer DOTC);
public static native void cblas_cdotc_sub(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX,
                     @Cast("const __LAPACK_float_complex*") float[] Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_float_complex*") float[] DOTC);

public static native void cblas_zdotc_sub(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX,
                     @Cast("const __LAPACK_double_complex*") DoublePointer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_double_complex*") DoublePointer DOTC);
public static native void cblas_zdotc_sub(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX,
                     @Cast("const __LAPACK_double_complex*") DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_double_complex*") DoubleBuffer DOTC);
public static native void cblas_zdotc_sub(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX,
                     @Cast("const __LAPACK_double_complex*") double[] Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_double_complex*") double[] DOTC);


// MARK: DSDOT
public static native float cblas_sdsdot(@Cast("const __LAPACK_int") long N, float ALPHA, @Const FloatPointer X,
                   @Cast("const __LAPACK_int") long INCX, @Const FloatPointer Y, @Cast("const __LAPACK_int") long INCY);
public static native float cblas_sdsdot(@Cast("const __LAPACK_int") long N, float ALPHA, @Const FloatBuffer X,
                   @Cast("const __LAPACK_int") long INCX, @Const FloatBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native float cblas_sdsdot(@Cast("const __LAPACK_int") long N, float ALPHA, @Const float[] X,
                   @Cast("const __LAPACK_int") long INCX, @Const float[] Y, @Cast("const __LAPACK_int") long INCY);


public static native double cblas_dsdot(@Cast("const __LAPACK_int") long N, @Const FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                   @Const FloatPointer Y, @Cast("const __LAPACK_int") long INCY);
public static native double cblas_dsdot(@Cast("const __LAPACK_int") long N, @Const FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                   @Const FloatBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native double cblas_dsdot(@Cast("const __LAPACK_int") long N, @Const float[] X, @Cast("const __LAPACK_int") long INCX,
                   @Const float[] Y, @Cast("const __LAPACK_int") long INCY);


// MARK: NRM2
public static native float cblas_snrm2(@Cast("const __LAPACK_int") long N, @Const FloatPointer X, @Cast("const __LAPACK_int") long INCX);
public static native float cblas_snrm2(@Cast("const __LAPACK_int") long N, @Const FloatBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native float cblas_snrm2(@Cast("const __LAPACK_int") long N, @Const float[] X, @Cast("const __LAPACK_int") long INCX);

public static native double cblas_dnrm2(@Cast("const __LAPACK_int") long N, @Const DoublePointer X, @Cast("const __LAPACK_int") long INCX);
public static native double cblas_dnrm2(@Cast("const __LAPACK_int") long N, @Const DoubleBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native double cblas_dnrm2(@Cast("const __LAPACK_int") long N, @Const double[] X, @Cast("const __LAPACK_int") long INCX);

public static native float cblas_scnrm2(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX);
public static native float cblas_scnrm2(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native float cblas_scnrm2(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX);

public static native double cblas_dznrm2(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX);
public static native double cblas_dznrm2(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native double cblas_dznrm2(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX);


// MARK: ROT
public static native void cblas_srot(@Cast("const __LAPACK_int") long N, FloatPointer X, @Cast("const __LAPACK_int") long INCX, FloatPointer Y,
                @Cast("const __LAPACK_int") long INCY, float C, float S);
public static native void cblas_srot(@Cast("const __LAPACK_int") long N, FloatBuffer X, @Cast("const __LAPACK_int") long INCX, FloatBuffer Y,
                @Cast("const __LAPACK_int") long INCY, float C, float S);
public static native void cblas_srot(@Cast("const __LAPACK_int") long N, float[] X, @Cast("const __LAPACK_int") long INCX, float[] Y,
                @Cast("const __LAPACK_int") long INCY, float C, float S);

public static native void cblas_drot(@Cast("const __LAPACK_int") long N, DoublePointer X, @Cast("const __LAPACK_int") long INCX, DoublePointer Y,
                @Cast("const __LAPACK_int") long INCY, double C, double S);
public static native void cblas_drot(@Cast("const __LAPACK_int") long N, DoubleBuffer X, @Cast("const __LAPACK_int") long INCX, DoubleBuffer Y,
                @Cast("const __LAPACK_int") long INCY, double C, double S);
public static native void cblas_drot(@Cast("const __LAPACK_int") long N, double[] X, @Cast("const __LAPACK_int") long INCX, double[] Y,
                @Cast("const __LAPACK_int") long INCY, double C, double S);

public static native void cblas_csrot(@Cast("const __LAPACK_int") long N, @Cast("__LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX, @Cast("__LAPACK_float_complex*") FloatPointer Y,
                 @Cast("const __LAPACK_int") long INCY, float C, float S);
public static native void cblas_csrot(@Cast("const __LAPACK_int") long N, @Cast("__LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX, @Cast("__LAPACK_float_complex*") FloatBuffer Y,
                 @Cast("const __LAPACK_int") long INCY, float C, float S);
public static native void cblas_csrot(@Cast("const __LAPACK_int") long N, @Cast("__LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX, @Cast("__LAPACK_float_complex*") float[] Y,
                 @Cast("const __LAPACK_int") long INCY, float C, float S);

public static native void cblas_zdrot(@Cast("const __LAPACK_int") long N, @Cast("__LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX, @Cast("__LAPACK_double_complex*") DoublePointer Y,
                 @Cast("const __LAPACK_int") long INCY, double C, double S);
public static native void cblas_zdrot(@Cast("const __LAPACK_int") long N, @Cast("__LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX, @Cast("__LAPACK_double_complex*") DoubleBuffer Y,
                 @Cast("const __LAPACK_int") long INCY, double C, double S);
public static native void cblas_zdrot(@Cast("const __LAPACK_int") long N, @Cast("__LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX, @Cast("__LAPACK_double_complex*") double[] Y,
                 @Cast("const __LAPACK_int") long INCY, double C, double S);


// MARK: ROTG
public static native void cblas_srotg(FloatPointer A, FloatPointer B, FloatPointer C, FloatPointer S);
public static native void cblas_srotg(FloatBuffer A, FloatBuffer B, FloatBuffer C, FloatBuffer S);
public static native void cblas_srotg(float[] A, float[] B, float[] C, float[] S);

public static native void cblas_drotg(DoublePointer A, DoublePointer B, DoublePointer C, DoublePointer S);
public static native void cblas_drotg(DoubleBuffer A, DoubleBuffer B, DoubleBuffer C, DoubleBuffer S);
public static native void cblas_drotg(double[] A, double[] B, double[] C, double[] S);

public static native void cblas_crotg(@Cast("__LAPACK_float_complex*") FloatPointer A, @Cast("__LAPACK_float_complex*") FloatPointer B, FloatPointer C, @Cast("__LAPACK_float_complex*") FloatPointer S);
public static native void cblas_crotg(@Cast("__LAPACK_float_complex*") FloatBuffer A, @Cast("__LAPACK_float_complex*") FloatBuffer B, FloatBuffer C, @Cast("__LAPACK_float_complex*") FloatBuffer S);
public static native void cblas_crotg(@Cast("__LAPACK_float_complex*") float[] A, @Cast("__LAPACK_float_complex*") float[] B, float[] C, @Cast("__LAPACK_float_complex*") float[] S);

public static native void cblas_zrotg(@Cast("__LAPACK_double_complex*") DoublePointer A, @Cast("__LAPACK_double_complex*") DoublePointer B, DoublePointer C, @Cast("__LAPACK_double_complex*") DoublePointer S);
public static native void cblas_zrotg(@Cast("__LAPACK_double_complex*") DoubleBuffer A, @Cast("__LAPACK_double_complex*") DoubleBuffer B, DoubleBuffer C, @Cast("__LAPACK_double_complex*") DoubleBuffer S);
public static native void cblas_zrotg(@Cast("__LAPACK_double_complex*") double[] A, @Cast("__LAPACK_double_complex*") double[] B, double[] C, @Cast("__LAPACK_double_complex*") double[] S);


// MARK: ROTM
public static native void cblas_srotm(@Cast("const __LAPACK_int") long N, FloatPointer X, @Cast("const __LAPACK_int") long INCX, FloatPointer Y,
                 @Cast("const __LAPACK_int") long INCY, @Const FloatPointer P);
public static native void cblas_srotm(@Cast("const __LAPACK_int") long N, FloatBuffer X, @Cast("const __LAPACK_int") long INCX, FloatBuffer Y,
                 @Cast("const __LAPACK_int") long INCY, @Const FloatBuffer P);
public static native void cblas_srotm(@Cast("const __LAPACK_int") long N, float[] X, @Cast("const __LAPACK_int") long INCX, float[] Y,
                 @Cast("const __LAPACK_int") long INCY, @Const float[] P);

public static native void cblas_drotm(@Cast("const __LAPACK_int") long N, DoublePointer X, @Cast("const __LAPACK_int") long INCX, DoublePointer Y,
                 @Cast("const __LAPACK_int") long INCY, @Const DoublePointer P);
public static native void cblas_drotm(@Cast("const __LAPACK_int") long N, DoubleBuffer X, @Cast("const __LAPACK_int") long INCX, DoubleBuffer Y,
                 @Cast("const __LAPACK_int") long INCY, @Const DoubleBuffer P);
public static native void cblas_drotm(@Cast("const __LAPACK_int") long N, double[] X, @Cast("const __LAPACK_int") long INCX, double[] Y,
                 @Cast("const __LAPACK_int") long INCY, @Const double[] P);


// MARK: ROTMG





// MARK: SCAL
public static native void cblas_sscal(@Cast("const __LAPACK_int") long N, float ALPHA, FloatPointer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_sscal(@Cast("const __LAPACK_int") long N, float ALPHA, FloatBuffer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_sscal(@Cast("const __LAPACK_int") long N, float ALPHA, float[] X,
                 @Cast("const __LAPACK_int") long INCX);

public static native void cblas_dscal(@Cast("const __LAPACK_int") long N, double ALPHA, DoublePointer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_dscal(@Cast("const __LAPACK_int") long N, double ALPHA, DoubleBuffer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_dscal(@Cast("const __LAPACK_int") long N, double ALPHA, double[] X,
                 @Cast("const __LAPACK_int") long INCX);

public static native void cblas_cscal(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("__LAPACK_float_complex*") FloatPointer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_cscal(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("__LAPACK_float_complex*") FloatBuffer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_cscal(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("__LAPACK_float_complex*") float[] X,
                 @Cast("const __LAPACK_int") long INCX);

public static native void cblas_zscal(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("__LAPACK_double_complex*") DoublePointer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_zscal(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("__LAPACK_double_complex*") DoubleBuffer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_zscal(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("__LAPACK_double_complex*") double[] X,
                 @Cast("const __LAPACK_int") long INCX);

public static native void cblas_csscal(@Cast("const __LAPACK_int") long N, float ALPHA, @Cast("__LAPACK_float_complex*") FloatPointer X,
                  @Cast("const __LAPACK_int") long INCX);
public static native void cblas_csscal(@Cast("const __LAPACK_int") long N, float ALPHA, @Cast("__LAPACK_float_complex*") FloatBuffer X,
                  @Cast("const __LAPACK_int") long INCX);
public static native void cblas_csscal(@Cast("const __LAPACK_int") long N, float ALPHA, @Cast("__LAPACK_float_complex*") float[] X,
                  @Cast("const __LAPACK_int") long INCX);

public static native void cblas_zdscal(@Cast("const __LAPACK_int") long N, double ALPHA, @Cast("__LAPACK_double_complex*") DoublePointer X,
                  @Cast("const __LAPACK_int") long INCX);
public static native void cblas_zdscal(@Cast("const __LAPACK_int") long N, double ALPHA, @Cast("__LAPACK_double_complex*") DoubleBuffer X,
                  @Cast("const __LAPACK_int") long INCX);
public static native void cblas_zdscal(@Cast("const __LAPACK_int") long N, double ALPHA, @Cast("__LAPACK_double_complex*") double[] X,
                  @Cast("const __LAPACK_int") long INCX);


// MARK: SET
public static native void catlas_sset(@Cast("const __LAPACK_int") long N, float ALPHA, FloatPointer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void catlas_sset(@Cast("const __LAPACK_int") long N, float ALPHA, FloatBuffer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void catlas_sset(@Cast("const __LAPACK_int") long N, float ALPHA, float[] X,
                 @Cast("const __LAPACK_int") long INCX);

public static native void catlas_dset(@Cast("const __LAPACK_int") long N, double ALPHA, DoublePointer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void catlas_dset(@Cast("const __LAPACK_int") long N, double ALPHA, DoubleBuffer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void catlas_dset(@Cast("const __LAPACK_int") long N, double ALPHA, double[] X,
                 @Cast("const __LAPACK_int") long INCX);

public static native void catlas_cset(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("__LAPACK_float_complex*") FloatPointer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void catlas_cset(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("__LAPACK_float_complex*") FloatBuffer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void catlas_cset(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("__LAPACK_float_complex*") float[] X,
                 @Cast("const __LAPACK_int") long INCX);

public static native void catlas_zset(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("__LAPACK_double_complex*") DoublePointer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void catlas_zset(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("__LAPACK_double_complex*") DoubleBuffer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void catlas_zset(@Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("__LAPACK_double_complex*") double[] X,
                 @Cast("const __LAPACK_int") long INCX);


// MARK: SWAP
public static native void cblas_sswap(@Cast("const __LAPACK_int") long N, FloatPointer X, @Cast("const __LAPACK_int") long INCX, FloatPointer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_sswap(@Cast("const __LAPACK_int") long N, FloatBuffer X, @Cast("const __LAPACK_int") long INCX, FloatBuffer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_sswap(@Cast("const __LAPACK_int") long N, float[] X, @Cast("const __LAPACK_int") long INCX, float[] Y,
                 @Cast("const __LAPACK_int") long INCY);

public static native void cblas_dswap(@Cast("const __LAPACK_int") long N, DoublePointer X, @Cast("const __LAPACK_int") long INCX, DoublePointer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_dswap(@Cast("const __LAPACK_int") long N, DoubleBuffer X, @Cast("const __LAPACK_int") long INCX, DoubleBuffer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_dswap(@Cast("const __LAPACK_int") long N, double[] X, @Cast("const __LAPACK_int") long INCX, double[] Y,
                 @Cast("const __LAPACK_int") long INCY);

public static native void cblas_cswap(@Cast("const __LAPACK_int") long N, @Cast("__LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX, @Cast("__LAPACK_float_complex*") FloatPointer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_cswap(@Cast("const __LAPACK_int") long N, @Cast("__LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX, @Cast("__LAPACK_float_complex*") FloatBuffer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_cswap(@Cast("const __LAPACK_int") long N, @Cast("__LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX, @Cast("__LAPACK_float_complex*") float[] Y,
                 @Cast("const __LAPACK_int") long INCY);

public static native void cblas_zswap(@Cast("const __LAPACK_int") long N, @Cast("__LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX, @Cast("__LAPACK_double_complex*") DoublePointer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_zswap(@Cast("const __LAPACK_int") long N, @Cast("__LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX, @Cast("__LAPACK_double_complex*") DoubleBuffer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_zswap(@Cast("const __LAPACK_int") long N, @Cast("__LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX, @Cast("__LAPACK_double_complex*") double[] Y,
                 @Cast("const __LAPACK_int") long INCY);



// MARK: BLAS Level 2


// MARK: GEMV
public static native void cblas_sgemv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 float ALPHA, @Const FloatPointer A, @Cast("const __LAPACK_int") long LDA,
                 @Const FloatPointer X, @Cast("const __LAPACK_int") long INCX, float BETA, FloatPointer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_sgemv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 float ALPHA, @Const FloatBuffer A, @Cast("const __LAPACK_int") long LDA,
                 @Const FloatBuffer X, @Cast("const __LAPACK_int") long INCX, float BETA, FloatBuffer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_sgemv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 float ALPHA, @Const float[] A, @Cast("const __LAPACK_int") long LDA,
                 @Const float[] X, @Cast("const __LAPACK_int") long INCX, float BETA, float[] Y,
                 @Cast("const __LAPACK_int") long INCY);

public static native void cblas_dgemv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 double ALPHA, @Const DoublePointer A, @Cast("const __LAPACK_int") long LDA,
                 @Const DoublePointer X, @Cast("const __LAPACK_int") long INCX, double BETA, DoublePointer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_dgemv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 double ALPHA, @Const DoubleBuffer A, @Cast("const __LAPACK_int") long LDA,
                 @Const DoubleBuffer X, @Cast("const __LAPACK_int") long INCX, double BETA, DoubleBuffer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_dgemv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 double ALPHA, @Const double[] A, @Cast("const __LAPACK_int") long LDA,
                 @Const double[] X, @Cast("const __LAPACK_int") long INCX, double BETA, double[] Y,
                 @Cast("const __LAPACK_int") long INCY);

public static native void cblas_cgemv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") FloatPointer X,
                 @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_float_complex*") FloatPointer BETA, @Cast("__LAPACK_float_complex*") FloatPointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_cgemv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") FloatBuffer X,
                 @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_float_complex*") FloatBuffer BETA, @Cast("__LAPACK_float_complex*") FloatBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_cgemv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") float[] X,
                 @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_float_complex*") float[] BETA, @Cast("__LAPACK_float_complex*") float[] Y, @Cast("const __LAPACK_int") long INCY);

public static native void cblas_zgemv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") DoublePointer X,
                 @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_double_complex*") DoublePointer BETA, @Cast("__LAPACK_double_complex*") DoublePointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_zgemv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") DoubleBuffer X,
                 @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_double_complex*") DoubleBuffer BETA, @Cast("__LAPACK_double_complex*") DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_zgemv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") double[] X,
                 @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_double_complex*") double[] BETA, @Cast("__LAPACK_double_complex*") double[] Y, @Cast("const __LAPACK_int") long INCY);


// MARK: GBMV
public static native void cblas_sgbmv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long KL, @Cast("const __LAPACK_int") long KU, float ALPHA, @Const FloatPointer A,
                 @Cast("const __LAPACK_int") long LDA, @Const FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                 float BETA, FloatPointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_sgbmv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long KL, @Cast("const __LAPACK_int") long KU, float ALPHA, @Const FloatBuffer A,
                 @Cast("const __LAPACK_int") long LDA, @Const FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                 float BETA, FloatBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_sgbmv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long KL, @Cast("const __LAPACK_int") long KU, float ALPHA, @Const float[] A,
                 @Cast("const __LAPACK_int") long LDA, @Const float[] X, @Cast("const __LAPACK_int") long INCX,
                 float BETA, float[] Y, @Cast("const __LAPACK_int") long INCY);

public static native void cblas_dgbmv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long KL, @Cast("const __LAPACK_int") long KU, double ALPHA,
                 @Const DoublePointer A, @Cast("const __LAPACK_int") long LDA, @Const DoublePointer X,
                 @Cast("const __LAPACK_int") long INCX, double BETA, DoublePointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_dgbmv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long KL, @Cast("const __LAPACK_int") long KU, double ALPHA,
                 @Const DoubleBuffer A, @Cast("const __LAPACK_int") long LDA, @Const DoubleBuffer X,
                 @Cast("const __LAPACK_int") long INCX, double BETA, DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_dgbmv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long KL, @Cast("const __LAPACK_int") long KU, double ALPHA,
                 @Const double[] A, @Cast("const __LAPACK_int") long LDA, @Const double[] X,
                 @Cast("const __LAPACK_int") long INCX, double BETA, double[] Y, @Cast("const __LAPACK_int") long INCY);

public static native void cblas_cgbmv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long KL, @Cast("const __LAPACK_int") long KU, @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer A,
                 @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_float_complex*") FloatPointer BETA,
                 @Cast("__LAPACK_float_complex*") FloatPointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_cgbmv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long KL, @Cast("const __LAPACK_int") long KU, @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer A,
                 @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_float_complex*") FloatBuffer BETA,
                 @Cast("__LAPACK_float_complex*") FloatBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_cgbmv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long KL, @Cast("const __LAPACK_int") long KU, @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] A,
                 @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_float_complex*") float[] BETA,
                 @Cast("__LAPACK_float_complex*") float[] Y, @Cast("const __LAPACK_int") long INCY);

public static native void cblas_zgbmv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long KL, @Cast("const __LAPACK_int") long KU, @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer A,
                 @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_double_complex*") DoublePointer BETA,
                 @Cast("__LAPACK_double_complex*") DoublePointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_zgbmv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long KL, @Cast("const __LAPACK_int") long KU, @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer A,
                 @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_double_complex*") DoubleBuffer BETA,
                 @Cast("__LAPACK_double_complex*") DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_zgbmv(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long KL, @Cast("const __LAPACK_int") long KU, @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] A,
                 @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_double_complex*") double[] BETA,
                 @Cast("__LAPACK_double_complex*") double[] Y, @Cast("const __LAPACK_int") long INCY);

// MARK: GER
public static native void cblas_sger(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                float ALPHA, @Const FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                @Const FloatPointer Y, @Cast("const __LAPACK_int") long INCY, FloatPointer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_sger(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                float ALPHA, @Const FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                @Const FloatBuffer Y, @Cast("const __LAPACK_int") long INCY, FloatBuffer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_sger(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                float ALPHA, @Const float[] X, @Cast("const __LAPACK_int") long INCX,
                @Const float[] Y, @Cast("const __LAPACK_int") long INCY, float[] A, @Cast("const __LAPACK_int") long LDA);

public static native void cblas_dger(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                double ALPHA, @Const DoublePointer X, @Cast("const __LAPACK_int") long INCX,
                @Const DoublePointer Y, @Cast("const __LAPACK_int") long INCY, DoublePointer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_dger(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                double ALPHA, @Const DoubleBuffer X, @Cast("const __LAPACK_int") long INCX,
                @Const DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY, DoubleBuffer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_dger(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                double ALPHA, @Const double[] X, @Cast("const __LAPACK_int") long INCX,
                @Const double[] Y, @Cast("const __LAPACK_int") long INCY, double[] A, @Cast("const __LAPACK_int") long LDA);

// MARK: GERC
public static native void cblas_cgerc(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_float_complex*") FloatPointer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_cgerc(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_float_complex*") FloatBuffer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_cgerc(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_float_complex*") float[] Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA);

public static native void cblas_zgerc(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_double_complex*") DoublePointer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_zgerc(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_double_complex*") DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_zgerc(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_double_complex*") double[] Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA);

// MARK: GERU
public static native void cblas_cgeru(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_float_complex*") FloatPointer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_cgeru(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_float_complex*") FloatBuffer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_cgeru(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_float_complex*") float[] Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA);

public static native void cblas_zgeru(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_double_complex*") DoublePointer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_zgeru(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_double_complex*") DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_zgeru(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_double_complex*") double[] Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA);

// MARK: HBMV
public static native void cblas_chbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer A,
                 @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_float_complex*") FloatPointer BETA,
                 @Cast("__LAPACK_float_complex*") FloatPointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_chbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer A,
                 @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_float_complex*") FloatBuffer BETA,
                 @Cast("__LAPACK_float_complex*") FloatBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_chbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] A,
                 @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_float_complex*") float[] BETA,
                 @Cast("__LAPACK_float_complex*") float[] Y, @Cast("const __LAPACK_int") long INCY);

public static native void cblas_zhbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer A,
                 @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_double_complex*") DoublePointer BETA,
                 @Cast("__LAPACK_double_complex*") DoublePointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_zhbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer A,
                 @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_double_complex*") DoubleBuffer BETA,
                 @Cast("__LAPACK_double_complex*") DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_zhbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] A,
                 @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_double_complex*") double[] BETA,
                 @Cast("__LAPACK_double_complex*") double[] Y, @Cast("const __LAPACK_int") long INCY);

// MARK: HEMV
public static native void cblas_chemv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("const __LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_float_complex*") FloatPointer BETA, @Cast("__LAPACK_float_complex*") FloatPointer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_chemv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("const __LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_float_complex*") FloatBuffer BETA, @Cast("__LAPACK_float_complex*") FloatBuffer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_chemv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("const __LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_float_complex*") float[] BETA, @Cast("__LAPACK_float_complex*") float[] Y,
                 @Cast("const __LAPACK_int") long INCY);

public static native void cblas_zhemv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("const __LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_double_complex*") DoublePointer BETA, @Cast("__LAPACK_double_complex*") DoublePointer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_zhemv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("const __LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_double_complex*") DoubleBuffer BETA, @Cast("__LAPACK_double_complex*") DoubleBuffer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_zhemv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("const __LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_double_complex*") double[] BETA, @Cast("__LAPACK_double_complex*") double[] Y,
                 @Cast("const __LAPACK_int") long INCY);

// MARK: HER
public static native void cblas_cher(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, float ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                @Cast("__LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_cher(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, float ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                @Cast("__LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_cher(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, float ALPHA, @Cast("const __LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX,
                @Cast("__LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA);

public static native void cblas_zher(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, double ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX,
                @Cast("__LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_zher(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, double ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX,
                @Cast("__LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_zher(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, double ALPHA, @Cast("const __LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX,
                @Cast("__LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA);

// MARK: HER2
public static native void cblas_cher2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_float_complex*") FloatPointer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_cher2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_float_complex*") FloatBuffer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_cher2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_float_complex*") float[] Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA);

public static native void cblas_zher2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_double_complex*") DoublePointer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_zher2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_double_complex*") DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_zher2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_double_complex*") double[] Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA);

// MARK: HPMV
public static native void cblas_chpmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer AP, @Cast("const __LAPACK_float_complex*") FloatPointer X,
                 @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_float_complex*") FloatPointer BETA, @Cast("__LAPACK_float_complex*") FloatPointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_chpmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer AP, @Cast("const __LAPACK_float_complex*") FloatBuffer X,
                 @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_float_complex*") FloatBuffer BETA, @Cast("__LAPACK_float_complex*") FloatBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_chpmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] AP, @Cast("const __LAPACK_float_complex*") float[] X,
                 @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_float_complex*") float[] BETA, @Cast("__LAPACK_float_complex*") float[] Y, @Cast("const __LAPACK_int") long INCY);

public static native void cblas_zhpmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer AP, @Cast("const __LAPACK_double_complex*") DoublePointer X,
                 @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_double_complex*") DoublePointer BETA, @Cast("__LAPACK_double_complex*") DoublePointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_zhpmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer AP, @Cast("const __LAPACK_double_complex*") DoubleBuffer X,
                 @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_double_complex*") DoubleBuffer BETA, @Cast("__LAPACK_double_complex*") DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_zhpmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] AP, @Cast("const __LAPACK_double_complex*") double[] X,
                 @Cast("const __LAPACK_int") long INCX, @Cast("const __LAPACK_double_complex*") double[] BETA, @Cast("__LAPACK_double_complex*") double[] Y, @Cast("const __LAPACK_int") long INCY);

// MARK: HPR
public static native void cblas_chpr(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, float ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                @Cast("__LAPACK_float_complex*") FloatPointer A);
public static native void cblas_chpr(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, float ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                @Cast("__LAPACK_float_complex*") FloatBuffer A);
public static native void cblas_chpr(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, float ALPHA, @Cast("const __LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX,
                @Cast("__LAPACK_float_complex*") float[] A);

public static native void cblas_zhpr(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, double ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX,
                @Cast("__LAPACK_double_complex*") DoublePointer A);
public static native void cblas_zhpr(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, double ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX,
                @Cast("__LAPACK_double_complex*") DoubleBuffer A);
public static native void cblas_zhpr(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, double ALPHA, @Cast("const __LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX,
                @Cast("__LAPACK_double_complex*") double[] A);

// MARK: HPR2
public static native void cblas_chpr2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_float_complex*") FloatPointer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_float_complex*") FloatPointer AP);
public static native void cblas_chpr2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_float_complex*") FloatBuffer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_float_complex*") FloatBuffer AP);
public static native void cblas_chpr2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_float_complex*") float[] Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_float_complex*") float[] AP);

public static native void cblas_zhpr2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_double_complex*") DoublePointer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_double_complex*") DoublePointer AP);
public static native void cblas_zhpr2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_double_complex*") DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_double_complex*") DoubleBuffer AP);
public static native void cblas_zhpr2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX,
                 @Cast("const __LAPACK_double_complex*") double[] Y, @Cast("const __LAPACK_int") long INCY, @Cast("__LAPACK_double_complex*") double[] AP);

// MARK: SBMV
public static native void cblas_ssbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, float ALPHA, @Const FloatPointer A,
                 @Cast("const __LAPACK_int") long LDA, @Const FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                 float BETA, FloatPointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_ssbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, float ALPHA, @Const FloatBuffer A,
                 @Cast("const __LAPACK_int") long LDA, @Const FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                 float BETA, FloatBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_ssbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, float ALPHA, @Const float[] A,
                 @Cast("const __LAPACK_int") long LDA, @Const float[] X, @Cast("const __LAPACK_int") long INCX,
                 float BETA, float[] Y, @Cast("const __LAPACK_int") long INCY);

public static native void cblas_dsbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, double ALPHA, @Const DoublePointer A,
                 @Cast("const __LAPACK_int") long LDA, @Const DoublePointer X, @Cast("const __LAPACK_int") long INCX,
                 double BETA, DoublePointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_dsbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, double ALPHA, @Const DoubleBuffer A,
                 @Cast("const __LAPACK_int") long LDA, @Const DoubleBuffer X, @Cast("const __LAPACK_int") long INCX,
                 double BETA, DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_dsbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, double ALPHA, @Const double[] A,
                 @Cast("const __LAPACK_int") long LDA, @Const double[] X, @Cast("const __LAPACK_int") long INCX,
                 double BETA, double[] Y, @Cast("const __LAPACK_int") long INCY);

// MARK: SPMV
public static native void cblas_sspmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, float ALPHA, @Const FloatPointer AP,
                 @Const FloatPointer X, @Cast("const __LAPACK_int") long INCX, float BETA, FloatPointer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_sspmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, float ALPHA, @Const FloatBuffer AP,
                 @Const FloatBuffer X, @Cast("const __LAPACK_int") long INCX, float BETA, FloatBuffer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_sspmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, float ALPHA, @Const float[] AP,
                 @Const float[] X, @Cast("const __LAPACK_int") long INCX, float BETA, float[] Y,
                 @Cast("const __LAPACK_int") long INCY);

public static native void cblas_dspmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, double ALPHA, @Const DoublePointer AP,
                 @Const DoublePointer X, @Cast("const __LAPACK_int") long INCX, double BETA, DoublePointer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_dspmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, double ALPHA, @Const DoubleBuffer AP,
                 @Const DoubleBuffer X, @Cast("const __LAPACK_int") long INCX, double BETA, DoubleBuffer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_dspmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, double ALPHA, @Const double[] AP,
                 @Const double[] X, @Cast("const __LAPACK_int") long INCX, double BETA, double[] Y,
                 @Cast("const __LAPACK_int") long INCY);

// MARK: SPR
public static native void cblas_sspr(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, float ALPHA, @Const FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                FloatPointer AP);
public static native void cblas_sspr(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, float ALPHA, @Const FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                FloatBuffer AP);
public static native void cblas_sspr(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, float ALPHA, @Const float[] X, @Cast("const __LAPACK_int") long INCX,
                float[] AP);

public static native void cblas_dspr(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, double ALPHA, @Const DoublePointer X,
                @Cast("const __LAPACK_int") long INCX, DoublePointer AP);
public static native void cblas_dspr(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, double ALPHA, @Const DoubleBuffer X,
                @Cast("const __LAPACK_int") long INCX, DoubleBuffer AP);
public static native void cblas_dspr(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, double ALPHA, @Const double[] X,
                @Cast("const __LAPACK_int") long INCX, double[] AP);

// MARK: SPR2
public static native void cblas_sspr2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, float ALPHA, @Const FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                 @Const FloatPointer Y, @Cast("const __LAPACK_int") long INCY, FloatPointer A);
public static native void cblas_sspr2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, float ALPHA, @Const FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                 @Const FloatBuffer Y, @Cast("const __LAPACK_int") long INCY, FloatBuffer A);
public static native void cblas_sspr2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, float ALPHA, @Const float[] X, @Cast("const __LAPACK_int") long INCX,
                 @Const float[] Y, @Cast("const __LAPACK_int") long INCY, float[] A);

public static native void cblas_dspr2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, double ALPHA, @Const DoublePointer X,
                 @Cast("const __LAPACK_int") long INCX, @Const DoublePointer Y, @Cast("const __LAPACK_int") long INCY, DoublePointer A);
public static native void cblas_dspr2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, double ALPHA, @Const DoubleBuffer X,
                 @Cast("const __LAPACK_int") long INCX, @Const DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY, DoubleBuffer A);
public static native void cblas_dspr2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, double ALPHA, @Const double[] X,
                 @Cast("const __LAPACK_int") long INCX, @Const double[] Y, @Cast("const __LAPACK_int") long INCY, double[] A);

// MARK: SYMV
public static native void cblas_ssymv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, float ALPHA, @Const FloatPointer A, @Cast("const __LAPACK_int") long LDA,
                 @Const FloatPointer X, @Cast("const __LAPACK_int") long INCX, float BETA, FloatPointer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_ssymv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, float ALPHA, @Const FloatBuffer A, @Cast("const __LAPACK_int") long LDA,
                 @Const FloatBuffer X, @Cast("const __LAPACK_int") long INCX, float BETA, FloatBuffer Y,
                 @Cast("const __LAPACK_int") long INCY);
public static native void cblas_ssymv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, float ALPHA, @Const float[] A, @Cast("const __LAPACK_int") long LDA,
                 @Const float[] X, @Cast("const __LAPACK_int") long INCX, float BETA, float[] Y,
                 @Cast("const __LAPACK_int") long INCY);

public static native void cblas_dsymv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, double ALPHA, @Const DoublePointer A,
                 @Cast("const __LAPACK_int") long LDA, @Const DoublePointer X, @Cast("const __LAPACK_int") long INCX,
                 double BETA, DoublePointer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_dsymv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, double ALPHA, @Const DoubleBuffer A,
                 @Cast("const __LAPACK_int") long LDA, @Const DoubleBuffer X, @Cast("const __LAPACK_int") long INCX,
                 double BETA, DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY);
public static native void cblas_dsymv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, double ALPHA, @Const double[] A,
                 @Cast("const __LAPACK_int") long LDA, @Const double[] X, @Cast("const __LAPACK_int") long INCX,
                 double BETA, double[] Y, @Cast("const __LAPACK_int") long INCY);

// MARK: SYR
public static native void cblas_ssyr(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, float ALPHA, @Const FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                FloatPointer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_ssyr(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, float ALPHA, @Const FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                FloatBuffer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_ssyr(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, float ALPHA, @Const float[] X, @Cast("const __LAPACK_int") long INCX,
                float[] A, @Cast("const __LAPACK_int") long LDA);

public static native void cblas_dsyr(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, double ALPHA, @Const DoublePointer X,
                @Cast("const __LAPACK_int") long INCX, DoublePointer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_dsyr(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, double ALPHA, @Const DoubleBuffer X,
                @Cast("const __LAPACK_int") long INCX, DoubleBuffer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_dsyr(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                @Cast("const __LAPACK_int") long N, double ALPHA, @Const double[] X,
                @Cast("const __LAPACK_int") long INCX, double[] A, @Cast("const __LAPACK_int") long LDA);

// MARK: SYR2
public static native void cblas_ssyr2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, float ALPHA, @Const FloatPointer X, @Cast("const __LAPACK_int") long INCX,
                 @Const FloatPointer Y, @Cast("const __LAPACK_int") long INCY, FloatPointer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_ssyr2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, float ALPHA, @Const FloatBuffer X, @Cast("const __LAPACK_int") long INCX,
                 @Const FloatBuffer Y, @Cast("const __LAPACK_int") long INCY, FloatBuffer A, @Cast("const __LAPACK_int") long LDA);
public static native void cblas_ssyr2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, float ALPHA, @Const float[] X, @Cast("const __LAPACK_int") long INCX,
                 @Const float[] Y, @Cast("const __LAPACK_int") long INCY, float[] A, @Cast("const __LAPACK_int") long LDA);

public static native void cblas_dsyr2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, double ALPHA, @Const DoublePointer X,
                 @Cast("const __LAPACK_int") long INCX, @Const DoublePointer Y, @Cast("const __LAPACK_int") long INCY, DoublePointer A,
                 @Cast("const __LAPACK_int") long LDA);
public static native void cblas_dsyr2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, double ALPHA, @Const DoubleBuffer X,
                 @Cast("const __LAPACK_int") long INCX, @Const DoubleBuffer Y, @Cast("const __LAPACK_int") long INCY, DoubleBuffer A,
                 @Cast("const __LAPACK_int") long LDA);
public static native void cblas_dsyr2(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const __LAPACK_int") long N, double ALPHA, @Const double[] X,
                 @Cast("const __LAPACK_int") long INCX, @Const double[] Y, @Cast("const __LAPACK_int") long INCY, double[] A,
                 @Cast("const __LAPACK_int") long LDA);

// MARK: TBMV
public static native void cblas_stbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Const FloatPointer A, @Cast("const __LAPACK_int") long LDA,
                 FloatPointer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_stbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Const FloatBuffer A, @Cast("const __LAPACK_int") long LDA,
                 FloatBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_stbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Const float[] A, @Cast("const __LAPACK_int") long LDA,
                 float[] X, @Cast("const __LAPACK_int") long INCX);

public static native void cblas_dtbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Const DoublePointer A, @Cast("const __LAPACK_int") long LDA,
                 DoublePointer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_dtbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Const DoubleBuffer A, @Cast("const __LAPACK_int") long LDA,
                 DoubleBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_dtbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Const double[] A, @Cast("const __LAPACK_int") long LDA,
                 double[] X, @Cast("const __LAPACK_int") long INCX);

public static native void cblas_ctbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("__LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ctbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("__LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ctbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("__LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX);

public static native void cblas_ztbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("__LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ztbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("__LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ztbmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("__LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX);

// MARK: TBSV
public static native void cblas_stbsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Const FloatPointer A, @Cast("const __LAPACK_int") long LDA,
                 FloatPointer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_stbsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Const FloatBuffer A, @Cast("const __LAPACK_int") long LDA,
                 FloatBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_stbsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Const float[] A, @Cast("const __LAPACK_int") long LDA,
                 float[] X, @Cast("const __LAPACK_int") long INCX);

public static native void cblas_dtbsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Const DoublePointer A, @Cast("const __LAPACK_int") long LDA,
                 DoublePointer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_dtbsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Const DoubleBuffer A, @Cast("const __LAPACK_int") long LDA,
                 DoubleBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_dtbsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Const double[] A, @Cast("const __LAPACK_int") long LDA,
                 double[] X, @Cast("const __LAPACK_int") long INCX);

public static native void cblas_ctbsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("__LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ctbsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("__LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ctbsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("__LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX);

public static native void cblas_ztbsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("__LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ztbsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("__LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ztbsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("__LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX);

// MARK: TPMV
public static native void cblas_stpmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const FloatPointer AP, FloatPointer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_stpmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const FloatBuffer AP, FloatBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_stpmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const float[] AP, float[] X, @Cast("const __LAPACK_int") long INCX);

public static native void cblas_dtpmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const DoublePointer AP, DoublePointer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_dtpmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const DoubleBuffer AP, DoubleBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_dtpmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const double[] AP, double[] X, @Cast("const __LAPACK_int") long INCX);

public static native void cblas_ctpmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatPointer AP, @Cast("__LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ctpmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatBuffer AP, @Cast("__LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ctpmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") float[] AP, @Cast("__LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX);

public static native void cblas_ztpmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoublePointer AP, @Cast("__LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ztpmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoubleBuffer AP, @Cast("__LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ztpmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") double[] AP, @Cast("__LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX);

// MARK: TPSV
public static native void cblas_stpsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const FloatPointer AP, FloatPointer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_stpsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const FloatBuffer AP, FloatBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_stpsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const float[] AP, float[] X, @Cast("const __LAPACK_int") long INCX);

public static native void cblas_dtpsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const DoublePointer AP, DoublePointer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_dtpsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const DoubleBuffer AP, DoubleBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_dtpsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const double[] AP, double[] X, @Cast("const __LAPACK_int") long INCX);

public static native void cblas_ctpsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatPointer AP, @Cast("__LAPACK_float_complex*") FloatPointer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ctpsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatBuffer AP, @Cast("__LAPACK_float_complex*") FloatBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ctpsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") float[] AP, @Cast("__LAPACK_float_complex*") float[] X, @Cast("const __LAPACK_int") long INCX);

public static native void cblas_ztpsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoublePointer AP, @Cast("__LAPACK_double_complex*") DoublePointer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ztpsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoubleBuffer AP, @Cast("__LAPACK_double_complex*") DoubleBuffer X, @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ztpsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") double[] AP, @Cast("__LAPACK_double_complex*") double[] X, @Cast("const __LAPACK_int") long INCX);


// MARK: TRMV
public static native void cblas_strmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const FloatPointer A, @Cast("const __LAPACK_int") long LDA, FloatPointer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_strmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const FloatBuffer A, @Cast("const __LAPACK_int") long LDA, FloatBuffer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_strmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const float[] A, @Cast("const __LAPACK_int") long LDA, float[] X,
                 @Cast("const __LAPACK_int") long INCX);

public static native void cblas_dtrmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const DoublePointer A, @Cast("const __LAPACK_int") long LDA, DoublePointer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_dtrmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const DoubleBuffer A, @Cast("const __LAPACK_int") long LDA, DoubleBuffer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_dtrmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const double[] A, @Cast("const __LAPACK_int") long LDA, double[] X,
                 @Cast("const __LAPACK_int") long INCX);

public static native void cblas_ctrmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_float_complex*") FloatPointer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ctrmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_float_complex*") FloatBuffer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ctrmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_float_complex*") float[] X,
                 @Cast("const __LAPACK_int") long INCX);

public static native void cblas_ztrmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_double_complex*") DoublePointer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ztrmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_double_complex*") DoubleBuffer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ztrmv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_double_complex*") double[] X,
                 @Cast("const __LAPACK_int") long INCX);

// MARK: TRSV
public static native void cblas_strsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const FloatPointer A, @Cast("const __LAPACK_int") long LDA, FloatPointer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_strsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const FloatBuffer A, @Cast("const __LAPACK_int") long LDA, FloatBuffer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_strsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const float[] A, @Cast("const __LAPACK_int") long LDA, float[] X,
                 @Cast("const __LAPACK_int") long INCX);

public static native void cblas_dtrsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const DoublePointer A, @Cast("const __LAPACK_int") long LDA, DoublePointer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_dtrsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const DoubleBuffer A, @Cast("const __LAPACK_int") long LDA, DoubleBuffer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_dtrsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Const double[] A, @Cast("const __LAPACK_int") long LDA, double[] X,
                 @Cast("const __LAPACK_int") long INCX);

public static native void cblas_ctrsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_float_complex*") FloatPointer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ctrsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_float_complex*") FloatBuffer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ctrsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_float_complex*") float[] X,
                 @Cast("const __LAPACK_int") long INCX);

public static native void cblas_ztrsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_double_complex*") DoublePointer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ztrsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_double_complex*") DoubleBuffer X,
                 @Cast("const __LAPACK_int") long INCX);
public static native void cblas_ztrsv(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA, @Cast("const CBLAS_DIAG") int DIAG,
                 @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_double_complex*") double[] X,
                 @Cast("const __LAPACK_int") long INCX);

// MARK: BLAS Level 3

// MARK: GEMM
public static native void cblas_sgemm(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSB, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long K, float ALPHA, @Const FloatPointer A, @Cast("const __LAPACK_int") long LDA,
                 @Const FloatPointer B, @Cast("const __LAPACK_int") long LDB, float BETA, FloatPointer C,
                 @Cast("const __LAPACK_int") long LDC);
public static native void cblas_sgemm(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSB, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long K, float ALPHA, @Const FloatBuffer A, @Cast("const __LAPACK_int") long LDA,
                 @Const FloatBuffer B, @Cast("const __LAPACK_int") long LDB, float BETA, FloatBuffer C,
                 @Cast("const __LAPACK_int") long LDC);
public static native void cblas_sgemm(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSB, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long K, float ALPHA, @Const float[] A, @Cast("const __LAPACK_int") long LDA,
                 @Const float[] B, @Cast("const __LAPACK_int") long LDB, float BETA, float[] C,
                 @Cast("const __LAPACK_int") long LDC);

public static native void cblas_dgemm(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSB, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long K, double ALPHA, @Const DoublePointer A,
                 @Cast("const __LAPACK_int") long LDA, @Const DoublePointer B, @Cast("const __LAPACK_int") long LDB,
                 double BETA, DoublePointer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_dgemm(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSB, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long K, double ALPHA, @Const DoubleBuffer A,
                 @Cast("const __LAPACK_int") long LDA, @Const DoubleBuffer B, @Cast("const __LAPACK_int") long LDB,
                 double BETA, DoubleBuffer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_dgemm(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSB, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long K, double ALPHA, @Const double[] A,
                 @Cast("const __LAPACK_int") long LDA, @Const double[] B, @Cast("const __LAPACK_int") long LDB,
                 double BETA, double[] C, @Cast("const __LAPACK_int") long LDC);

public static native void cblas_cgemm(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSB, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("const __LAPACK_float_complex*") FloatPointer B, @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_float_complex*") FloatPointer BETA, @Cast("__LAPACK_float_complex*") FloatPointer C,
                 @Cast("const __LAPACK_int") long LDC);
public static native void cblas_cgemm(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSB, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("const __LAPACK_float_complex*") FloatBuffer B, @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_float_complex*") FloatBuffer BETA, @Cast("__LAPACK_float_complex*") FloatBuffer C,
                 @Cast("const __LAPACK_int") long LDC);
public static native void cblas_cgemm(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSB, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("const __LAPACK_float_complex*") float[] B, @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_float_complex*") float[] BETA, @Cast("__LAPACK_float_complex*") float[] C,
                 @Cast("const __LAPACK_int") long LDC);

public static native void cblas_zgemm(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSB, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("const __LAPACK_double_complex*") DoublePointer B, @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_double_complex*") DoublePointer BETA, @Cast("__LAPACK_double_complex*") DoublePointer C,
                 @Cast("const __LAPACK_int") long LDC);
public static native void cblas_zgemm(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSB, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("const __LAPACK_double_complex*") DoubleBuffer B, @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_double_complex*") DoubleBuffer BETA, @Cast("__LAPACK_double_complex*") DoubleBuffer C,
                 @Cast("const __LAPACK_int") long LDC);
public static native void cblas_zgemm(@Cast("const CBLAS_ORDER") int ORDER,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_TRANSPOSE") int TRANSB, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_int") long K, @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("const __LAPACK_double_complex*") double[] B, @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_double_complex*") double[] BETA, @Cast("__LAPACK_double_complex*") double[] C,
                 @Cast("const __LAPACK_int") long LDC);

// MARK: HEMM
public static native void cblas_chemm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") FloatPointer B,
                 @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_float_complex*") FloatPointer BETA, @Cast("__LAPACK_float_complex*") FloatPointer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_chemm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") FloatBuffer B,
                 @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_float_complex*") FloatBuffer BETA, @Cast("__LAPACK_float_complex*") FloatBuffer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_chemm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") float[] B,
                 @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_float_complex*") float[] BETA, @Cast("__LAPACK_float_complex*") float[] C, @Cast("const __LAPACK_int") long LDC);

public static native void cblas_zhemm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") DoublePointer B,
                 @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_double_complex*") DoublePointer BETA, @Cast("__LAPACK_double_complex*") DoublePointer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_zhemm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") DoubleBuffer B,
                 @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_double_complex*") DoubleBuffer BETA, @Cast("__LAPACK_double_complex*") DoubleBuffer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_zhemm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") double[] B,
                 @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_double_complex*") double[] BETA, @Cast("__LAPACK_double_complex*") double[] C, @Cast("const __LAPACK_int") long LDC);

// MARK: HERK
public static native void cblas_cherk(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                 float ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA,
                 float BETA, @Cast("__LAPACK_float_complex*") FloatPointer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_cherk(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                 float ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA,
                 float BETA, @Cast("__LAPACK_float_complex*") FloatBuffer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_cherk(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                 float ALPHA, @Cast("const __LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA,
                 float BETA, @Cast("__LAPACK_float_complex*") float[] C, @Cast("const __LAPACK_int") long LDC);

public static native void cblas_zherk(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                 double ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA,
                 double BETA, @Cast("__LAPACK_double_complex*") DoublePointer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_zherk(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                 double ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA,
                 double BETA, @Cast("__LAPACK_double_complex*") DoubleBuffer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_zherk(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                 double ALPHA, @Cast("const __LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA,
                 double BETA, @Cast("__LAPACK_double_complex*") double[] C, @Cast("const __LAPACK_int") long LDC);

// MARK: HER2K
public static native void cblas_cher2k(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                  @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                  @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") FloatPointer B,
                  @Cast("const __LAPACK_int") long LDB, float BETA, @Cast("__LAPACK_float_complex*") FloatPointer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_cher2k(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                  @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                  @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") FloatBuffer B,
                  @Cast("const __LAPACK_int") long LDB, float BETA, @Cast("__LAPACK_float_complex*") FloatBuffer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_cher2k(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                  @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                  @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") float[] B,
                  @Cast("const __LAPACK_int") long LDB, float BETA, @Cast("__LAPACK_float_complex*") float[] C, @Cast("const __LAPACK_int") long LDC);

public static native void cblas_zher2k(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                  @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                  @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") DoublePointer B,
                  @Cast("const __LAPACK_int") long LDB, double BETA, @Cast("__LAPACK_double_complex*") DoublePointer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_zher2k(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                  @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                  @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") DoubleBuffer B,
                  @Cast("const __LAPACK_int") long LDB, double BETA, @Cast("__LAPACK_double_complex*") DoubleBuffer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_zher2k(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                  @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                  @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") double[] B,
                  @Cast("const __LAPACK_int") long LDB, double BETA, @Cast("__LAPACK_double_complex*") double[] C, @Cast("const __LAPACK_int") long LDC);

// MARK: SYMM
public static native void cblas_ssymm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 float ALPHA, @Const FloatPointer A, @Cast("const __LAPACK_int") long LDA,
                 @Const FloatPointer B, @Cast("const __LAPACK_int") long LDB, float BETA, FloatPointer C,
                 @Cast("const __LAPACK_int") long LDC);
public static native void cblas_ssymm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 float ALPHA, @Const FloatBuffer A, @Cast("const __LAPACK_int") long LDA,
                 @Const FloatBuffer B, @Cast("const __LAPACK_int") long LDB, float BETA, FloatBuffer C,
                 @Cast("const __LAPACK_int") long LDC);
public static native void cblas_ssymm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 float ALPHA, @Const float[] A, @Cast("const __LAPACK_int") long LDA,
                 @Const float[] B, @Cast("const __LAPACK_int") long LDB, float BETA, float[] C,
                 @Cast("const __LAPACK_int") long LDC);

public static native void cblas_dsymm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 double ALPHA, @Const DoublePointer A, @Cast("const __LAPACK_int") long LDA,
                 @Const DoublePointer B, @Cast("const __LAPACK_int") long LDB, double BETA, DoublePointer C,
                 @Cast("const __LAPACK_int") long LDC);
public static native void cblas_dsymm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 double ALPHA, @Const DoubleBuffer A, @Cast("const __LAPACK_int") long LDA,
                 @Const DoubleBuffer B, @Cast("const __LAPACK_int") long LDB, double BETA, DoubleBuffer C,
                 @Cast("const __LAPACK_int") long LDC);
public static native void cblas_dsymm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 double ALPHA, @Const double[] A, @Cast("const __LAPACK_int") long LDA,
                 @Const double[] B, @Cast("const __LAPACK_int") long LDB, double BETA, double[] C,
                 @Cast("const __LAPACK_int") long LDC);

public static native void cblas_csymm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") FloatPointer B,
                 @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_float_complex*") FloatPointer BETA, @Cast("__LAPACK_float_complex*") FloatPointer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_csymm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") FloatBuffer B,
                 @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_float_complex*") FloatBuffer BETA, @Cast("__LAPACK_float_complex*") FloatBuffer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_csymm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") float[] B,
                 @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_float_complex*") float[] BETA, @Cast("__LAPACK_float_complex*") float[] C, @Cast("const __LAPACK_int") long LDC);

public static native void cblas_zsymm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") DoublePointer B,
                 @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_double_complex*") DoublePointer BETA, @Cast("__LAPACK_double_complex*") DoublePointer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_zsymm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") DoubleBuffer B,
                 @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_double_complex*") DoubleBuffer BETA, @Cast("__LAPACK_double_complex*") DoubleBuffer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_zsymm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") double[] B,
                 @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_double_complex*") double[] BETA, @Cast("__LAPACK_double_complex*") double[] C, @Cast("const __LAPACK_int") long LDC);

// MARK: SYRK
public static native void cblas_ssyrk(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                 float ALPHA, @Const FloatPointer A, @Cast("const __LAPACK_int") long LDA,
                 float BETA, FloatPointer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_ssyrk(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                 float ALPHA, @Const FloatBuffer A, @Cast("const __LAPACK_int") long LDA,
                 float BETA, FloatBuffer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_ssyrk(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                 float ALPHA, @Const float[] A, @Cast("const __LAPACK_int") long LDA,
                 float BETA, float[] C, @Cast("const __LAPACK_int") long LDC);

public static native void cblas_dsyrk(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                 double ALPHA, @Const DoublePointer A, @Cast("const __LAPACK_int") long LDA,
                 double BETA, DoublePointer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_dsyrk(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                 double ALPHA, @Const DoubleBuffer A, @Cast("const __LAPACK_int") long LDA,
                 double BETA, DoubleBuffer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_dsyrk(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                 double ALPHA, @Const double[] A, @Cast("const __LAPACK_int") long LDA,
                 double BETA, double[] C, @Cast("const __LAPACK_int") long LDC);

public static native void cblas_csyrk(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                 @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("const __LAPACK_float_complex*") FloatPointer BETA, @Cast("__LAPACK_float_complex*") FloatPointer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_csyrk(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                 @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("const __LAPACK_float_complex*") FloatBuffer BETA, @Cast("__LAPACK_float_complex*") FloatBuffer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_csyrk(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                 @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("const __LAPACK_float_complex*") float[] BETA, @Cast("__LAPACK_float_complex*") float[] C, @Cast("const __LAPACK_int") long LDC);

public static native void cblas_zsyrk(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                 @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("const __LAPACK_double_complex*") DoublePointer BETA, @Cast("__LAPACK_double_complex*") DoublePointer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_zsyrk(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                 @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("const __LAPACK_double_complex*") DoubleBuffer BETA, @Cast("__LAPACK_double_complex*") DoubleBuffer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_zsyrk(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                 @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                 @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA,
                 @Cast("const __LAPACK_double_complex*") double[] BETA, @Cast("__LAPACK_double_complex*") double[] C, @Cast("const __LAPACK_int") long LDC);

// MARK: SYR2K
public static native void cblas_ssyr2k(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                  @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                  float ALPHA, @Const FloatPointer A, @Cast("const __LAPACK_int") long LDA,
                  @Const FloatPointer B, @Cast("const __LAPACK_int") long LDB, float BETA, FloatPointer C,
                  @Cast("const __LAPACK_int") long LDC);
public static native void cblas_ssyr2k(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                  @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                  float ALPHA, @Const FloatBuffer A, @Cast("const __LAPACK_int") long LDA,
                  @Const FloatBuffer B, @Cast("const __LAPACK_int") long LDB, float BETA, FloatBuffer C,
                  @Cast("const __LAPACK_int") long LDC);
public static native void cblas_ssyr2k(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                  @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                  float ALPHA, @Const float[] A, @Cast("const __LAPACK_int") long LDA,
                  @Const float[] B, @Cast("const __LAPACK_int") long LDB, float BETA, float[] C,
                  @Cast("const __LAPACK_int") long LDC);

public static native void cblas_dsyr2k(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                  @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                  double ALPHA, @Const DoublePointer A, @Cast("const __LAPACK_int") long LDA,
                  @Const DoublePointer B, @Cast("const __LAPACK_int") long LDB, double BETA, DoublePointer C,
                  @Cast("const __LAPACK_int") long LDC);
public static native void cblas_dsyr2k(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                  @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                  double ALPHA, @Const DoubleBuffer A, @Cast("const __LAPACK_int") long LDA,
                  @Const DoubleBuffer B, @Cast("const __LAPACK_int") long LDB, double BETA, DoubleBuffer C,
                  @Cast("const __LAPACK_int") long LDC);
public static native void cblas_dsyr2k(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                  @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                  double ALPHA, @Const double[] A, @Cast("const __LAPACK_int") long LDA,
                  @Const double[] B, @Cast("const __LAPACK_int") long LDB, double BETA, double[] C,
                  @Cast("const __LAPACK_int") long LDC);

public static native void cblas_csyr2k(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                  @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                  @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") FloatPointer B,
                  @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_float_complex*") FloatPointer BETA, @Cast("__LAPACK_float_complex*") FloatPointer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_csyr2k(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                  @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                  @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") FloatBuffer B,
                  @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_float_complex*") FloatBuffer BETA, @Cast("__LAPACK_float_complex*") FloatBuffer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_csyr2k(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                  @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                  @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_float_complex*") float[] B,
                  @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_float_complex*") float[] BETA, @Cast("__LAPACK_float_complex*") float[] C, @Cast("const __LAPACK_int") long LDC);

public static native void cblas_zsyr2k(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                  @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                  @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") DoublePointer B,
                  @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_double_complex*") DoublePointer BETA, @Cast("__LAPACK_double_complex*") DoublePointer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_zsyr2k(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                  @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                  @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") DoubleBuffer B,
                  @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_double_complex*") DoubleBuffer BETA, @Cast("__LAPACK_double_complex*") DoubleBuffer C, @Cast("const __LAPACK_int") long LDC);
public static native void cblas_zsyr2k(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_UPLO") int UPLO,
                  @Cast("const CBLAS_TRANSPOSE") int TRANS, @Cast("const __LAPACK_int") long N, @Cast("const __LAPACK_int") long K,
                  @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA, @Cast("const __LAPACK_double_complex*") double[] B,
                  @Cast("const __LAPACK_int") long LDB, @Cast("const __LAPACK_double_complex*") double[] BETA, @Cast("__LAPACK_double_complex*") double[] C, @Cast("const __LAPACK_int") long LDC);

// MARK: TRMM
public static native void cblas_strmm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 float ALPHA, @Const FloatPointer A, @Cast("const __LAPACK_int") long LDA, FloatPointer B,
                 @Cast("const __LAPACK_int") long LDB);
public static native void cblas_strmm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 float ALPHA, @Const FloatBuffer A, @Cast("const __LAPACK_int") long LDA, FloatBuffer B,
                 @Cast("const __LAPACK_int") long LDB);
public static native void cblas_strmm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 float ALPHA, @Const float[] A, @Cast("const __LAPACK_int") long LDA, float[] B,
                 @Cast("const __LAPACK_int") long LDB);

public static native void cblas_dtrmm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 double ALPHA, @Const DoublePointer A, @Cast("const __LAPACK_int") long LDA, DoublePointer B,
                 @Cast("const __LAPACK_int") long LDB);
public static native void cblas_dtrmm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 double ALPHA, @Const DoubleBuffer A, @Cast("const __LAPACK_int") long LDA, DoubleBuffer B,
                 @Cast("const __LAPACK_int") long LDB);
public static native void cblas_dtrmm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 double ALPHA, @Const double[] A, @Cast("const __LAPACK_int") long LDA, double[] B,
                 @Cast("const __LAPACK_int") long LDB);

public static native void cblas_ctrmm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_float_complex*") FloatPointer B,
                 @Cast("const __LAPACK_int") long LDB);
public static native void cblas_ctrmm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_float_complex*") FloatBuffer B,
                 @Cast("const __LAPACK_int") long LDB);
public static native void cblas_ctrmm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_float_complex*") float[] B,
                 @Cast("const __LAPACK_int") long LDB);

public static native void cblas_ztrmm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_double_complex*") DoublePointer B,
                 @Cast("const __LAPACK_int") long LDB);
public static native void cblas_ztrmm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_double_complex*") DoubleBuffer B,
                 @Cast("const __LAPACK_int") long LDB);
public static native void cblas_ztrmm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_double_complex*") double[] B,
                 @Cast("const __LAPACK_int") long LDB);

// MARK: TRSM
public static native void cblas_strsm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 float ALPHA, @Const FloatPointer A, @Cast("const __LAPACK_int") long LDA, FloatPointer B,
                 @Cast("const __LAPACK_int") long LDB);
public static native void cblas_strsm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 float ALPHA, @Const FloatBuffer A, @Cast("const __LAPACK_int") long LDA, FloatBuffer B,
                 @Cast("const __LAPACK_int") long LDB);
public static native void cblas_strsm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 float ALPHA, @Const float[] A, @Cast("const __LAPACK_int") long LDA, float[] B,
                 @Cast("const __LAPACK_int") long LDB);

public static native void cblas_dtrsm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 double ALPHA, @Const DoublePointer A, @Cast("const __LAPACK_int") long LDA, DoublePointer B,
                 @Cast("const __LAPACK_int") long LDB);
public static native void cblas_dtrsm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 double ALPHA, @Const DoubleBuffer A, @Cast("const __LAPACK_int") long LDA, DoubleBuffer B,
                 @Cast("const __LAPACK_int") long LDB);
public static native void cblas_dtrsm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 double ALPHA, @Const double[] A, @Cast("const __LAPACK_int") long LDA, double[] B,
                 @Cast("const __LAPACK_int") long LDB);

public static native void cblas_ctrsm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") FloatPointer ALPHA, @Cast("const __LAPACK_float_complex*") FloatPointer A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_float_complex*") FloatPointer B,
                 @Cast("const __LAPACK_int") long LDB);
public static native void cblas_ctrsm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") FloatBuffer ALPHA, @Cast("const __LAPACK_float_complex*") FloatBuffer A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_float_complex*") FloatBuffer B,
                 @Cast("const __LAPACK_int") long LDB);
public static native void cblas_ctrsm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_float_complex*") float[] ALPHA, @Cast("const __LAPACK_float_complex*") float[] A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_float_complex*") float[] B,
                 @Cast("const __LAPACK_int") long LDB);

public static native void cblas_ztrsm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") DoublePointer ALPHA, @Cast("const __LAPACK_double_complex*") DoublePointer A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_double_complex*") DoublePointer B,
                 @Cast("const __LAPACK_int") long LDB);
public static native void cblas_ztrsm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") DoubleBuffer ALPHA, @Cast("const __LAPACK_double_complex*") DoubleBuffer A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_double_complex*") DoubleBuffer B,
                 @Cast("const __LAPACK_int") long LDB);
public static native void cblas_ztrsm(@Cast("const CBLAS_ORDER") int ORDER, @Cast("const CBLAS_SIDE") int SIDE,
                 @Cast("const CBLAS_UPLO") int UPLO, @Cast("const CBLAS_TRANSPOSE") int TRANSA,
                 @Cast("const CBLAS_DIAG") int DIAG, @Cast("const __LAPACK_int") long M, @Cast("const __LAPACK_int") long N,
                 @Cast("const __LAPACK_double_complex*") double[] ALPHA, @Cast("const __LAPACK_double_complex*") double[] A, @Cast("const __LAPACK_int") long LDA, @Cast("__LAPACK_double_complex*") double[] B,
                 @Cast("const __LAPACK_int") long LDB);


// #ifdef __cplusplus
// #endif

// #endif // #if defined(ACCELERATE_NEW_LAPACK)


}
