// Targeted by JavaCPP version 1.5.12: DO NOT EDIT THIS FILE

package uncomplicate.javacpp.accelerate.global;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static uncomplicate.javacpp.accelerate.global.bnns.*;

public class bnns_graph extends uncomplicate.javacpp.accelerate.presets.bnns_graph {
    static { Loader.load(); }

// Parsed from bnns_graph.h

//
//  bnns_graph.h
//  BasicNeuralNetworkSubroutines
//
//  Copyright © 2023 Apple Inc. All rights reserved.
//

// #ifndef __BNNS_GRAPH_HEADER__
// #define __BNNS_GRAPH_HEADER__

// #if __has_include(<TargetConditionals.h>)
// # include <TargetConditionals.h>
// #endif // __has_include(<TargetConditionals.h>)

// #if __has_include( <Availability.h> )
// #include <Availability.h>
// #else
// #define __API_AVAILABLE(...)
// #define __API_DEPRECATED_WITH_REPLACEMENT(...)
// #endif

// #if __has_feature(objc_fixed_enum) || __has_extension(cxx_strong_enums)
// #  define BNNS_ENUM(_name, _type, ...)
// typedef enum : _type { __VA_ARGS__ } _name
// #else // __has_feature(objc_fixed_enum) || __has_extension(cxx_strong_enums)
// #  define BNNS_ENUM(_name, _type, ...)
// enum { __VA_ARGS__ }; typedef _type _name
// #endif// __has_feature(objc_fixed_enum) || __has_extension(cxx_strong_enums)

// #if __has_feature(assume_nonnull)
// #else
// #define _Null_unspecified
// #define _Nullable
// #define _Nonnull
// #endif

// #ifdef __cplusplus
// #endif

// #pragma mark - Data types

/** The compiled version of a graph that can be executed by BNNS.
 *  This object may be written to a file and mmap'd into read-only memory at a future time for execution through a call to
 *  {@code BNNSGraphExecute()} or {@code BNNSGraphContextExecute()}.
 *  \seealso {@code BNNSGraphCompileFromFile} */

public static class bnns_graph_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public bnns_graph_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public bnns_graph_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public bnns_graph_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public bnns_graph_t position(long position) {
        return (bnns_graph_t)super.position(position);
    }
    @Override public bnns_graph_t getPointer(long i) {
        return new bnns_graph_t((Pointer)this).offsetAddress(i);
    }

  /** Pointer to opaque object */
  public native Pointer data(); public native bnns_graph_t data(Pointer setter);
  /** size in bytes of object pointed to by data */
  public native @Cast("size_t") long size(); public native bnns_graph_t size(long setter);
}


/** Wrapper around a {@code bnns_graph_t} object that adds mutable data storage.
 *  Mutable data is required to support dynamic shapes and certain other execution options.
 *  The underlying {@code graph_t} object must remain valid throughout the lifetime of this object.
 *  \seealso {@code BNNSGraphContextMake}, {@code BNNSGraphContextDestroy} */

public static class bnns_graph_context_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public bnns_graph_context_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public bnns_graph_context_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public bnns_graph_context_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public bnns_graph_context_t position(long position) {
        return (bnns_graph_context_t)super.position(position);
    }
    @Override public bnns_graph_context_t getPointer(long i) {
        return new bnns_graph_context_t((Pointer)this).offsetAddress(i);
    }

  /** Pointer to opaque object */
  public native Pointer data(); public native bnns_graph_context_t data(Pointer setter);
  /** size in bytes of object pointed to by data */
  public native @Cast("size_t") long size(); public native bnns_graph_context_t size(long setter);
}


/** Compilation options used to compile source model to a {@code bnns_graph_t} object.
 *  Create an initial object by calling {@code BNNSGraphCompileOptionsMakeDefault()} and
 *  set or query individual options by calling the {@code BNNSGraphCompileOptions*} family of functions.
 *  \seealso {@code BNNSGraphCompileOptionsMakeDefault}, {@code BNNSGraphCompileOptionsDestroy} */

public static class bnns_graph_compile_options_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public bnns_graph_compile_options_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public bnns_graph_compile_options_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public bnns_graph_compile_options_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public bnns_graph_compile_options_t position(long position) {
        return (bnns_graph_compile_options_t)super.position(position);
    }
    @Override public bnns_graph_compile_options_t getPointer(long i) {
        return new bnns_graph_compile_options_t((Pointer)this).offsetAddress(i);
    }

  /** Pointer to opaque object */
  public native Pointer data(); public native bnns_graph_compile_options_t data(Pointer setter);
  /** size in bytes of object pointed to by data */
  public native @Cast("size_t") long size(); public native bnns_graph_compile_options_t size(long setter);
}


/** Specifies the shape of an argument
 * 
 *  Members:
 *  - {@code rank}: Rank of the tensor and number of elements in array shape. A rank of 0 may be used to indicate to
 *           {@code BNNSGraphContextSetDynamicShapes()} that the constant or default shape from the
 *           source should be used.
 *  - {@code shape}: Array of length {@code rank} containing sizes of each dimension
 *            May only be NULL if {@code rank==0}.
 *            For inputs, {@code shape[d] = 0} is used to indicate that the constant or default shape from the source
 *            should be used for dimension {@code d}.
 *            For outputs, {@code shape[d] = 0} is set by {@code BNNSGraphContextSetDynamicShapes()} to indicate that
 *            the size in that dimension could not be deduced from the input shape alone, but will depend on the values
 *            of the input data. Note that in some cases the returned shape will only be an upper bound on the size in that
 *            dimension. */

public static class bnns_graph_shape_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public bnns_graph_shape_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public bnns_graph_shape_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public bnns_graph_shape_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public bnns_graph_shape_t position(long position) {
        return (bnns_graph_shape_t)super.position(position);
    }
    @Override public bnns_graph_shape_t getPointer(long i) {
        return new bnns_graph_shape_t((Pointer)this).offsetAddress(i);
    }

  public native @Cast("size_t") long rank(); public native bnns_graph_shape_t rank(long setter);
  public native @Cast("uint64_t*") LongPointer shape(); public native bnns_graph_shape_t shape(LongPointer setter);
}


/** Type for user-provided memory allocation function
 * 
 *  The function may be called for either an initial allocation, or to resize an existing allocation.
 *  Typically on the first execution of a graph all calls will be for allocation, and on subsequent executions with the same context it will
 *  be for reallocation. An optimized implementation will normally track sizes and avoid reallocating if size is the same or smaller.
 * 
 *  Arguments:
 *  {@code user_memory_context}: pointer that stores allocator mechanism state, passed unaltered from the function that specifies an argument of this type
 *  {@code user_memory_context_size}: size in bytes of {@code user_memory_context}.
 *  {@code memptr}: pointer to be allocated or reallocated. If {@code *memptr} is NULL, data item is being allocated for the first time, if it is not NULL, the item is being reallocated
 *  {@code alignment}: Minimum required alignment for the object, in bytes.
 *  {@code size}: Minimum size of object to be returned in {@code memptr}, in bytes.
 * 
 *  Returns:
 *  0 on success, non-zero on failure
 * 
 *  \seealso {@code BNNSGraphContextSetWorkspaceAllocationCallback}, {@code BNNSGraphContextSetOutputAllocationCallback} */

///
///
public static class bnns_graph_realloc_fn_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    bnns_graph_realloc_fn_t(Pointer p) { super(p); }
    protected bnns_graph_realloc_fn_t() { allocate(); }
    private native void allocate();
    public native int call(Pointer user_memory_context,
                                       @Cast("size_t") long user_memory_context_size,
                                       @Cast("void**") PointerPointer memptr,
                                       @Cast("size_t") long alignment,
                                       @Cast("size_t") long size);
}

/** Type for user-provided memory free function
 * 
 *  This is called upon destruction of a context to free *all* memory associated to the {@code user_memory_context}.
 *  If user has supplied both workspace and output memory management functions and the {@code user_memory_context} pointers are equal,
 *  BNNS will only call this function once during {@code BNNSGraphContextDestroy}.
 * 
 *  \seealso {@code BNNSGraphContextSetWorkspaceAllocationCallback}, {@code BNNSGraphContextSetOutputAllocationCallback} */

///
public static class bnns_graph_free_all_fn_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    bnns_graph_free_all_fn_t(Pointer p) { super(p); }
    protected bnns_graph_free_all_fn_t() { allocate(); }
    private native void allocate();
    public native void call(Pointer user_memory_context, @Cast("size_t") long user_memory_context_size);
}

/** Message Level Enum
 * 
 *  Indicates the logging type for a specified message for message-logging callbacks to
 *  surface messages taking into account the message type */
/** enum BNNSGraphMessageLevel */
public static final int
   BNNSGraphMessageLevelInfo
 = 1,
  BNNSGraphMessageLevelUnsupported
 = 2,
  BNNSGraphMessageLevelWarning
 = 4,
  BNNSGraphMessageLevelError
 = 8;

/** Additional user-defined logging argument for user to pass into the message logging callbacks */

public static class bnns_user_message_data_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public bnns_user_message_data_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public bnns_user_message_data_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public bnns_user_message_data_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public bnns_user_message_data_t position(long position) {
        return (bnns_user_message_data_t)super.position(position);
    }
    @Override public bnns_user_message_data_t getPointer(long i) {
        return new bnns_user_message_data_t((Pointer)this).offsetAddress(i);
    }


  /** size of the additional logging data */
  public native @Cast("size_t") long size(); public native bnns_user_message_data_t size(long setter);

  /** pointer to the additional logging data */
  public native Pointer data(); public native bnns_user_message_data_t data(Pointer setter);

}


/** Graph execute message callback function
 * 
 *  Surfaces messages (i.e. warnings, errors, logs) according to the {@code BNNSGraphMessageLevel} message level specifier
 *  User may specify customized actionables and logging styles. Default definition of this callback reports messages onto {@code os_log} */

///
public static class bnns_graph_execute_message_fn_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    bnns_graph_execute_message_fn_t(Pointer p) { super(p); }
    protected bnns_graph_execute_message_fn_t() { allocate(); }
    private native void allocate();
    public native void call(@Cast("BNNSGraphMessageLevel") int msg_level,
                                                @Cast("const char*") BytePointer error_msg,
                                                @Cast("const char*") BytePointer op_info,
                                                bnns_user_message_data_t additional_logging_arguments);
}

/** Graph compile message callback function
 * 
 *  Surfaces messages (i.e. warnings, errors, logs) according to the {@code BNNSGraphMessageLevel} message level specifier
 *  User may specify customized actionables and logging styles. Default definition of this callback reports messages onto {@code os_log} */
public static class bnns_graph_compile_message_fn_t extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    bnns_graph_compile_message_fn_t(Pointer p) { super(p); }
    protected bnns_graph_compile_message_fn_t() { allocate(); }
    private native void allocate();
    public native void call(@Cast("BNNSGraphMessageLevel") int msg_level,
                                                @Cast("const char*") BytePointer error_msg,
                                                @Cast("const char*") BytePointer source_location,
                                                bnns_user_message_data_t additional_logging_arguments);
}


// #pragma mark - Compile options

/** Allocates and returns a new {@code bnns_graph_compile_options_t} object initialized to default values.
 *  The user is responsible for calling {@code BNNSGraphCompileOptionsDestroy} on this object once it is no longer required. */
public static native @ByVal bnns_graph_compile_options_t BNNSGraphCompileOptionsMakeDefault();

/** Destroys the given options object */
public static native void BNNSGraphCompileOptionsDestroy(@ByVal bnns_graph_compile_options_t options);

/** Sets option for compiled graph to execute on only one thread.
 *  Default behavior is to execute on multiple threads. */
public static native void BNNSGraphCompileOptionsSetTargetSingleThread(@ByVal bnns_graph_compile_options_t options, 
                                                  @Cast("bool") boolean value);

/** Returns true if execution is set to use a single thread, false otherwise. */
public static native @Cast("bool") boolean BNNSGraphCompileOptionsGetTargetSingleThread(@Const @ByVal bnns_graph_compile_options_t options);

/** Sets whether the generated {@code bnns_graph_t} object includes debug info.
 *  Default behavior is *not* to include debug info. */
public static native void BNNSGraphCompileOptionsSetGenerateDebugInfo(@ByVal bnns_graph_compile_options_t options, 
                                                 @Cast("bool") boolean value);

/** Returns true if the generated {@code bnns_graph_t} will contain the debug info, false otherwise. */
public static native @Cast("bool") boolean BNNSGraphCompileOptionsGetGenerateDebugInfo(@Const @ByVal bnns_graph_compile_options_t options);

/** BNNS Graph Compilation Optimization Preferences
 *  - {@code BNNSGraphOptimizationPreferencePerformance}: Optimize for best execute performance
 *    In this mode additional work may be moved to the compile phase, even if it increases the footprint of the IR.
 *  - {@code BNNSGraphOptimizationPreferenceIRSize}: Optimize for smallest size of IR on disk
 *    In this mode, data will be left in smallest possible form, but may decrease execute performance due
 *    to cost of performing transformations */
/** enum BNNSGraphOptimizationPreference */
public static final int
   BNNSGraphOptimizationPreferencePerformance = 0,
  BNNSGraphOptimizationPreferenceIRSize      = 1;

/** Specifies the optimization preference to compile with
 *  Default is {@code BNNSGraphOptimizationPreferencePerformance}. */
public static native void BNNSGraphCompileOptionsSetOptimizationPreference(@ByVal bnns_graph_compile_options_t options,
                                                      @Cast("BNNSGraphOptimizationPreference") int preference);

/** Returns the current optimization preference. */

///
///
public static native @Cast("BNNSGraphOptimizationPreference") int BNNSGraphCompileOptionsGetOptimizationPreference(@ByVal bnns_graph_compile_options_t options);

/** Graph Compile-time Message Callback Setter
 * 
 *  Specifies customized callback function for compile time message reporting.
 *  When unspecified, default callback functions log messages onto {@code os_log}.
 * 
 *  - {@code options}: graph compile options
 *  - {@code log_callback}: routine that customizes the graph compile time message logging callback of type
 *                                        {@code bnns_graph_compile_message_fn_t}
 *  - {@code additional_logging_arguments}: additional user-set data for the message logging functions to pass onto the callback functions unaltered */

///
public static native void BNNSGraphCompileOptionsSetMessageLogCallback(@ByVal bnns_graph_compile_options_t options,
                                                  bnns_graph_compile_message_fn_t log_callback,
                                                  bnns_user_message_data_t additional_logging_arguments);

/** Sets mask for log messages that are logged (either via {@code os_log} or the user specified callback)
 * 
 *  - {@code options}: graph compile options
 *  - {@code log_level_mask}: bitmask of levels to log for
 *                     (Default is BNNSGraphMessageLevelUnsupported | BNNSGraphMessageLevelWarning | BNNSGraphMessageLevelError) */
public static native void BNNSGraphCompileOptionsSetMessageLogMask(@ByVal bnns_graph_compile_options_t options,
                                              @Cast("uint32_t") int log_level_mask);

// #if !0
/** Specifies that the {@code bnns_graph_t} object should be generated directly to the given file
 *  This is intended to reduce memory required for compilation, as the full set of graph weights need not be memory resident all at once
 *  This option will be ignored if a file descriptor is supplied by calling {@code BNNSGraphCompileOptionsSetOutputFD}.
 *  If this option is used, the {@code bnns_graph_t} returned BNNSCompileFromFile() will be a read-only mmap'd version of the result.
 *  Passing NULL will reset to the default behavior of generating strictly in memory.
 *  The file will be created with 0600 permissions (read/write by user only).
 *  \seealso BNNSGraphCompileOptionsSetOutputFD */
public static native void BNNSGraphCompileOptionsSetOutputPath(@ByVal bnns_graph_compile_options_t options, @Cast("const char*") BytePointer path);
public static native void BNNSGraphCompileOptionsSetOutputPath(@ByVal bnns_graph_compile_options_t options, String path);

/** Returns the path used if the {@code bnns_graph_t} object is generated directly to a file, or NULL if this option is not enabled */
public static native @Cast("const char*") BytePointer BNNSGraphCompileOptionsGetOutputPath(@ByVal bnns_graph_compile_options_t options);

/** Specifies that the {@code bnns_graph_t} object should be generated directly to the given file descriptor
 *  This is intended to reduce memory required for compilation, as the full set of graph weights need not be memory resident all at once
 *  This option will override any previously set output path option.
 *  The file indicated by the desriptor must be open for writing, and will be truncated and completely overwritten.
 *  If this option is used, the {@code bnns_graph_t} returned BNNSCompileFromFile() will be a read-only mmap'd version of the result.
 *  Passing -1 will reset to the default behavior of generating strictly in memory (or the file specified via
 *  {@code BNNSGraphCompileOptionsSetOutputPath}). */
public static native void BNNSGraphCompileOptionsSetOutputFD(@ByVal bnns_graph_compile_options_t options, int fd);

// Return the file descriptor to be used for output, or -1 it none has been set.
public static native int BNNSGraphCompileOptionsGetOutputFD(@ByVal bnns_graph_compile_options_t options);
// #endif 

// #pragma mark - Compilation

// #if !0

/** Compiles the given mlmodelc to a {@code bnns_graph_t} object.
 *  The resulting object may be written to disk and then mmap'd in and executed in a new process at a later time or consumed
 *  immediately.
 * 
 *  The user is responsible for calling {@code free} (by default) or {@code munmap} (if a file was specified via one of the
 *  {@code BNNSGraphCompileOptionsSetOutputPath*} calls) once they are ready to release the object.
 * 
 *  Arguments:
 *  - {@code filename}: specifies the path to the mlmodelc.
 *  - {@code function}: specifies the name of a specific function to be compiled. If all functions in the source file are to be compiled,
 *    {@code NULL} or the empty string may be passed.
 *  - {@code options}: specifies compilation options. If the user passes {@code NULL}, options are the default set of options.
 * 
 *  Returns:
 *  - Compiled graph on success, or {@code (bnns_graph_t) { .data = NULL, .size = 0 }} on failure. */
public static native @ByVal bnns_graph_t BNNSGraphCompileFromFile(@Cast("const char*") BytePointer filename,
                                      @Cast("const char*") BytePointer function,
                                      @ByVal bnns_graph_compile_options_t options);
public static native @ByVal bnns_graph_t BNNSGraphCompileFromFile(String filename,
                                      String function,
                                      @ByVal bnns_graph_compile_options_t options);

// #endif 


///
///
// #pragma mark - Graph query


/** Returns number of input arguments from a graph function.
 * 
 *  Arguments:
 *  - {@code graph}: object to query.
 *  - {@code function}: function to query. It may be {@code NULL} if there is only one function.
 * 
 *  Returns:
 *  The number of input arguments on success, or {@code SIZE_T_MAX} on failure. */

///
///
public static native @Cast("size_t") long BNNSGraphGetInputCount(@ByVal bnns_graph_t graph,
                              @Cast("const char*") BytePointer function);
public static native @Cast("size_t") long BNNSGraphGetInputCount(@ByVal bnns_graph_t graph,
                              String function);

/** Returns number of output arguments from a graph function.
 * 
 *  Arguments:
 *  - {@code graph}: object to query.
 *  - {@code function}: function to query. It may be {@code NULL} if there is only one function.
 * 
 *  Returns:
 *  The number of output arguments on success, or {@code SIZE_T_MAX} on failure. */

///
///
///
public static native @Cast("size_t") long BNNSGraphGetOutputCount(@ByVal bnns_graph_t graph,
                               @Cast("const char*") BytePointer function);
public static native @Cast("size_t") long BNNSGraphGetOutputCount(@ByVal bnns_graph_t graph,
                               String function);

/** Returns total number of arguments for a graph function.
 * 
 *  This will be the sum of values returned by {@code BNNSGraphGetInputCount} and {@code BNNSGraphGetOutputCount}.
 * 
 *  Arguments:
 *  - {@code graph}: object to query.
 *  - {@code function}: function to query. It may be {@code NULL} if there is only one function.
 * 
 *  Returns:
 *  The number of output arguments on success, or {@code SIZE_T_MAX} on failure. */

///
///
public static native @Cast("size_t") long BNNSGraphGetArgumentCount(@ByVal bnns_graph_t graph,
                                 @Cast("const char*") BytePointer function);
public static native @Cast("size_t") long BNNSGraphGetArgumentCount(@ByVal bnns_graph_t graph,
                                 String function);

/** Returns number of callable functions in this graph.
 * 
 *  Arguments:
 *  - {@code graph}: object to query.
 * 
 *  Returns:
 *  The number of callable functions on success, or {@code SIZE_T_MAX} on failure. */

///
///
public static native @Cast("size_t") long BNNSGraphGetFunctionCount(@ByVal bnns_graph_t graph);

/** Extracts argument names of inputs to a graph function
 * 
 *  Arguments:
 *  - {@code graph}: object to query.
 *  - {@code function}: function to query. It may be {@code NULL} if there is only one function.
 *  - {@code input_names_count}: number of elements in {@code input_names}.
 *  - {@code input_names}: array of string pointers to populate.
 *    On exit {@code input_names[i]} will be set to a read-only pointer to a string containing
 *    the i-th argument name, for i in [0, min(num_inputs, input_names_count)).
 * 
 *  Returns:
 *  0 on success, nonzero on failure.
 *  Failure may be caused by either invalid values of {@code graph} or {@code function}. */

///
///
public static native int BNNSGraphGetInputNames(@ByVal bnns_graph_t graph,
                           @Cast("const char*") BytePointer function,
                           @Cast("size_t") long input_names_count,
                           @Cast("const char**") PointerPointer input_names);
public static native int BNNSGraphGetInputNames(@ByVal bnns_graph_t graph,
                           @Cast("const char*") BytePointer function,
                           @Cast("size_t") long input_names_count,
                           @Cast("const char**") @ByPtrPtr BytePointer input_names);
public static native int BNNSGraphGetInputNames(@ByVal bnns_graph_t graph,
                           String function,
                           @Cast("size_t") long input_names_count,
                           @Cast("const char**") @ByPtrPtr ByteBuffer input_names);
public static native int BNNSGraphGetInputNames(@ByVal bnns_graph_t graph,
                           @Cast("const char*") BytePointer function,
                           @Cast("size_t") long input_names_count,
                           @Cast("const char**") @ByPtrPtr byte[] input_names);
public static native int BNNSGraphGetInputNames(@ByVal bnns_graph_t graph,
                           String function,
                           @Cast("size_t") long input_names_count,
                           @Cast("const char**") @ByPtrPtr BytePointer input_names);
public static native int BNNSGraphGetInputNames(@ByVal bnns_graph_t graph,
                           @Cast("const char*") BytePointer function,
                           @Cast("size_t") long input_names_count,
                           @Cast("const char**") @ByPtrPtr ByteBuffer input_names);
public static native int BNNSGraphGetInputNames(@ByVal bnns_graph_t graph,
                           String function,
                           @Cast("size_t") long input_names_count,
                           @Cast("const char**") @ByPtrPtr byte[] input_names);

/** Extracts argument names of outputs to a graph function
 * 
 *  Arguments:
 *  - {@code graph}: object to query.
 *  - {@code function}: function to query. It may be {@code NULL} if there is only one function.
 *  - {@code output_names_count}: number of elements in {@code output_names}.
 *  - {@code output_names}: array of string pointers to populate.
 *    On exit {@code output_names[i]} will be set to a read-only pointer to a string containing
 *    the i-th argument name, for i in [0, min(num_outputs, output_names_count)).
 * 
 *  Returns:
 *  0 on success, nonzero on failure.
 *  Failure may be caused by either invalid values of {@code graph} or {@code function}. */

///
///
///
public static native int BNNSGraphGetOutputNames(@ByVal bnns_graph_t graph,
                            @Cast("const char*") BytePointer function,
                            @Cast("size_t") long output_names_count,
                            @Cast("const char**") PointerPointer output_names);
public static native int BNNSGraphGetOutputNames(@ByVal bnns_graph_t graph,
                            @Cast("const char*") BytePointer function,
                            @Cast("size_t") long output_names_count,
                            @Cast("const char**") @ByPtrPtr BytePointer output_names);
public static native int BNNSGraphGetOutputNames(@ByVal bnns_graph_t graph,
                            String function,
                            @Cast("size_t") long output_names_count,
                            @Cast("const char**") @ByPtrPtr ByteBuffer output_names);
public static native int BNNSGraphGetOutputNames(@ByVal bnns_graph_t graph,
                            @Cast("const char*") BytePointer function,
                            @Cast("size_t") long output_names_count,
                            @Cast("const char**") @ByPtrPtr byte[] output_names);
public static native int BNNSGraphGetOutputNames(@ByVal bnns_graph_t graph,
                            String function,
                            @Cast("size_t") long output_names_count,
                            @Cast("const char**") @ByPtrPtr BytePointer output_names);
public static native int BNNSGraphGetOutputNames(@ByVal bnns_graph_t graph,
                            @Cast("const char*") BytePointer function,
                            @Cast("size_t") long output_names_count,
                            @Cast("const char**") @ByPtrPtr ByteBuffer output_names);
public static native int BNNSGraphGetOutputNames(@ByVal bnns_graph_t graph,
                            String function,
                            @Cast("size_t") long output_names_count,
                            @Cast("const char**") @ByPtrPtr byte[] output_names);

/** Extracts names of argument to a graph function
 * 
 *  This will be the concatenation of the results from {@code BNNSGraphGetOutputNames} and {@code BNNSGraphGetInputNames}
 * 
 *  Arguments:
 *  - {@code graph}: object to query.
 *  - {@code function}: function to query. It may be {@code NULL} if there is only one function.
 *  - {@code argument_names_count}: number of elements in {@code argument_names}.
 *  - {@code argument_names}: array of string pointers to populate.
 *    On exit {@code argument_names[i]} will be set to a read-only pointer to a string containing
 *    the i-th argument name, for i in [0, min(num_argument, argument_names_count)).
 * 
 *  Returns:
 *  0 on success, nonzero on failure.
 *  Failure may be caused by either invalid values of {@code graph} or {@code function}. */

///
///
public static native int BNNSGraphGetArgumentNames(@ByVal bnns_graph_t graph,
                              @Cast("const char*") BytePointer function,
                              @Cast("size_t") long argument_names_count,
                              @Cast("const char**") PointerPointer argument_names);
public static native int BNNSGraphGetArgumentNames(@ByVal bnns_graph_t graph,
                              @Cast("const char*") BytePointer function,
                              @Cast("size_t") long argument_names_count,
                              @Cast("const char**") @ByPtrPtr BytePointer argument_names);
public static native int BNNSGraphGetArgumentNames(@ByVal bnns_graph_t graph,
                              String function,
                              @Cast("size_t") long argument_names_count,
                              @Cast("const char**") @ByPtrPtr ByteBuffer argument_names);
public static native int BNNSGraphGetArgumentNames(@ByVal bnns_graph_t graph,
                              @Cast("const char*") BytePointer function,
                              @Cast("size_t") long argument_names_count,
                              @Cast("const char**") @ByPtrPtr byte[] argument_names);
public static native int BNNSGraphGetArgumentNames(@ByVal bnns_graph_t graph,
                              String function,
                              @Cast("size_t") long argument_names_count,
                              @Cast("const char**") @ByPtrPtr BytePointer argument_names);
public static native int BNNSGraphGetArgumentNames(@ByVal bnns_graph_t graph,
                              @Cast("const char*") BytePointer function,
                              @Cast("size_t") long argument_names_count,
                              @Cast("const char**") @ByPtrPtr ByteBuffer argument_names);
public static native int BNNSGraphGetArgumentNames(@ByVal bnns_graph_t graph,
                              String function,
                              @Cast("size_t") long argument_names_count,
                              @Cast("const char**") @ByPtrPtr byte[] argument_names);

/** Extracts names of callable functions in the graph
 * 
 *  Arguments:
 *  - {@code graph}: object to query.
 *  - {@code function_name_count}: number of elements in {@code function_names}
 *  - {@code function_names}: array of string pointers to populate.
 *    On exit {@code function_names[i]} will be set to a read-only pointer to a string containing
 *    the i-th function name, for i in [0, min(num_functions, function_name_length)).
 * 
 *  Returns:
 *  0 on success, nonzero on failure.
 *  Failure may be caused by either invalid values of {@code graph}. */

///
public static native int BNNSGraphGetFunctionNames(@ByVal bnns_graph_t graph,
                              @Cast("size_t") long function_name_count,
                              @Cast("const char**") PointerPointer function_names);
public static native int BNNSGraphGetFunctionNames(@ByVal bnns_graph_t graph,
                              @Cast("size_t") long function_name_count,
                              @Cast("const char**") @ByPtrPtr BytePointer function_names);
public static native int BNNSGraphGetFunctionNames(@ByVal bnns_graph_t graph,
                              @Cast("size_t") long function_name_count,
                              @Cast("const char**") @ByPtrPtr ByteBuffer function_names);
public static native int BNNSGraphGetFunctionNames(@ByVal bnns_graph_t graph,
                              @Cast("size_t") long function_name_count,
                              @Cast("const char**") @ByPtrPtr byte[] function_names);

/** Describes the intent of an argument
 * 
 *  - {@code BNNSGraphArgumentIntentIn} - argument provides an input tensor
 *  - {@code BNNSGraphArgumentIntentOut} - argument provide an output tensor
 *  - {@code BNNSGraphArgumentIntentInOut} - argument is an input and then updated in-place to provide an output as well */
/** enum BNNSGraphArgumentIntent */
public static final int
   BNNSGraphArgumentIntentIn     = 1,
  BNNSGraphArgumentIntentOut    = 2,
  BNNSGraphArgumentIntentInOut  = BNNSGraphArgumentIntentIn | BNNSGraphArgumentIntentOut;

/** Returns intents of arguments
 * 
 *  Arguments:
 *  - {@code graph}: object to query.
 *  - {@code function}: function to query. It may be {@code NULL} if there is only one function.
 *  - {@code argument_intents_count}: number of elements in {@code argument_intents}.
 *  - {@code argument_intents}: array of intents to populate.
 *    On exit {@code argument_intents[i]} will be set to a value indicating the intent of
 *    the i-th argument name, for i in [0, min(num_argument, argument_intents_count)).
 * 
 *  Returns:
 *  0 on success, nonzero on failure.
 *  Failure may be caused by either invalid values of {@code graph} or {@code function}. */

///
///
///
public static native int BNNSGraphGetArgumentIntents(@ByVal bnns_graph_t graph,
                                @Cast("const char*") BytePointer function,
                                @Cast("size_t") long argument_intents_count,
                                @Cast("BNNSGraphArgumentIntent*") IntPointer argument_intents);
public static native int BNNSGraphGetArgumentIntents(@ByVal bnns_graph_t graph,
                                String function,
                                @Cast("size_t") long argument_intents_count,
                                @Cast("BNNSGraphArgumentIntent*") IntBuffer argument_intents);
public static native int BNNSGraphGetArgumentIntents(@ByVal bnns_graph_t graph,
                                @Cast("const char*") BytePointer function,
                                @Cast("size_t") long argument_intents_count,
                                @Cast("BNNSGraphArgumentIntent*") int[] argument_intents);
public static native int BNNSGraphGetArgumentIntents(@ByVal bnns_graph_t graph,
                                String function,
                                @Cast("size_t") long argument_intents_count,
                                @Cast("BNNSGraphArgumentIntent*") IntPointer argument_intents);
public static native int BNNSGraphGetArgumentIntents(@ByVal bnns_graph_t graph,
                                @Cast("const char*") BytePointer function,
                                @Cast("size_t") long argument_intents_count,
                                @Cast("BNNSGraphArgumentIntent*") IntBuffer argument_intents);
public static native int BNNSGraphGetArgumentIntents(@ByVal bnns_graph_t graph,
                                String function,
                                @Cast("size_t") long argument_intents_count,
                                @Cast("BNNSGraphArgumentIntent*") int[] argument_intents);

/** Returns index into arguments[] array for given function argument.
 * 
 *  Returns the position in the arguments[] array for a call to {@code BNNSGraphExecute} or {@code BNNSGraphContextExecute} for the given argument.
 * 
 *  Arguments:
 *  - {@code graph}: object to query.
 *  - {@code function}: function to query. It may be {@code NULL} if there is only one function.
 *  - {@code argument}: name of input/output argument to query
 * 
 *  Returns:
 *  Index of argument on success, or {@code SIZE_T_MAX} on failure. */

///
///
///
public static native @Cast("size_t") long BNNSGraphGetArgumentPosition(@Const @ByVal bnns_graph_t graph,
                                    @Cast("const char*") BytePointer function,
                                    @Cast("const char*") BytePointer argument);
public static native @Cast("size_t") long BNNSGraphGetArgumentPosition(@Const @ByVal bnns_graph_t graph,
                                    String function,
                                    String argument);

/** Returns the interleave factors for arguments, if present
 * 
 *  If any arguments to the function are specified with an interleave factor (e.g. using
 *  the {@code interleave} option to {@code tensor_buffer} in MIL), this function can be
 *  used to retrieve the interleave factor array.
 * 
 *  Arguments:
 *  - {@code graph}: object to query.
 *  - {@code function}: function to query. It may be {@code NULL} if there is only one function.
 *  - {@code argument_count}: number of elements in {@code argument_interleave} and in {@code argument_interleave_counts}.
 *  - {@code argument_interleave}: array of pointers to interleave factors to populate.
 *    On exit {@code argument_interleave[i]} will be set to either:
 *    - {@code NULL} if argument {@code i} has no interleave factor; or
 *    - a pointer into the graph object containing the interleave factors that contains {@code argument_interleave_counts[i]} elements.
 *    Only the first [0, min(argument_count, argument_interleave)) entries are set.
 *  - {@code argument_interleave_counts}: gives the size of the array pointed to by {@code argument_interleave[i]}, or is set to 0
 *    if {@code argument_interleave[i]} is set to {@code NULL}.
 * 
 *  Returns:
 *  0 on success, nonzero on failure.
 *  Failure may be caused by either invalid values of {@code graph} or {@code function}. */
public static native int BNNSGraphGetArgumentInterleaveFactors(@ByVal bnns_graph_t graph,
                                          @Cast("const char*") BytePointer function,
                                          @Cast("size_t") long argument_count,
                                          @Cast("const uint16_t**") PointerPointer argument_interleave,
                                          @Cast("size_t*") SizeTPointer argument_interleave_counts);
public static native int BNNSGraphGetArgumentInterleaveFactors(@ByVal bnns_graph_t graph,
                                          @Cast("const char*") BytePointer function,
                                          @Cast("size_t") long argument_count,
                                          @Cast("const uint16_t**") @ByPtrPtr ShortPointer argument_interleave,
                                          @Cast("size_t*") SizeTPointer argument_interleave_counts);
public static native int BNNSGraphGetArgumentInterleaveFactors(@ByVal bnns_graph_t graph,
                                          String function,
                                          @Cast("size_t") long argument_count,
                                          @Cast("const uint16_t**") @ByPtrPtr ShortBuffer argument_interleave,
                                          @Cast("size_t*") SizeTPointer argument_interleave_counts);
public static native int BNNSGraphGetArgumentInterleaveFactors(@ByVal bnns_graph_t graph,
                                          @Cast("const char*") BytePointer function,
                                          @Cast("size_t") long argument_count,
                                          @Cast("const uint16_t**") @ByPtrPtr short[] argument_interleave,
                                          @Cast("size_t*") SizeTPointer argument_interleave_counts);
public static native int BNNSGraphGetArgumentInterleaveFactors(@ByVal bnns_graph_t graph,
                                          String function,
                                          @Cast("size_t") long argument_count,
                                          @Cast("const uint16_t**") @ByPtrPtr ShortPointer argument_interleave,
                                          @Cast("size_t*") SizeTPointer argument_interleave_counts);
public static native int BNNSGraphGetArgumentInterleaveFactors(@ByVal bnns_graph_t graph,
                                          @Cast("const char*") BytePointer function,
                                          @Cast("size_t") long argument_count,
                                          @Cast("const uint16_t**") @ByPtrPtr ShortBuffer argument_interleave,
                                          @Cast("size_t*") SizeTPointer argument_interleave_counts);
public static native int BNNSGraphGetArgumentInterleaveFactors(@ByVal bnns_graph_t graph,
                                          String function,
                                          @Cast("size_t") long argument_count,
                                          @Cast("const uint16_t**") @ByPtrPtr short[] argument_interleave,
                                          @Cast("size_t*") SizeTPointer argument_interleave_counts);

// #pragma mark - Execution - without context

/** Used to specify the interpretation of the {@code arguments} argument to {@code BNNSGraphContextExecute()}.
 *  {@code BNNSGraphArgumentTypePointer}: arguments[i] is a pointer to the raw data for the tensor
 *  {@code BNNSGraphArgumentTypeTensor}: arguments[i] is a pointer to a BNNSTensor
 *                                The layout and sizes of inputs must either be zero, or must match the source model.
 *                                The layout and sizes of the output will be set by {@code BNNSGraphContextExecute()}. */
/** enum BNNSGraphArgumentType */
public static final int
   BNNSGraphArgumentTypePointer = 0,
  BNNSGraphArgumentTypeTensor  = 2;

/** Describes data associated with an input or output argument
 * 
 *  Exactly one of descriptor or data_ptr should be set based on the configuration specified with {@code BNNSGraphContextSetArgumentType()} */
public static class bnns_graph_argument_t extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public bnns_graph_argument_t() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public bnns_graph_argument_t(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public bnns_graph_argument_t(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public bnns_graph_argument_t position(long position) {
        return (bnns_graph_argument_t)super.position(position);
    }
    @Override public bnns_graph_argument_t getPointer(long i) {
        return new bnns_graph_argument_t((Pointer)this).offsetAddress(i);
    }

    /** Pointer to BNNSTensor */
    public native BNNSTensor tensor(); public native bnns_graph_argument_t tensor(BNNSTensor setter);
    /** Pointer to BNNSNDArrayDescriptor (deprecated, use BNNSTensor instead) */
    public native BNNSNDArrayDescriptor descriptor(); public native bnns_graph_argument_t descriptor(BNNSNDArrayDescriptor setter);
    /** Direct pointer to numerical data */
    public native Pointer data_ptr(); public native bnns_graph_argument_t data_ptr(Pointer setter);
  /** size in bytes of {@code data_ptr}, if set */
  public native @Cast("size_t") long data_ptr_size(); public native bnns_graph_argument_t data_ptr_size(long setter);
}


///
///
///
// #pragma mark - Graph Context

/** Allocates and initializes a {@code bnns_graph_context_t}
 * 
 *  Arguments:
 *  - {@code graph}: object to be wrapped into the context. Must remain valid for the lifetime of returned context.
 * 
 *  Returns:
 *  - New context on success, or {@code (bnns_graph_context_t) { .data = NULL, .size = 0 }} on failure.
 *    The object must be destroyed through a call to {@code BNNSGraphContextDestroy}.
 * 
 *  \seealso {@code BNNSGraphContextDestroy} */

///
///
///
///
///
public static native @ByVal bnns_graph_context_t BNNSGraphContextMake(@Const @ByVal bnns_graph_t graph);

/** Make a new graph context with streaming support for the given function
 * 
 *  Use this function in place of {@code BNNSGraphContextMake} to create a context for use with a model
 *  compiled with the {@code BNNSOption} attribute {@code StateMode=Streaming} enabled. In addition to the
 *  regular work performed by {@code BNNSGraphContextMake}, this call will also allocate ring-buffer
 *  backed memory for all inout (i.e. CoreML {@code state}) arguments of the given function. Calls to
 *  {@code BNNSGraphContextExecute()} with this function will ignore any user-provided pointers for
 *  inout arguments and will use the internal ring-buffer instead. Upon return from the call, any
 *  user-provided {@code bnns_argument_t} will be set to point to the ring-buffer memory.
 *  The internal ring buffer will then be advanced by the distance determined by analysis of the compiled
 *  program ready for use in the next frame.
 * 
 *  If the function was not compiled with the BNNSOption parameter StateMode=Streaming, this call will fail.
 * 
 *  If a state does not appear in the {@code initial_states} list, it will be initialized to all zeros.
 * 
 *  Arguments:
 *  - {@code graph}: object to be wrapped into the context. Must remain valid for the lifetime of returned context.
 *  - {@code function}: function to initialize state for. It may be {@code NULL} if there is only one function.
 *  - {@code initial_states_count}: Number of initial states contained in the array {@code inital_states}. May be 0.
 *  - {@code initial_states}: Array of BNNSTensors describing data to be used to initialize each state.
 *                     {@code initial_state[i]} is used to intialize the state with name
 *                     {@code initial_state[i]->name}.
 * 
 *  Returns:
 *  - New context on success, or {@code (bnns_graph_context_t) { .data = NULL, .size = 0 }} on failure.
 *    The object must be destroyed through a call to {@code BNNSGraphContextDestroy}. */

///
public static native @ByVal bnns_graph_context_t BNNSGraphContextMakeStreaming(@ByVal bnns_graph_t graph,
                                                   @Cast("const char*") BytePointer function,
                                                   @Cast("size_t") long initial_states_count,
                                                   @Const BNNSTensor initial_states);
public static native @ByVal bnns_graph_context_t BNNSGraphContextMakeStreaming(@ByVal bnns_graph_t graph,
                                                   String function,
                                                   @Cast("size_t") long initial_states_count,
                                                   @Const BNNSTensor initial_states);

/** Destroys a graph context created through a call to {@code BNNSGraphContextCreate}
 * 
 *  Arguments:
 *  {@code context}: object to be destroyed */

///
///
///
public static native void BNNSGraphContextDestroy(@ByVal bnns_graph_context_t context);

/** Specifies the dynamic shapes for a graph and infers (if possible) output shapes
 * 
 *  Notes:
 *  - It is an error to call this function before all existing calls to {@code BNNSGraphContextExecute()} using the same context complete.
 *  - Required workspace size for {@code BNNSGraphContextExecute()} may change as a result of this call.
 *  - This function does not set dynamic strides as required by some arguments.
 *   Arguments with dynamic strides must be provided as {@code BNNSTensor}s.
 *   Use {@code BNNSGraphContextSetArgumentType} to set the argument type to {@code BNNSGraphArgumentTypeTensor}, and provide
 *   {@code BNNSTensor} pointers in {@code bnns_graph_argument_t}.
 * 
 *  Arguments:
 *  - {@code context}: context for which to set dynamic shapes
 *  - {@code function}: specific function to be set shapes for. It may be {@code NULL} if there is only one function.
 *  - {@code shapes_count}: number of elements in array shapes
 *  - {@code shapes}: array of shapes for outputs and inputs, in the same order as will be passed for {@code BNNSGraphContextExecute()}
 *    On entry, input shapes are read from this array, unless indicated otherwise by setting {@code shapes[idx].rank = 0}, in which
 *    case the constant or default value from the source model will be used. If a non-zero value is specified that does not match a constant
 *    size in the source model, an error is generated. Output shapes are not read.
 *    On exit, output shapes that have {@code shapes[idx].rank != 0} will be set to an upper bound on the  expected output shape.
 *    If the output shape cannot be deduced as it depends on input data values, the value of {@code shapes[idx].size[d]} will be set
 *    to zero for that dimension.
 * 
 *  Returns:
 *  - {@code 0} on success if all tensor shapes were exactly determined (workspace size is exact)
 *  - {@code 1} on success if one or more tensor shapes are merely bounds, but no tensor is unbounded (workspace size is bounded)
 *  - {@code 2} on success if one or more tensor shapes are unbounded (BNNS will need to allocate during execution)
 *  - {@code < 0} on failure. */

///
///
///
///
public static native int BNNSGraphContextSetDynamicShapes(@ByVal bnns_graph_context_t context,
                                     @Cast("const char*") BytePointer function,
                                     @Cast("size_t") long shapes_count,
                                     bnns_graph_shape_t shapes);
public static native int BNNSGraphContextSetDynamicShapes(@ByVal bnns_graph_context_t context,
                                     String function,
                                     @Cast("size_t") long shapes_count,
                                     bnns_graph_shape_t shapes);

/** Sets the batch size for a graph
 * 
 *  This is a special case of {@code BNNSGraphContextSetDynamicShapes()} where the only dynamic sizes that occur are the first index
 *  of their tensor (i.e. the batch dimension) and are all equal. This allows just passing a single {@code batch_size} constant.
 * 
 *  Notes:
 *  - It is an error to call this function before all existing calls to {@code BNNSGraphContextExecute()} complete.
 *  - Required workspace size for {@code BNNSGraphContextExecute()} may change as a result of this call.
 *  - If the graph has dynamic sizes other than batch size, then {@code BNNSGraphContextSetDynamicShapes()} must be used instead
 *  - This function does not set dynamic strides as required by some arguments.
 *   Arguments with dynamic strides must be provided as {@code BNNSTensor}s.
 *   Use {@code BNNSGraphContextSetArgumentType} to set the argument type to {@code BNNSGraphArgumentTypeTensor}, and provide
 *   {@code BNNSTensor} pointers in {@code bnns_graph_argument_t}.
 * 
 *  Arguments:
 *  - {@code context}: context for which to set dynamic shapes
 *  - {@code function}: specific function to be set shapes for. It may be {@code NULL} if there is only one function.
 *  - {@code batch_size}: the batch size to set
 * 
 *  Returns:
 *  - 0 on success, non-zero on failure */

///
///
///
public static native int BNNSGraphContextSetBatchSize(@ByVal bnns_graph_context_t context,
                                 @Cast("const char*") BytePointer function,
                                 @Cast("uint64_t") long batch_size);
public static native int BNNSGraphContextSetBatchSize(@ByVal bnns_graph_context_t context,
                                 String function,
                                 @Cast("uint64_t") long batch_size);

/** Sets the type used to interpret the {@code arguments} argument to {@code BNNSGraphContextExecute()}.
 * 
 *  Notes:
 *  - Some arguments require dynamic strides. These must be provided as {@code BNNSTensor}s.
 *   Use {@code BNNSGraphContextSetArgumentType} to set the argument type to {@code BNNSGraphArgumentTypeTensor}, and provide
 *   {@code BNNSTensor} pointers in {@code bnns_graph_argument_t}.
 * 
 *  Arguments:
 *  - {@code context}: for which to enable signposts
 *  - {@code argument_type}: argument type to set, default is {@code BNNSGraphArgumentTypePointer}
 * 
 *  Returns:
 *  - 0 on success, non-zero on failure */
public static native int BNNSGraphContextSetArgumentType(@ByVal bnns_graph_context_t context, 
                                    @Cast("BNNSGraphArgumentType") int argument_type);

/** Enables debug mode, checks intermediate tensors for nans and infs.
 *  Not for use in production code. */

///
///
public static native void BNNSGraphContextEnableNanAndInfChecks(@ByVal bnns_graph_context_t context,
                                           @Cast("bool") boolean enable_check_for_nans_inf);

/** Sets streaming advancement amount for cases with dynamically shaped inputs.
 * 
 *  For models compiled with the {@code BNNSOption} attribute {@code StateMode=Streaming} enabled, where
 *  {@code slice_update} ops use an update parameter of dynamic shape, BNNS cannot unambigiously
 *  determine the streaming advancement size. Instead the user must use this function *prior* to calling
 *  {@code BNNSGraphContextExecute()} to set the advancement size for each frame. 
 * 
 *  The internal state pointer will then be advanced by {@code advance_count} elements in the streaming
 *  dimension prior to returning from {@code BNNSGraphContextExecute()}. The BNNS streaming APIs
 *  do not support models that require different advancement amounts for different states. */
public static native int BNNSGraphContextSetStreamingAdvanceCount(@Const @ByVal bnns_graph_context_t context,
                                             @Cast("size_t") long advance_count);


///
///
///
///
///
///
///
// #pragma mark - Execution - with Graph Context

/** Executes the specified function with the provided context
 * 
 *  The same context must only be used by a single thread at a time.
 * 
 *  If the underlying model contains dynamic shaped inputs or outputs, these must be set prior to calling this routine through a call
 *  to either {@code BNNSGraphContextSetDynamicShapes} or {@code BNNSGraphContextSetBatchSize}. The shapes should not
 *  be modified again until this routine has returned.
 * 
 *  This routine performs no memory allocation if the following conditions are met:
 *  - workspace is not {@code NULL}.
 *  - the graph does not contain tensors whose shape BNNS could not bound prior to this call.
 *  - no new shape information is supplied via {@code arguments}.
 *  - all output storage is provided explicitly by the user.
 *  If any of these points is not the case, the user may control allocation by registering suitable callbacks via the functions
 *  {@code BNNSGraphContextSetWorkspaceAllocationCallback} and {@code BNNSGraphContextSetOutputAllocationCallback}.
 * 
 *  If the output allocation policy has been set to {@code bnns_managed=true}, the context must not be used in another call to
 *  {@code BNNSGraphContextExecute} until the outputs are no longer needed (as they may be reused or deallocated).
 * 
 *  Arguments:
 *  - {@code context}: is the context to be executed.
 *  - {@code function}: specific function to be executed. It may be {@code NULL} if there is only one function.
 *  - {@code argument_count}: number of elements in {@code arguments}.
 *  - {@code arguments}: array of {@code bnns_graph_argument_t} objects supply input data and memory allocated to hold the output.
 *     Arguments are ordered such that outputs precede inputs, in the same order as they appear the source function's output and input
 *     blocks. The position of an argument can be looked up by its source name using the BNNSGraphGetArgumentPosition() function.
 *     If {@code .data_ptr=NULL} or {@code .tensor.data=NULL} for an output, one will be allocated for the user.
 *  - {@code workspace_size}: size in bytes of {@code workspace}, or zero if {@code workspace==NULL}.
 *  - {@code workspace}: scratch memory to be used during execution. MUST be page-aligned.
 *                May be freed or reused by the user upon return.
 *                If {@code NULL} is passed, the routine will allocate its own workspace.
 * 
 *  Returns:
 *  - 0 on success, non-zero on failure
 * 
 *  \seealso {@code BNNSGraphContextMake}, {@code BNNSGraphContextGetWorkspaceSize},
 *           {@code BNNSGraphContextSetArgumentType}, {@code BNNSGraphContextSetDynamicShapes} */

///
///
///
public static native int BNNSGraphContextExecute(@ByVal bnns_graph_context_t context,
                            @Cast("const char*") BytePointer function,
                            @Cast("size_t") long argument_count,
                            bnns_graph_argument_t arguments,
                            @Cast("size_t") long workspace_size,
                            @Cast("char*") BytePointer workspace);
public static native int BNNSGraphContextExecute(@ByVal bnns_graph_context_t context,
                            String function,
                            @Cast("size_t") long argument_count,
                            bnns_graph_argument_t arguments,
                            @Cast("size_t") long workspace_size,
                            @Cast("char*") ByteBuffer workspace);
public static native int BNNSGraphContextExecute(@ByVal bnns_graph_context_t context,
                            @Cast("const char*") BytePointer function,
                            @Cast("size_t") long argument_count,
                            bnns_graph_argument_t arguments,
                            @Cast("size_t") long workspace_size,
                            @Cast("char*") byte[] workspace);
public static native int BNNSGraphContextExecute(@ByVal bnns_graph_context_t context,
                            String function,
                            @Cast("size_t") long argument_count,
                            bnns_graph_argument_t arguments,
                            @Cast("size_t") long workspace_size,
                            @Cast("char*") BytePointer workspace);
public static native int BNNSGraphContextExecute(@ByVal bnns_graph_context_t context,
                            @Cast("const char*") BytePointer function,
                            @Cast("size_t") long argument_count,
                            bnns_graph_argument_t arguments,
                            @Cast("size_t") long workspace_size,
                            @Cast("char*") ByteBuffer workspace);
public static native int BNNSGraphContextExecute(@ByVal bnns_graph_context_t context,
                            String function,
                            @Cast("size_t") long argument_count,
                            bnns_graph_argument_t arguments,
                            @Cast("size_t") long workspace_size,
                            @Cast("char*") byte[] workspace);

/** Returns the minimum size in bytes of the workspace argument that should be passed to {@code BNNSGraphContextExecute()}.
 * 
 *  If {@code BNNSGraphContextSetBatchSize} or {@code BNNSGraphContextSetDynamicShapes} is called, then this function
 *  should be call afterwards to obtain a new workspace size.
 *  Due to memory layout algorithms being heuristic in nature, there is no guarantee that workspace size is monotonic
 *  with any dynamic size. That is to say that the case with the maximum dynamic size may not be an upper bound on workspace
 *  required for smaller sizes.
 * 
 *  Arguments:
 *  - {@code graph}: is the graph to be executed
 *  - {@code function}: specific function to be executed. It may be {@code NULL} if there is only one function.
 * 
 *  Returns:
 *  - size in bytes of required workspace, or {@code SIZE_T_MAX} on failure (invalid graph, invalid function, or function contains dynamic shapes). */
public static native @Cast("size_t") long BNNSGraphContextGetWorkspaceSize(@ByVal bnns_graph_context_t context,
                                        @Cast("const char*") BytePointer function);
public static native @Cast("size_t") long BNNSGraphContextGetWorkspaceSize(@ByVal bnns_graph_context_t context,
                                        String function);


///
///
///
// #pragma mark - Graph Context Query

/** Fills tensor descriptor for a given function argument.
 * 
 *  If the shape has been modified for this context, such as by calling {@code BNNSGraphContextSetDynamicShapes()},
 *  then this routine will return that modified shape.
 * 
 *  Arguments:
 *  - {@code context}: object to query.
 *  - {@code function}: function to query. It may be {@code NULL} if there is only one function.
 *  - {@code argument}: name of input/output argument to query
 *  - {@code fill_known_dynamic_shapes}: if {@code true}, any dynamic shapes are replaced with shapes that will be used on next
 *     execution of {@code context}, either drawn from default shapes in the source model or supplied by a preceding call to
 *     {@code BNNSGraphContextSetDynamicShapes()} or {@code BNNSGraphContextSetBatchSize()}.
 *     Otherwise dynamically-sized dimensions are indicated by a value of -1 in shape/stride as appropriate.
 *  - {@code tensor}: pointer to {@code BNNSTensor} to be filled by this routine.
 *    On return all fields except {@code .data} and {@code .data_size_in_bytes} will have been populated.
 * 
 *  Returns:
 *  0 on success and a non-zero on failure. */

///
///
///
public static native int BNNSGraphContextGetTensor(@ByVal bnns_graph_context_t context,
                              @Cast("const char*") BytePointer function,
                              @Cast("const char*") BytePointer argument,
                              @Cast("bool") boolean fill_known_dynamic_shapes,
                              BNNSTensor tensor);
public static native int BNNSGraphContextGetTensor(@ByVal bnns_graph_context_t context,
                              String function,
                              String argument,
                              @Cast("bool") boolean fill_known_dynamic_shapes,
                              BNNSTensor tensor);

/** Fills the strides member of a BNNSTensor for compatibility with a given model input or output based on its current shape
 * 
 *  All sizes must be fully specified (i.e. not {@code < 0}). If the input or output is a tensor, contiguous strides will be filled in.
 *  If the input or output is a tensor buffer, the strides will be filled in according to the specification in the model that was
 *  compiled to the given graph.
 * 
 *  Arguments:
 *  - {@code graph}: ir to query.
 *  - {@code function}: function to query. It may be {@code NULL} if there is only one function.
 *  - {@code argument}: name of input/output argument to query
 *  - {@code tensor}: pointer to {@code BNNSTensor} to be filled by this routine.
 *    On return the first {@code tensor.rank} elements will have been overwritten with the strides BNNS expects.
 * 
 *  Returns:
 *  0 on success and a non-zero on failure. */
public static native int BNNSGraphTensorFillStrides(@ByVal bnns_graph_t graph,
                               @Cast("const char*") BytePointer function,
                               @Cast("const char*") BytePointer argument,
                               BNNSTensor tensor);
public static native int BNNSGraphTensorFillStrides(@ByVal bnns_graph_t graph,
                               String function,
                               String argument,
                               BNNSTensor tensor);


///
///
///
///
///
// #pragma mark - Graph Context Memory Management

/** Sets allocation/free callbacks for internal workspace
 * 
 *  In the case that the required workspace cannot be bounded prior to execution (for example if tensor sizes depend on the
 *  input data), BNNS will need to allocate workspace during execution. If the user wishes to override BNNS's default memory
 *  allocation mechanism, they may provide allocation and free routines here.
 * 
 *  Note that the {@code free} function will typically only be called when the context is destroyed, however workspace is only
 *  required during the actual execution. As such users may wish to make memory in this allocation purgable or free it
 *  between calls to {@code BNNSGraphContextExecute()}.
 * 
 *  If the same value of {@code user_memory_context} is supplied to both {@code BNNSGraphContextSetWorkspaceAllocationCallback}
 *  and to {@code BNNSGraphContextSetOutputAllocationCallback}, the {@code free} function will only be called once rather than twice.
 * 
 *  Arguments:
 *  - {@code context}: context to set callbacks for
 *  - {@code realloc}: routine for (re)allocation of workspace. If {@code NULL} is passed then {@code free} must also be {@code NULL}, and routine will
 *              reset context to the default BNNS allocation mechanism.
 *  - {@code free}: routine to free all previous allocated data. Must match nullity of {@code realloc}. If {@code NULL} is passed then {@code realloc}
 *           must also be {@code NULL}, and routine will reset context to the default BNNS allocation mechanism.
 *  - {@code user_memory_context_size}: size in bytes of {@code user_memory_context}
 *  - {@code user_memory_context}: pointer that will be passed unmodified by BNNS in all calls to {@code realloc} and {@code free}
 * 
 *  Returns:
 *  - 0 on success, non-zero on failure */

///
///
///
///
public static native int BNNSGraphContextSetWorkspaceAllocationCallback(@ByVal bnns_graph_context_t context,
                                                   bnns_graph_realloc_fn_t realloc,
                                                   bnns_graph_free_all_fn_t _free,
                                                   @Cast("size_t") long user_memory_context_size,
                                                   Pointer user_memory_context);

/** Sets allocation/free callbacks for function outputs
 * 
 *  In the case that the output shape cannot be bounded prior to execution, the user may pass a NULL data pointer, and BNNS
 *  will allocation the memory within the given context. If the user wishes to override BNNS's default memory
 *  allocation mechanism for outputs, they may provide allocation and free routines here.
 * 
 *  If the same value of {@code user_memory_context} is supplied to both {@code BNNSGraphContextSetWorkspaceAllocationCallback}
 *  and to {@code BNNSGraphContextSetOutputAllocationCallback}, the {@code free} function will only be called once rather than twice.
 * 
 *  Arguments:
 *  - {@code context}: context to set callbacks for
 *  - {@code realloc}: routine for (re)allocation of outputs. If {@code NULL} is passed then {@code free} must also be {@code NULL}, and routine will
 *              reset context to the default BNNS allocation mechanism.
 *  - {@code free}: routine to free all previous allocated data. Must match nullity of {@code realloc}. If {@code NULL} is passed then {@code realloc}
 *           must also be {@code NULL}, and routine will reset context to the default BNNS allocation mechanism.
 *  - {@code user_memory_context_size}: size in bytes of {@code user_memory_context}
 *  - {@code user_memory_context}: pointer that will be passed unmodified by BNNS in all calls to {@code realloc} and {@code free}
 * 
 *  Returns:
 *  - 0 on success, non-zero on failure */

///
///
public static native int BNNSGraphContextSetOutputAllocationCallback(@ByVal bnns_graph_context_t context,
                                                bnns_graph_realloc_fn_t realloc,
                                                bnns_graph_free_all_fn_t _free,
                                                @Cast("size_t") long user_memory_context_size,
                                                Pointer user_memory_context);

/** Execution time message logging callback setter
 * 
 *  Specifies customized callback function for execution-time message reporting.
 *  When unspecified, default callback functions log messages onto {@code os_log}.
 * 
 *  - {@code context}: context to set callbacks for
 *  - {@code log_callback_fn}:  routine that customizes the message reporting for all execution-time routines
 *  - {@code additional_logging_arguments}: additional user-set data for the message logging functions to pass onto the callback functions unaltered */

///
public static native int BNNSGraphContextSetMessageLogCallback(@ByVal bnns_graph_context_t context,
                                          bnns_graph_execute_message_fn_t log_callback_fn,
                                          bnns_user_message_data_t additional_logging_arguments);

/** Sets mask for log messages that are logged (either via {@code os_log} or the user specified callback)
 * 
 *  - {@code context}: context to set callbacks for
 *  - {@code log_level_mask}: bitmask of levels to log for
 *                     (Default is BNNSGraphMessageLevelUnsupported | BNNSGraphMessageLevelWarning | BNNSGraphMessageLevelError) */
public static native int BNNSGraphContextSetMessageLogMask(@ByVal bnns_graph_context_t context, 
                                      @Cast("uint32_t") int log_level_mask);

// #ifdef __cplusplus // extern "C"
// #endif

// #if __has_feature(assume_nonnull)
// #else
// #undef _Nullable
// #undef _Null_unspecified
// #undef _Nonnull
// #endif

// #undef BNNS_ENUM

// #if !__has_include( <Availability.h> )
// #undef __API_AVAILABLE
// #undef __API_DEPRECATED_WITH_REPLACEMENT
// #endif

// #endif /* __BNNS_GRAPH_HEADER__ */


}
