(ns org.usfinformatics.clinicaltrialgov.Main
  (:require [clinicaltrials-gov.core :as c]
            [clinicaltrials-gov.data :as d])
  (:import [org.usfinformatics.clinicaltrialgov Record]
           [java.util List]
           )
  (:gen-class
    :prefix "-"
    :methods [^:static [searchOpenTrials [String] java.util.List]]
    ))

(defn ^:private ->Record
  [{:keys [xml zipper]}]
  (reify Record
    (getNCTID [this] (d/nct-id zipper))
    (getOrgStudyID [this] (d/org-study-id zipper))
    (getBriefTitle [this] (d/brief-title zipper))
    (getOfficialTitle [this] (d/official-title zipper))
    (getLeadSponsor [this] (d/lead-sponsor zipper))
    (getBriefSummary [this] (d/brief-summary zipper))
    (getOverallStatus [this] (d/overall-status zipper))
    (getPhase [this] (d/phase zipper))
    (getStudyType [this] (d/study-type zipper))
    (getStudyDesign [this] (d/study-design zipper))
    (getCondition [this] (d/condition zipper))
    (getEligibilityText [this] (d/eligibility-text zipper))
    (getEligibilityGender [this] (d/eligibility-gender zipper))
    (getEligibilityMinAge [this] (d/eligibility-min-age zipper))
    (getEligibilityMaxAge [this] (d/eligibility-max-age zipper))
    (getEligibilityHealthyVolunteers [this] (d/eligibility-healthy-volunteers? zipper))
    (getRawXML [this] xml)
    ))

(defn ^List -searchOpenTrials
  [^String terms]
  (let [results (c/search terms [:open :exclude-unknown])]
    (mapv ->Record results)))