/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.dependencies.org.jboss.netty.bootstrap;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.webbitserver.dependencies.org.jboss.netty.bootstrap.Bootstrap;
import org.webbitserver.dependencies.org.jboss.netty.channel.Channel;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChannelException;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChannelFactory;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChannelFuture;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChannelHandler;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChannelHandlerContext;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChannelPipeline;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChannelStateEvent;
import org.webbitserver.dependencies.org.jboss.netty.channel.Channels;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChildChannelStateEvent;
import org.webbitserver.dependencies.org.jboss.netty.channel.ExceptionEvent;
import org.webbitserver.dependencies.org.jboss.netty.channel.ServerChannelFactory;
import org.webbitserver.dependencies.org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class ServerBootstrap
extends Bootstrap {
    private volatile ChannelHandler parentHandler;

    public ServerBootstrap() {
    }

    public ServerBootstrap(ChannelFactory channelFactory) {
        super(channelFactory);
    }

    public void setFactory(ChannelFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (!(factory instanceof ServerChannelFactory)) {
            throw new IllegalArgumentException("factory must be a " + ServerChannelFactory.class.getSimpleName() + ": " + factory.getClass());
        }
        super.setFactory(factory);
    }

    public ChannelHandler getParentHandler() {
        return this.parentHandler;
    }

    public void setParentHandler(ChannelHandler parentHandler) {
        this.parentHandler = parentHandler;
    }

    public Channel bind() {
        SocketAddress localAddress = (SocketAddress)this.getOption("localAddress");
        if (localAddress == null) {
            throw new IllegalStateException("localAddress option is not set.");
        }
        return this.bind(localAddress);
    }

    public Channel bind(SocketAddress localAddress) {
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        LinkedBlockingQueue<ChannelFuture> futureQueue = new LinkedBlockingQueue<ChannelFuture>();
        Binder binder = new Binder(localAddress, futureQueue);
        ChannelHandler parentHandler = this.getParentHandler();
        ChannelPipeline bossPipeline = Channels.pipeline();
        bossPipeline.addLast("binder", binder);
        if (parentHandler != null) {
            bossPipeline.addLast("userHandler", parentHandler);
        }
        Channel channel = this.getFactory().newChannel(bossPipeline);
        ChannelFuture future = null;
        boolean interrupted = false;
        do {
            try {
                future = (ChannelFuture)futureQueue.poll(Integer.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while (future == null);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        future.awaitUninterruptibly();
        if (!future.isSuccess()) {
            future.getChannel().close().awaitUninterruptibly();
            throw new ChannelException("Failed to bind to: " + localAddress, future.getCause());
        }
        return channel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Binder
    extends SimpleChannelUpstreamHandler {
        private final SocketAddress localAddress;
        private final BlockingQueue<ChannelFuture> futureQueue;
        private final Map<String, Object> childOptions = new HashMap<String, Object>();

        Binder(SocketAddress localAddress, BlockingQueue<ChannelFuture> futureQueue) {
            this.localAddress = localAddress;
            this.futureQueue = futureQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent evt) {
            try {
                evt.getChannel().getConfig().setPipelineFactory(ServerBootstrap.this.getPipelineFactory());
                Map<String, Object> allOptions = ServerBootstrap.this.getOptions();
                HashMap<String, Object> parentOptions = new HashMap<String, Object>();
                for (Map.Entry<String, Object> e : allOptions.entrySet()) {
                    if (e.getKey().startsWith("child.")) {
                        this.childOptions.put(e.getKey().substring(6), e.getValue());
                        continue;
                    }
                    if (e.getKey().equals("pipelineFactory")) continue;
                    parentOptions.put(e.getKey(), e.getValue());
                }
                evt.getChannel().getConfig().setOptions(parentOptions);
            }
            finally {
                ctx.sendUpstream(evt);
            }
            boolean finished = this.futureQueue.offer(evt.getChannel().bind(this.localAddress));
            assert (finished);
        }

        @Override
        public void childChannelOpen(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
            e.getChildChannel().getConfig().setOptions(this.childOptions);
            ctx.sendUpstream(e);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            boolean finished = this.futureQueue.offer(Channels.failedFuture(e.getChannel(), e.getCause()));
            assert (finished);
            ctx.sendUpstream(e);
        }
    }
}

