/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.Executor;
import org.webbitserver.HttpControl;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;
import org.webbitserver.handler.AbstractResourceHandler;

public class EmbeddedResourceHandler
extends AbstractResourceHandler {
    private final File root;

    public EmbeddedResourceHandler(String root, Executor ioThread) {
        super(ioThread);
        this.root = new File(root);
    }

    @Override
    protected AbstractResourceHandler.IOWorker createIOWorker(HttpRequest request, HttpResponse response, HttpControl control) {
        return new ResourceWorker(request.uri(), response, control);
    }

    protected class ResourceWorker
    extends AbstractResourceHandler.IOWorker {
        private URL resource;
        private InputStream content;
        private File file;

        protected ResourceWorker(String path, HttpResponse response, HttpControl control) {
            super(path, response, control);
        }

        @Override
        protected boolean exists() throws IOException {
            this.file = new File(EmbeddedResourceHandler.this.root, this.path);
            this.resource = this.getResource(this.file);
            return this.resource != null;
        }

        @Override
        protected byte[] fileBytes() throws IOException {
            this.content = this.resource.openStream();
            if (this.content == null || this.content instanceof ByteArrayInputStream) {
                return null;
            }
            return this.read(this.content);
        }

        @Override
        protected byte[] welcomeBytes() throws IOException {
            URL resource = this.getResource(new File(this.file, EmbeddedResourceHandler.this.welcomeFileName));
            return resource == null ? null : this.read(resource.openStream());
        }

        private byte[] read(InputStream content) throws IOException {
            try {
                return this.read(content.available(), content);
            }
            catch (NullPointerException happensWhenReadingDirectoryPAthInJar) {
                return null;
            }
        }

        private URL getResource(File file) throws IOException {
            return this.getClass().getClassLoader().getResource(file.getPath());
        }
    }
}

