/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.webbitserver.HttpControl;
import org.webbitserver.HttpHandler;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;

public class PathMatchHandler
implements HttpHandler {
    private final Pattern pattern;
    private final HttpHandler httpHandler;

    public PathMatchHandler(Pattern pattern, HttpHandler httpHandler) {
        this.pattern = pattern;
        this.httpHandler = httpHandler;
    }

    public PathMatchHandler(String path, HttpHandler httpHandler) {
        this(Pattern.compile(path), httpHandler);
    }

    @Override
    public void handleHttpRequest(HttpRequest request, HttpResponse response, HttpControl control) throws Exception {
        Matcher matcher = this.pattern.matcher(request.uri());
        if (matcher.matches()) {
            this.httpHandler.handleHttpRequest(request, response, control);
        } else {
            control.nextHandler();
        }
    }
}

