/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.webbitserver.HttpControl;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;
import org.webbitserver.handler.AbstractResourceHandler;

public class StaticFileHandler
extends AbstractResourceHandler {
    private final File dir;

    public StaticFileHandler(File dir, Executor ioThread) {
        super(ioThread);
        this.dir = dir;
    }

    public StaticFileHandler(String dir, Executor ioThread) {
        this(new File(dir), ioThread);
    }

    public StaticFileHandler(File dir) {
        this(dir, (Executor)Executors.newFixedThreadPool(4));
    }

    public StaticFileHandler(String dir) {
        this(new File(dir));
    }

    @Override
    protected AbstractResourceHandler.IOWorker createIOWorker(HttpRequest request, HttpResponse response, HttpControl control) {
        return new FileWorker(request.uri(), response, control);
    }

    protected class FileWorker
    extends AbstractResourceHandler.IOWorker {
        private File file;

        private FileWorker(String path, HttpResponse response, HttpControl control) {
            super(path, response, control);
        }

        @Override
        protected boolean exists() throws IOException {
            this.file = this.resolveFile(this.path);
            return this.file != null && this.file.exists();
        }

        @Override
        protected byte[] fileBytes() throws IOException {
            return this.file.isFile() ? this.read(this.file) : null;
        }

        @Override
        protected byte[] welcomeBytes() throws IOException {
            File welcome = new File(this.file, StaticFileHandler.this.welcomeFileName);
            return welcome.isFile() ? this.read(welcome) : null;
        }

        private byte[] read(File file) throws IOException {
            return this.read((int)file.length(), new FileInputStream(file));
        }

        private File resolveFile(String path) throws IOException {
            File result = new File(StaticFileHandler.this.dir, path).getCanonicalFile();
            String fullPath = result.getPath();
            if (!fullPath.startsWith(StaticFileHandler.this.dir.getCanonicalPath() + File.separator) && !fullPath.equals(StaticFileHandler.this.dir.getCanonicalPath())) {
                return null;
            }
            return result;
        }
    }
}

