/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler.logging;

import org.webbitserver.HttpControl;
import org.webbitserver.HttpHandler;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;
import org.webbitserver.WebSocketConnection;
import org.webbitserver.WebSocketHandler;
import org.webbitserver.handler.logging.LogSink;
import org.webbitserver.wrapper.HttpControlWrapper;
import org.webbitserver.wrapper.HttpResponseWrapper;
import org.webbitserver.wrapper.WebSocketConnectionWrapper;

public class LoggingHandler
implements HttpHandler {
    private final LogSink logSink;

    public LoggingHandler(LogSink logSink) {
        this.logSink = logSink;
    }

    public LogSink logSink() {
        return this.logSink;
    }

    @Override
    public void handleHttpRequest(final HttpRequest request, HttpResponse response, HttpControl control) throws Exception {
        this.logSink.httpStart(request);
        HttpResponseWrapper responseWrapper = new HttpResponseWrapper(response){

            @Override
            public HttpResponseWrapper end() {
                LoggingHandler.this.logSink.httpEnd(request);
                return super.end();
            }

            @Override
            public HttpResponseWrapper error(Throwable error) {
                LoggingHandler.this.logSink.httpEnd(request);
                LoggingHandler.this.logSink.error(request, error);
                return super.error(error);
            }
        };
        HttpControlWrapper controlWrapper = new HttpControlWrapper(control){
            private LoggingWebSocketConnection loggingWebSocketConnection;

            @Override
            public WebSocketConnection createWebSocketConnection() {
                return this.loggingWebSocketConnection;
            }

            @Override
            public WebSocketConnection upgradeToWebSocketConnection(WebSocketHandler handler) {
                this.loggingWebSocketConnection = new LoggingWebSocketConnection(super.createWebSocketConnection());
                return super.upgradeToWebSocketConnection(new LoggingWebSocketHandler(this.loggingWebSocketConnection, handler));
            }
        };
        control.nextHandler(request, responseWrapper, controlWrapper);
    }

    private class LoggingWebSocketHandler
    implements WebSocketHandler {
        private final WebSocketConnection loggingConnection;
        private final WebSocketHandler handler;

        LoggingWebSocketHandler(WebSocketConnection loggingConnection, WebSocketHandler handler) {
            this.loggingConnection = loggingConnection;
            this.handler = handler;
        }

        @Override
        public void onOpen(WebSocketConnection connection) throws Exception {
            LoggingHandler.this.logSink.webSocketOpen(connection);
            this.handler.onOpen(this.loggingConnection);
        }

        @Override
        public void onMessage(WebSocketConnection connection, String message) throws Exception {
            LoggingHandler.this.logSink.webSocketInboundData(connection, message);
            this.handler.onMessage(this.loggingConnection, message);
        }

        @Override
        public void onClose(WebSocketConnection connection) throws Exception {
            LoggingHandler.this.logSink.webSocketClose(connection);
            LoggingHandler.this.logSink.httpEnd(connection.httpRequest());
            this.handler.onClose(this.loggingConnection);
        }
    }

    private class LoggingWebSocketConnection
    extends WebSocketConnectionWrapper {
        LoggingWebSocketConnection(WebSocketConnection connection) {
            super(connection);
        }

        @Override
        public WebSocketConnectionWrapper send(String message) {
            LoggingHandler.this.logSink.webSocketOutboundData(this, message);
            return super.send(message);
        }
    }
}

