/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.webbitserver.HttpRequest;
import org.webbitserver.dependencies.org.jboss.netty.channel.MessageEvent;

public class NettyHttpRequest
implements HttpRequest {
    private final org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.HttpRequest httpRequest;
    private final MessageEvent messageEvent;
    private final Map<String, Object> data = new HashMap<String, Object>();
    private final Object id;
    private final long timestamp;

    public NettyHttpRequest(MessageEvent messageEvent, org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.HttpRequest httpRequest, Object id, long timestamp) {
        this.messageEvent = messageEvent;
        this.httpRequest = httpRequest;
        this.id = id;
        this.timestamp = timestamp;
    }

    @Override
    public String uri() {
        return this.httpRequest.getUri();
    }

    @Override
    public String header(String name) {
        return this.httpRequest.getHeader(name);
    }

    @Override
    public List<String> headers(String name) {
        return this.httpRequest.getHeaders(name);
    }

    @Override
    public boolean hasHeader(String name) {
        return this.httpRequest.containsHeader(name);
    }

    @Override
    public List<Map.Entry<String, String>> allHeaders() {
        return this.httpRequest.getHeaders();
    }

    @Override
    public String method() {
        return this.httpRequest.getMethod().getName();
    }

    @Override
    public Map<String, Object> data() {
        return this.data;
    }

    @Override
    public Object data(String key) {
        return this.data.get(key);
    }

    @Override
    public NettyHttpRequest data(String key, Object value) {
        this.data.put(key, value);
        return this;
    }

    @Override
    public Set<String> dataKeys() {
        return this.data.keySet();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.messageEvent.getRemoteAddress();
    }

    @Override
    public Object id() {
        return this.id;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.messageEvent.getRemoteAddress() + " " + this.httpRequest.getMethod() + " " + this.httpRequest.getUri();
    }
}

