/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import org.webbitserver.HttpResponse;
import org.webbitserver.dependencies.org.jboss.netty.buffer.ChannelBuffers;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChannelFutureListener;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChannelHandlerContext;
import org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.webbitserver.dependencies.org.jboss.netty.util.CharsetUtil;

public class NettyHttpResponse
implements HttpResponse {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final ChannelHandlerContext ctx;
    private final org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.HttpResponse response;
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private Charset charset;

    public NettyHttpResponse(ChannelHandlerContext ctx, org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.HttpResponse response, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.ctx = ctx;
        this.response = response;
        this.exceptionHandler = exceptionHandler;
        this.charset = DEFAULT_CHARSET;
    }

    @Override
    public NettyHttpResponse charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    @Override
    public NettyHttpResponse status(int status) {
        this.response.setStatus(HttpResponseStatus.valueOf(status));
        return this;
    }

    @Override
    public int status() {
        return this.response.getStatus().getCode();
    }

    @Override
    public NettyHttpResponse header(String name, String value) {
        if (value == null) {
            this.response.removeHeader(name);
        } else {
            this.response.addHeader(name, value);
        }
        return this;
    }

    @Override
    public NettyHttpResponse header(String name, long value) {
        this.response.addHeader(name, value);
        return this;
    }

    @Override
    public NettyHttpResponse content(String content) {
        this.response.setContent(ChannelBuffers.copiedBuffer((CharSequence)content, this.charset()));
        return this;
    }

    @Override
    public NettyHttpResponse content(byte[] content) {
        this.response.setContent(ChannelBuffers.copiedBuffer(content));
        return this;
    }

    @Override
    public NettyHttpResponse error(Throwable error) {
        this.response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        String message = this.getStackTrace(error);
        this.header("Content-Type", "text/plain");
        this.header("Content-Length", message.length());
        this.content(message);
        this.flushResponse();
        this.exceptionHandler.uncaughtException(Thread.currentThread(), error);
        return this;
    }

    private String getStackTrace(Throwable error) {
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        error.printStackTrace(writer);
        writer.flush();
        return buffer.toString();
    }

    @Override
    public NettyHttpResponse end() {
        if (this.response.getStatus().getCode() != 200) {
            this.response.setContent(ChannelBuffers.copiedBuffer((CharSequence)this.response.getStatus().toString(), CharsetUtil.UTF_8));
            this.header("Content-Length", this.response.getContent().readableBytes());
        }
        this.flushResponse();
        return this;
    }

    private void flushResponse() {
        this.ctx.getChannel().write(this.response).addListener(ChannelFutureListener.CLOSE);
    }
}

