/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.webbitserver.HttpHandler;
import org.webbitserver.WebServer;
import org.webbitserver.WebSocketHandler;
import org.webbitserver.dependencies.org.jboss.netty.bootstrap.ServerBootstrap;
import org.webbitserver.dependencies.org.jboss.netty.channel.Channel;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChannelPipeline;
import org.webbitserver.dependencies.org.jboss.netty.channel.ChannelPipelineFactory;
import org.webbitserver.dependencies.org.jboss.netty.channel.Channels;
import org.webbitserver.dependencies.org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.webbitserver.dependencies.org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.webbitserver.handler.HttpToWebSocketHandler;
import org.webbitserver.handler.PathMatchHandler;
import org.webbitserver.handler.exceptions.PrintStackTraceExceptionHandler;
import org.webbitserver.handler.exceptions.SilentExceptionHandler;
import org.webbitserver.netty.NettyHttpChannelHandler;

public class NettyWebServer
implements WebServer {
    private final ServerBootstrap bootstrap;
    private final SocketAddress socketAddress;
    private final URI publicUri;
    private final List<HttpHandler> handlers = new ArrayList<HttpHandler>();
    private final Executor executor;
    private Channel channel;
    protected long nextId = 1L;
    private Thread.UncaughtExceptionHandler exceptionHandler;
    private Thread.UncaughtExceptionHandler ioExceptionHandler;

    public NettyWebServer(int port) {
        this(Executors.newSingleThreadScheduledExecutor(), port);
        this.uncaughtExceptionHandler(new PrintStackTraceExceptionHandler());
        this.connectionExceptionHandler(new SilentExceptionHandler());
    }

    public NettyWebServer(Executor executor, int port) {
        this(executor, new InetSocketAddress(port), NettyWebServer.localUri(port));
    }

    public NettyWebServer(final Executor executor, SocketAddress socketAddress, URI publicUri) {
        this.executor = executor;
        this.socketAddress = socketAddress;
        this.publicUri = publicUri;
        this.bootstrap = new ServerBootstrap();
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                long timestamp = NettyWebServer.this.timestamp();
                Object id = NettyWebServer.this.nextId();
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("decoder", new HttpRequestDecoder());
                pipeline.addLast("aggregator", new HttpChunkAggregator(65536));
                pipeline.addLast("encoder", new HttpResponseEncoder());
                pipeline.addLast("handler", new NettyHttpChannelHandler(executor, NettyWebServer.this.handlers, id, timestamp, NettyWebServer.this.exceptionHandler, NettyWebServer.this.ioExceptionHandler));
                return pipeline;
            }
        });
    }

    @Override
    public URI getUri() {
        return this.publicUri;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public NettyWebServer add(HttpHandler handler) {
        this.handlers.add(handler);
        return this;
    }

    @Override
    public NettyWebServer add(String path, HttpHandler handler) {
        return this.add(new PathMatchHandler(path, handler));
    }

    @Override
    public NettyWebServer add(String path, WebSocketHandler handler) {
        return this.add(path, new HttpToWebSocketHandler(handler));
    }

    @Override
    public synchronized NettyWebServer start() {
        this.bootstrap.setFactory(new NioServerSocketChannelFactory(Executors.newSingleThreadExecutor(), Executors.newSingleThreadExecutor(), 1));
        this.channel = this.bootstrap.bind(this.socketAddress);
        return this;
    }

    @Override
    public synchronized NettyWebServer stop() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
        return this;
    }

    @Override
    public synchronized NettyWebServer join() throws InterruptedException {
        if (this.channel != null) {
            this.channel.getCloseFuture().await();
        }
        return this;
    }

    @Override
    public WebServer uncaughtExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    @Override
    public WebServer connectionExceptionHandler(Thread.UncaughtExceptionHandler ioExceptionHandler) {
        this.ioExceptionHandler = ioExceptionHandler;
        return this;
    }

    private static URI localUri(int port) {
        try {
            return URI.create("http://" + InetAddress.getLocalHost().getHostName() + (port == 80 ? "" : ":" + port) + "/");
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    protected long timestamp() {
        return System.currentTimeMillis();
    }

    protected Object nextId() {
        return this.nextId++;
    }
}

