/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.stub;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.webbitserver.HttpRequest;
import org.webbitserver.stub.StubDataHolder;

public class StubHttpRequest
extends StubDataHolder
implements HttpRequest {
    private String uri = "/";
    private String method = "GET";
    private List<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
    private SocketAddress remoteAddress = new InetSocketAddress("localhost", 0);
    private Object id = "StubID";
    private long timestamp = 0L;

    public StubHttpRequest() {
    }

    public StubHttpRequest(String uri) {
        this.uri = uri;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    public StubHttpRequest uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public String header(String name) {
        for (Map.Entry<String, String> header : this.headers) {
            if (!header.getKey().equals(name)) continue;
            return header.getValue();
        }
        return null;
    }

    @Override
    public boolean hasHeader(String name) {
        for (Map.Entry<String, String> header : this.headers) {
            if (!header.getKey().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> headers(String name) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> header : this.headers) {
            if (!header.getKey().equals(name)) continue;
            result.add(header.getValue());
        }
        return result;
    }

    @Override
    public List<Map.Entry<String, String>> allHeaders() {
        return this.headers;
    }

    @Override
    public String method() {
        return this.method;
    }

    public StubHttpRequest method(String method) {
        this.method = method;
        return this;
    }

    public StubHttpRequest header(String name, String value) {
        this.headers.add(new AbstractMap.SimpleEntry<String, String>(name, value));
        return this;
    }

    @Override
    public StubHttpRequest data(String key, Object value) {
        super.data(key, value);
        return this;
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public Object id() {
        return this.id;
    }

    public StubHttpRequest id(Object id) {
        this.id = id;
        return this;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    public StubHttpRequest timestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public StubHttpRequest remoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }
}

