/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.stub;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import org.webbitserver.HttpRequest;
import org.webbitserver.WebSocketConnection;
import org.webbitserver.stub.StubDataHolder;
import org.webbitserver.stub.StubHttpRequest;

public class StubWebSocketConnection
extends StubDataHolder
implements WebSocketConnection {
    private final List<String> sentMessages = new LinkedList<String>();
    private boolean closed = false;
    private HttpRequest httpRequest;

    public StubWebSocketConnection(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public StubWebSocketConnection() {
        this(new StubHttpRequest());
    }

    @Override
    public HttpRequest httpRequest() {
        return this.httpRequest;
    }

    public StubWebSocketConnection httpRequest(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    @Override
    public StubWebSocketConnection send(String message) {
        this.sentMessages.add(message);
        return this;
    }

    @Override
    public StubWebSocketConnection close() {
        this.closed = true;
        return this;
    }

    public boolean closed() {
        return this.closed;
    }

    @Override
    public StubWebSocketConnection data(String key, Object value) {
        super.data(key, value);
        return this;
    }

    @Override
    public Executor handlerExecutor() {
        return this;
    }

    @Override
    public void execute(Runnable command) {
        command.run();
    }
}

