/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.wrapper;

import java.nio.charset.Charset;
import org.webbitserver.HttpResponse;

public class HttpResponseWrapper
implements HttpResponse {
    private HttpResponse response;

    public HttpResponseWrapper(HttpResponse response) {
        this.response = response;
    }

    public HttpResponse underlyingResponse() {
        return this.response;
    }

    public HttpResponseWrapper underlyingResponse(HttpResponse response) {
        this.response = response;
        return this;
    }

    public HttpResponse originalResponse() {
        if (this.response instanceof HttpResponseWrapper) {
            HttpResponseWrapper wrapper = (HttpResponseWrapper)this.response;
            return wrapper.originalResponse();
        }
        return this.response;
    }

    @Override
    public HttpResponseWrapper charset(Charset charset) {
        this.response.charset(charset);
        return this;
    }

    @Override
    public Charset charset() {
        return this.response.charset();
    }

    @Override
    public HttpResponseWrapper status(int status) {
        this.response.status(status);
        return this;
    }

    @Override
    public int status() {
        return this.response.status();
    }

    @Override
    public HttpResponseWrapper header(String name, String value) {
        this.response.header(name, value);
        return this;
    }

    @Override
    public HttpResponseWrapper header(String name, long value) {
        this.response.header(name, value);
        return this;
    }

    @Override
    public HttpResponseWrapper content(String content) {
        this.response.content(content);
        return this;
    }

    @Override
    public HttpResponseWrapper content(byte[] content) {
        this.response.content(content);
        return this;
    }

    @Override
    public HttpResponseWrapper error(Throwable error) {
        this.response.error(error);
        return this;
    }

    @Override
    public HttpResponseWrapper end() {
        this.response.end();
        return this;
    }
}

