(ns wol-utils.core
  (:require [clojure.contrib.duck-streams :as ds]
            [clojure.contrib.classpath    :as cp]
            [clojure.contrib.logging      :as log])
  (:import [java.io RandomAccessFile]
           [org.apache.log4j PropertyConfigurator Logger]))

(defn get-classpath []
  (doseq [path  (cp/classpath)]
    (println path)))


(defn list-files [path]
  (loop [[path & paths] [path]
         results        []]
    (if-not path
      results
      (let [da-file (java.io.File. path)]
        (if (.isDirectory da-file)
          (recur (concat (.list da-file) paths)
                 results)
          (recur paths
                 (conj results path)))))))


(defn obtain-resource-url [a-ns resource-name]
  (-> (.getClass a-ns) (.getClassLoader) (.findResource resource-name)))

(defn load-log4j-file [file-name]
  (let [p (java.util.Properties.)
        rs   (.getResourceAsStream (.getClassLoader (class load-log4j-file )) "log4j.properties") ]
    (.load p rs)
    (org.apache.log4j.PropertyConfigurator/configure p)))


(defn wol-info [& args]
  (log/info (apply format args)))

(defn wol-warn [& args]
  (log/warn (apply format args)))

(defn capture-stack-trace [ex]
 (with-out-str
   (.printStackTrace ex (java.io.PrintWriter. *out*))))

(comment
  (with-out-str
    (class *out*))


  (defn chicken []
    (throw (RuntimeException.  "fu!!!!")))

  (try
   (chicken)
   (catch Exception ex
     (capture-stack-trace ex)))



  )
