(ns clj-opentracing.singleton-tracer
  (:require [clj-opentracing.explicit-tracer :as tracing]))


(def *tracer nil)


(defn set-tracer! [tracer]
  (alter-var-root #'*tracer (constantly tracer)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Before using any of the functions below, set your tracer: (set-tracer! tracer)


(defn set-tag! [k v]
  (tracing/set-tag! *tracer k v))


(defn set-tags! [tag-map]
  (tracing/set-tags! *tracer tag-map))


(defn log!
  ([string-or-map]
   (tracing/log! *tracer string-or-map))
  ([timestamp string-or-map]
   (tracing/log! *tracer timestamp string-or-map)))


(defmacro with-span [span-name & body]
  `(tracing/with-span *tracer ~span-name ~@body))


(defmacro with-parent-span-context [context & body]
  `(tracing/with-parent-span-context *tracer ~context ~@body))


(defn wrap-parent-span-context [handler]
  (tracing/wrap-parent-span-context handler *tracer))


(defn get-span-context-headers []
  (tracing/get-span-context-headers *tracer))
