(defproject org.zalando.automata/clj-opentracing "0.2.0"
  :description "Opentracing wrapper for Clojure"
  ;; We all know what the real internal-github.zalando.org address is ;)
  :url "https://internal-github.zalando.org/automata/clj-opentracing"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[com.lightstep.tracer/lightstep-tracer-jre "0.14.8"]]
  :plugins [[lein-cloverage "1.0.13"]
            [lein-shell "0.5.0"]
            [lein-ancient "0.6.15"]
            [lein-changelog "0.3.2"]]
  :profiles {:dev {:dependencies [[org.clojure/clojure "1.10.0"]]}}
  :deploy-repositories [["releases" :clojars] ["snapshots" :clojars]]
  :aliases {"update-readme-version" ["shell" "sed" "-i" "s/\\\\[org\\.zalando\\.automata\\\\/clj-opentracing \"[0-9.]*\"\\\\]/[org\\.zalando\\.automata\\\\/clj-opentracing \"${:version}\"]/" "README.md"]}
  :release-tasks [["shell" "git" "diff" "--exit-code"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["changelog" "release"]
                  ["update-readme-version"]
                  ["vcs" "commit"]
                  ["vcs" "tag"]
                  ["deploy"]
                  ["vcs" "push"]])
