/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.Closeable;
import java.io.IOException;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

public class ZMQQueue
implements Runnable,
Closeable {
    private final ZMQ.Poller poller;
    private final ZMQ.Socket inSocket;
    private final ZMQ.Socket outSocket;

    public ZMQQueue(ZMQ.Context context, ZMQ.Socket inSocket, ZMQ.Socket outSocket) {
        this.inSocket = inSocket;
        this.outSocket = outSocket;
        this.poller = context.poller(2);
        this.poller.register(inSocket, 1);
        this.poller.register(outSocket, 1);
    }

    @Override
    public void run() {
        byte[] msg = null;
        boolean more = true;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (this.poller.poll(-1L) < 0) break;
                if (this.poller.pollin(0)) {
                    more = true;
                    while (more) {
                        msg = this.inSocket.recv(0);
                        more = this.inSocket.hasReceiveMore();
                        if (msg == null) continue;
                        this.outSocket.send(msg, more ? 2 : 0);
                    }
                }
                if (!this.poller.pollin(1)) continue;
                more = true;
                while (more) {
                    msg = this.outSocket.recv(0);
                    more = this.outSocket.hasReceiveMore();
                    if (msg == null) continue;
                    this.inSocket.send(msg, more ? 2 : 0);
                }
            }
            catch (ZMQException e) {
                if (ZMQ.Error.ETERM.getCode() == (long)e.getErrorCode()) break;
                throw e;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.poller.unregister(this.inSocket);
        this.poller.unregister(this.outSocket);
    }
}

