/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.zeromq.ZMQ;

public class EmbeddedLibraryTools {
    public static final boolean LOADED_EMBEDDED_LIBRARY = EmbeddedLibraryTools.loadEmbeddedLibrary();

    private EmbeddedLibraryTools() {
    }

    public static String getCurrentPlatformIdentifier() {
        String osName = System.getProperty("os.name");
        osName = osName.toLowerCase().contains("windows") ? "Windows" : (osName.toLowerCase().contains("mac os x") ? "Darwin" : osName.replaceAll("\\s+", "_"));
        return System.getProperty("os.arch") + "/" + osName;
    }

    public static Collection<String> getEmbeddedLibraryList() {
        ArrayList<String> result = new ArrayList<String>();
        Collection<String> files = EmbeddedLibraryTools.catalogClasspath();
        for (String file : files) {
            if (!file.startsWith("NATIVE")) continue;
            result.add(file);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void catalogArchive(File jarfile, Collection<String> files) {
        JarFile j = null;
        try {
            j = new JarFile(jarfile);
            Enumeration<JarEntry> e = j.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (entry.isDirectory()) continue;
                files.add(entry.getName());
            }
        }
        catch (IOException x) {
            System.err.println(x.toString());
        }
        finally {
            try {
                j.close();
            }
            catch (Exception exception) {}
        }
    }

    private static Collection<String> catalogClasspath() {
        String[] classpath;
        ArrayList<String> files = new ArrayList<String>();
        for (String path : classpath = System.getProperty("java.class.path", "").split(File.pathSeparator)) {
            File tmp = new File(path);
            if (tmp.isFile() && path.toLowerCase().endsWith(".jar")) {
                EmbeddedLibraryTools.catalogArchive(tmp, files);
                continue;
            }
            if (!tmp.isDirectory()) continue;
            int len = tmp.getPath().length() + 1;
            EmbeddedLibraryTools.catalogFiles(len, tmp, files);
        }
        return files;
    }

    private static void catalogFiles(int prefixlen, File root, Collection<String> files) {
        File[] ff = root.listFiles();
        if (ff == null) {
            throw new IllegalStateException("invalid path listed: " + root);
        }
        for (File f : ff) {
            if (f.isDirectory()) {
                EmbeddedLibraryTools.catalogFiles(prefixlen, f, files);
                continue;
            }
            files.add(f.getPath().substring(prefixlen));
        }
    }

    private static boolean loadEmbeddedLibrary() {
        boolean usingEmbedded = false;
        String[] allowedExtensions = new String[]{"so", "dylib", "dll"};
        String libsFromProps = System.getProperty("jzmq.libs");
        String[] libs = libsFromProps == null ? new String[]{"libsodium", "libzmq", "libjzmq"} : libsFromProps.split(",");
        StringBuilder url = new StringBuilder();
        url.append("/NATIVE/");
        url.append(EmbeddedLibraryTools.getCurrentPlatformIdentifier()).append("/");
        for (String lib : libs) {
            URL nativeLibraryUrl = null;
            for (String ext : allowedExtensions) {
                nativeLibraryUrl = ZMQ.class.getResource(url.toString() + lib + "." + ext);
                if (nativeLibraryUrl != null) break;
            }
            if (nativeLibraryUrl == null) continue;
            try {
                File libfile = File.createTempFile(lib, ".lib");
                libfile.deleteOnExit();
                InputStream in = nativeLibraryUrl.openStream();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(libfile));
                int len = 0;
                byte[] buffer = new byte[8192];
                while ((len = in.read(buffer)) > -1) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
                System.load(libfile.getAbsolutePath());
                usingEmbedded = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return usingEmbedded;
    }
}

