/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.zeromq.EmbeddedLibraryTools;
import org.zeromq.ZMQException;

public class ZMQ {
    public static final int NOBLOCK = 1;
    public static final int DONTWAIT = 1;
    public static final int SNDMORE = 2;
    public static final int PAIR = 0;
    public static final int PUB = 1;
    public static final int SUB = 2;
    public static final int REQ = 3;
    public static final int REP = 4;
    public static final int DEALER = 5;
    public static final int XREQ = 5;
    public static final int ROUTER = 6;
    public static final int XREP = 6;
    public static final int PULL = 7;
    public static final int PUSH = 8;
    public static final int XPUB = 9;
    public static final int XSUB = 10;
    public static final int STREAMER = 1;
    public static final int FORWARDER = 2;
    public static final int QUEUE = 3;
    @Deprecated
    public static final int UPSTREAM = 7;
    @Deprecated
    public static final int DOWNSTREAM = 8;
    public static final int EVENT_CONNECTED = 1;
    public static final int EVENT_CONNECT_DELAYED = 2;
    public static final int EVENT_CONNECT_RETRIED = 4;
    public static final int EVENT_LISTENING = 8;
    public static final int EVENT_BIND_FAILED = 16;
    public static final int EVENT_ACCEPTED = 32;
    public static final int EVENT_ACCEPT_FAILED = 64;
    public static final int EVENT_CLOSED = 128;
    public static final int EVENT_CLOSE_FAILED = 256;
    public static final int EVENT_DISCONNECTED = 512;
    public static final int EVENT_MONITOR_STOPPED = 1024;
    public static final int EVENT_ALL = 2047;

    public static int getMajorVersion() {
        return ZMQ.version_major();
    }

    public static int getMinorVersion() {
        return ZMQ.version_minor();
    }

    public static int getPatchVersion() {
        return ZMQ.version_patch();
    }

    public static int getFullVersion() {
        return ZMQ.version_full();
    }

    public static int makeVersion(int major, int minor, int patch) {
        return ZMQ.make_version(major, minor, patch);
    }

    public static String getVersionString() {
        return String.format("%d.%d.%d", ZMQ.version_major(), ZMQ.version_minor(), ZMQ.version_patch());
    }

    public static void proxy(Socket frontend, Socket backend, Socket capture) {
        if (ZMQ.version_full() < ZMQ.make_version(3, 2, 2)) {
            throw new UnsupportedOperationException();
        }
        ZMQ.run_proxy(frontend, backend, capture);
    }

    public static int poll(PollItem[] items, long timeout) {
        return ZMQ.poll(items, items.length, timeout);
    }

    public static int poll(PollItem[] items, int count, long timeout) {
        return Poller.run_poll(items, count, timeout);
    }

    protected static native int version_full();

    protected static native int version_major();

    protected static native int version_minor();

    protected static native int version_patch();

    protected static native int make_version(int var0, int var1, int var2);

    protected static native long ENOTSUP();

    protected static native long EPROTONOSUPPORT();

    protected static native long ENOBUFS();

    protected static native long ENETDOWN();

    protected static native long EADDRINUSE();

    protected static native long EADDRNOTAVAIL();

    protected static native long ECONNREFUSED();

    protected static native long EINPROGRESS();

    protected static native long EHOSTUNREACH();

    protected static native long EMTHREAD();

    protected static native long EFSM();

    protected static native long ENOCOMPATPROTO();

    protected static native long ETERM();

    protected static native long ENOTSOCK();

    protected static native long EAGAIN();

    private static native void run_proxy(Socket var0, Socket var1, Socket var2);

    public static Context context(int ioThreads) {
        return new Context(ioThreads);
    }

    static {
        if (!EmbeddedLibraryTools.LOADED_EMBEDDED_LIBRARY) {
            System.loadLibrary("jzmq");
        }
    }

    public static class Curve {
        public static native KeyPair generateKeyPair();

        public static native byte[] z85Decode(String var0);

        public static native String z85Encode(byte[] var0);

        public static class KeyPair {
            public final String publicKey;
            public final String secretKey;

            public KeyPair(String publicKey, String secretKey) {
                this.publicKey = publicKey;
                this.secretKey = secretKey;
            }
        }
    }

    public static class Event {
        private final int event;
        private final Object value;
        private final String address;

        private static native void nativeInit();

        private Event(int event, int value, String address) {
            this(event, (Object)value, address != null ? address : "");
        }

        public Event(int event, Object value, String address) {
            this.event = event;
            this.value = value;
            this.address = address;
        }

        public int getEvent() {
            return this.event;
        }

        public Object getValue() {
            return this.value;
        }

        public String getAddress() {
            return this.address;
        }

        private static native Event recv(long var0, int var2) throws ZMQException;

        public static Event recv(Socket socket, int flags) throws ZMQException {
            return Event.recv(socket.socketHandle, flags);
        }

        public static Event recv(Socket socket) throws ZMQException {
            return Event.recv(socket, 0);
        }

        static {
            Event.nativeInit();
        }
    }

    public static class Poller {
        public static final int POLLIN = 1;
        public static final int POLLOUT = 2;
        public static final int POLLERR = 4;
        private Context context = null;
        private long timeout = -2L;
        private int size = 0;
        private int next = 0;
        private int used = 0;
        private PollItem[] items = null;
        private LinkedList<Integer> freeSlots = null;
        private static final int SIZE_DEFAULT = 32;
        private static final int SIZE_INCREMENT = 16;

        public int register(Socket socket) {
            return this.register(socket, 7);
        }

        public int register(SelectableChannel channel) {
            return this.register(channel, 7);
        }

        public int register(Socket socket, int events) {
            return this.registerInternal(new PollItem(socket, events));
        }

        public int register(SelectableChannel channel, int events) {
            return this.registerInternal(new PollItem(channel, events));
        }

        public int register(PollItem item) {
            return this.registerInternal(item);
        }

        private int registerInternal(PollItem item) {
            int pos = -1;
            if (!this.freeSlots.isEmpty()) {
                pos = this.freeSlots.remove();
            } else {
                if (this.next >= this.size) {
                    int nsize = this.size + 16;
                    PollItem[] ns = new PollItem[nsize];
                    short[] ne = new short[nsize];
                    short[] nr = new short[nsize];
                    for (int i = 0; i < this.next; ++i) {
                        ns[i] = this.items[i];
                    }
                    this.size = nsize;
                    this.items = ns;
                }
                pos = this.next++;
            }
            this.items[pos] = item;
            ++this.used;
            return pos;
        }

        public void unregister(Socket socket) {
            this.unregisterInternal(socket);
        }

        public void unregister(SelectableChannel channel) {
            this.unregisterInternal(channel);
        }

        private void unregisterInternal(Object socket) {
            for (int i = 0; i < this.next; ++i) {
                PollItem item = this.items[i];
                if (item == null || item.socket != socket && item.channel != socket) continue;
                this.items[i] = null;
                this.freeSlots.add(i);
                --this.used;
                break;
            }
        }

        public Socket getSocket(int index) {
            if (index < 0 || index >= this.next) {
                return null;
            }
            return this.items[index].socket;
        }

        public PollItem getItem(int index) {
            if (index < 0 || index >= this.next) {
                return null;
            }
            return this.items[index];
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long timeout) {
            if (timeout < -1L) {
                return;
            }
            this.timeout = timeout;
        }

        public int getSize() {
            return this.size;
        }

        public int getNext() {
            return this.next;
        }

        public long poll() {
            long tout = -1L;
            if (this.timeout > -1L) {
                tout = this.timeout;
            }
            return this.poll(tout);
        }

        public int poll(long tout) {
            if (tout < -1L) {
                return 0;
            }
            if (this.size <= 0 || this.next <= 0) {
                return 0;
            }
            return Poller.run_poll(this.items, this.used, tout);
        }

        public boolean pollin(int index) {
            return this.poll_mask(index, 1);
        }

        public boolean pollout(int index) {
            return this.poll_mask(index, 2);
        }

        public boolean pollerr(int index) {
            return this.poll_mask(index, 4);
        }

        public Poller(int size) {
            this(null, size);
        }

        protected Poller(Context context) {
            this(context, 32);
        }

        protected Poller(Context context, int size) {
            this.context = context;
            this.size = size;
            this.next = 0;
            this.items = new PollItem[this.size];
            this.freeSlots = new LinkedList();
        }

        protected static native int run_poll(PollItem[] var0, int var1, long var2);

        private boolean poll_mask(int index, int mask) {
            if (mask <= 0 || index < 0 || index >= this.next || this.items[index] == null) {
                return false;
            }
            return (this.items[index].revents & mask) > 0;
        }
    }

    public static class PollItem {
        private Socket socket;
        private SelectableChannel channel;
        private int events;
        private int revents;

        public PollItem(Socket socket, int events) {
            this.socket = socket;
            this.events = events;
            this.revents = 0;
        }

        public PollItem(SelectableChannel channel, int events) {
            this.channel = channel;
            this.events = events;
            this.revents = 0;
        }

        public SelectableChannel getRawSocket() {
            return this.channel;
        }

        public Socket getSocket() {
            return this.socket;
        }

        public boolean isError() {
            return (this.revents & 4) > 0;
        }

        public int readyOps() {
            return this.revents;
        }

        public boolean isReadable() {
            return (this.revents & 1) > 0;
        }

        public boolean isWritable() {
            return (this.revents & 2) > 0;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PollItem)) {
                return false;
            }
            PollItem target = (PollItem)obj;
            if (this.socket != null && this.socket == target.socket) {
                return true;
            }
            return this.channel != null && this.channel == target.channel;
        }
    }

    public static class Socket
    implements Closeable {
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private long socketHandle;
        private final Context context;
        private static final int HWM = 1;
        private static final int SWAP = 3;
        private static final int AFFINITY = 4;
        private static final int IDENTITY = 5;
        private static final int SUBSCRIBE = 6;
        private static final int UNSUBSCRIBE = 7;
        private static final int RATE = 8;
        private static final int RECOVERY_IVL = 9;
        private static final int MCAST_LOOP = 10;
        private static final int SNDBUF = 11;
        private static final int RCVBUF = 12;
        private static final int RCVMORE = 13;
        private static final int FD = 14;
        private static final int EVENTS = 15;
        private static final int TYPE = 16;
        private static final int LINGER = 17;
        private static final int RECONNECT_IVL = 18;
        private static final int BACKLOG = 19;
        private static final int RECONNECT_IVL_MAX = 21;
        private static final int MAXMSGSIZE = 22;
        private static final int SNDHWM = 23;
        private static final int RCVHWM = 24;
        private static final int MULTICAST_HOPS = 25;
        private static final int RCVTIMEO = 27;
        private static final int SNDTIMEO = 28;
        private static final int IPV4ONLY = 31;
        private static final int LAST_ENDPOINT = 32;
        private static final int ROUTER_MANDATORY = 33;
        private static final int KEEPALIVE = 34;
        private static final int KEEPALIVECNT = 35;
        private static final int KEEPALIVEIDLE = 36;
        private static final int KEEPALIVEINTVL = 37;
        private static final int IMMEDIATE = 39;
        private static final int XPUB_VERBOSE = 40;
        private static final int PLAIN_SERVER = 44;
        private static final int PLAIN_USERNAME = 45;
        private static final int PLAIN_PASSWORD = 46;
        private static final int CURVE_SERVER = 47;
        private static final int CURVE_PUBLICKEY = 48;
        private static final int CURVE_SECRETKEY = 49;
        private static final int CURVE_SERVERKEY = 50;
        private static final int PROBE_ROUTER = 51;
        private static final int REQ_CORRELATE = 52;
        private static final int REQ_RELAXED = 53;
        private static final int CONFLATE = 54;
        private static final int ZAP_DOMAIN = 55;
        private static final int GSSAPI_SERVER = 62;
        private static final int GSSAPI_PRINCIPAL = 63;
        private static final int GSSAPI_SERVICE_PRINCIPAL = 64;
        private static final int GSSAPI_PLAINTEXT = 65;

        private static native void nativeInit();

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                this.destroy();
            }
        }

        public int getType() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 0)) {
                return -1;
            }
            return (int)this.getLongSockopt(16);
        }

        public long getLinger() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 0)) {
                return -1L;
            }
            return this.getLongSockopt(17);
        }

        public long getReconnectIVL() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 10)) {
                return -1L;
            }
            return this.getLongSockopt(18);
        }

        public long getBacklog() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(19);
        }

        public long getReconnectIVLMax() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 10)) {
                return -1L;
            }
            return this.getLongSockopt(21);
        }

        public long getMaxMsgSize() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(22);
        }

        public long getSndHWM() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(23);
        }

        public long getRcvHWM() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(24);
        }

        public long getHWM() {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(1);
        }

        public long getSwap() {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(3);
        }

        public long getAffinity() {
            return this.getLongSockopt(4);
        }

        public long getTCPKeepAliveSetting() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 2, 0)) {
                return -1L;
            }
            return this.getLongSockopt(34);
        }

        public long getTCPKeepAliveIdle() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 2, 0)) {
                return -1L;
            }
            return this.getLongSockopt(36);
        }

        public long getTCPKeepAliveInterval() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 2, 0)) {
                return -1L;
            }
            return this.getLongSockopt(37);
        }

        public long getTCPKeepAliveCount() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 2, 0)) {
                return -1L;
            }
            return this.getLongSockopt(35);
        }

        public byte[] getIdentity() {
            return this.getBytesSockopt(5);
        }

        public byte[] getLastEndpoint() {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 2, 0)) {
                return this.getBytesSockopt(32);
            }
            return null;
        }

        public long getRate() {
            return this.getLongSockopt(8);
        }

        public long getRecoveryInterval() {
            return this.getLongSockopt(9);
        }

        public boolean hasMulticastLoop() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return false;
            }
            return this.getLongSockopt(10) != 0L;
        }

        public void setMulticastHops(long mcast_hops) {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(25, mcast_hops);
        }

        public long getMulticastHops() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return 1L;
            }
            return this.getLongSockopt(25);
        }

        public void setReceiveTimeOut(int timeout) {
            if (ZMQ.version_full() < ZMQ.make_version(2, 2, 0)) {
                return;
            }
            this.setLongSockopt(27, timeout);
        }

        public int getReceiveTimeOut() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 2, 0)) {
                return -1;
            }
            return (int)this.getLongSockopt(27);
        }

        public void setSendTimeOut(int timeout) {
            if (ZMQ.version_full() < ZMQ.make_version(2, 2, 0)) {
                return;
            }
            this.setLongSockopt(28, timeout);
        }

        public int getSendTimeOut() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 2, 0)) {
                return -1;
            }
            return (int)this.getLongSockopt(28);
        }

        public long getSendBufferSize() {
            return this.getLongSockopt(11);
        }

        public long getReceiveBufferSize() {
            return this.getLongSockopt(12);
        }

        public boolean getIPv4Only() {
            return this.getLongSockopt(31) == 1L;
        }

        public boolean getPlainServer() {
            if (ZMQ.version_full() >= ZMQ.make_version(4, 0, 0)) {
                return this.getLongSockopt(44) == 1L;
            }
            return false;
        }

        public byte[] getPlainUsername() {
            if (ZMQ.version_full() >= ZMQ.make_version(4, 0, 0)) {
                return this.getBytesSockopt(45);
            }
            return null;
        }

        public byte[] getPlainPassword() {
            if (ZMQ.version_full() >= ZMQ.make_version(4, 0, 0)) {
                return this.getBytesSockopt(46);
            }
            return null;
        }

        public boolean hasReceiveMore() {
            return this.getLongSockopt(13) != 0L;
        }

        public long getFD() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 0)) {
                return -1L;
            }
            return this.getLongSockopt(14);
        }

        public long getEvents() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 0)) {
                return -1L;
            }
            return this.getLongSockopt(15);
        }

        public void setLinger(long linger) {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 0)) {
                return;
            }
            this.setLongSockopt(17, linger);
        }

        public void setReconnectIVL(long reconnectIVL) {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 10)) {
                return;
            }
            this.setLongSockopt(18, reconnectIVL);
        }

        public void setBacklog(long backlog) {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(19, backlog);
        }

        public void setReconnectIVLMax(long reconnectIVLMax) {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 10)) {
                return;
            }
            this.setLongSockopt(21, reconnectIVLMax);
        }

        public void setMaxMsgSize(long maxMsgSize) {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(22, maxMsgSize);
        }

        public void setSndHWM(long sndHWM) {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(23, sndHWM);
        }

        public void setRcvHWM(long rcvHWM) {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(24, rcvHWM);
        }

        public void setHWM(long hwm) {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(1, hwm);
        }

        public void setSwap(long swap) {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(3, swap);
        }

        public void setAffinity(long affinity) {
            this.setLongSockopt(4, affinity);
        }

        public void setTCPKeepAlive(long optVal) {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 2, 0)) {
                this.setLongSockopt(34, optVal);
            }
        }

        public void setTCPKeepAliveCount(long optVal) {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 2, 0)) {
                this.setLongSockopt(35, optVal);
            }
        }

        public void setTCPKeepAliveInterval(long optVal) {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 2, 0)) {
                this.setLongSockopt(37, optVal);
            }
        }

        public void setTCPKeepAliveIdle(long optVal) {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 2, 0)) {
                this.setLongSockopt(36, optVal);
            }
        }

        public void setIdentity(byte[] identity) {
            this.setBytesSockopt(5, identity);
        }

        public void subscribe(byte[] topic) {
            this.setBytesSockopt(6, topic);
        }

        public void unsubscribe(byte[] topic) {
            this.setBytesSockopt(7, topic);
        }

        public void setRate(long rate) {
            this.setLongSockopt(8, rate);
        }

        public void setRecoveryInterval(long recovery_ivl) {
            this.setLongSockopt(9, recovery_ivl);
        }

        public void setMulticastLoop(boolean mcast_loop) {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(10, mcast_loop ? 1L : 0L);
        }

        public void setSendBufferSize(long sndbuf) {
            this.setLongSockopt(11, sndbuf);
        }

        public void setReceiveBufferSize(long rcvbuf) {
            this.setLongSockopt(12, rcvbuf);
        }

        public void setIPv4Only(boolean v4only) {
            this.setLongSockopt(31, v4only ? 1L : 0L);
        }

        public void setRouterMandatory(boolean mandatory) {
            this.setLongSockopt(33, mandatory ? 1L : 0L);
        }

        public void setXpubVerbose(boolean verbose) {
            if (ZMQ.version_full() < ZMQ.make_version(3, 2, 2)) {
                return;
            }
            this.setLongSockopt(40, verbose ? 1L : 0L);
        }

        public void setPlainServer(boolean plain) {
            if (ZMQ.version_full() >= ZMQ.make_version(4, 0, 0)) {
                this.setLongSockopt(44, plain ? 1L : 0L);
            }
        }

        public void setPlainUsername(byte[] username) {
            if (ZMQ.version_full() >= ZMQ.make_version(4, 0, 0)) {
                this.setBytesSockopt(45, username);
            }
        }

        public void setPlainPassword(byte[] password) {
            if (ZMQ.version_full() >= ZMQ.make_version(4, 0, 0)) {
                this.setBytesSockopt(46, password);
            }
        }

        public void setZAPDomain(byte[] domain) {
            if (ZMQ.version_full() >= ZMQ.make_version(4, 1, 0)) {
                this.setBytesSockopt(55, domain);
            }
        }

        public void setGSSAPIServer(boolean isServer) {
            if (ZMQ.version_full() >= ZMQ.makeVersion(4, 1, 0)) {
                this.setLongSockopt(62, isServer ? 1L : 0L);
            }
        }

        public void setGSSAPIPrincipal(byte[] principal) {
            if (ZMQ.version_full() >= ZMQ.make_version(4, 1, 0)) {
                this.setBytesSockopt(63, principal);
            }
        }

        public void setGSSAPIServicePrincipal(byte[] principal) {
            if (ZMQ.version_full() >= ZMQ.make_version(4, 1, 0)) {
                this.setBytesSockopt(64, principal);
            }
        }

        public void setGSSAPIPlainText(boolean isPlaintext) {
            if (ZMQ.version_full() >= ZMQ.makeVersion(4, 1, 0)) {
                this.setLongSockopt(65, isPlaintext ? 1L : 0L);
            }
        }

        public void setCurveServer(boolean isServer) {
            if (ZMQ.version_full() >= ZMQ.make_version(4, 0, 0)) {
                this.setLongSockopt(47, isServer ? 1L : 0L);
            }
        }

        public void setCurvePublicKey(byte[] key) {
            if (ZMQ.version_full() >= ZMQ.make_version(4, 0, 0)) {
                this.setBytesSockopt(48, key);
            }
        }

        public void setCurveSecretKey(byte[] key) {
            if (ZMQ.version_full() >= ZMQ.make_version(4, 0, 0)) {
                this.setBytesSockopt(49, key);
            }
        }

        public void setCurveServerKey(byte[] key) {
            if (ZMQ.version_full() >= ZMQ.make_version(4, 0, 0)) {
                this.setBytesSockopt(50, key);
            }
        }

        public void setConflate(boolean conflate) {
            if (ZMQ.version_full() >= ZMQ.make_version(4, 0, 0)) {
                this.setLongSockopt(54, conflate ? 1L : 0L);
            }
        }

        public boolean getConflate() {
            if (ZMQ.version_full() >= ZMQ.make_version(4, 0, 0)) {
                return this.getLongSockopt(54) != 0L;
            }
            return false;
        }

        public boolean getImmediate() {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 2, 0)) {
                return this.getLongSockopt(39) != 0L;
            }
            return false;
        }

        public void setImmediate(boolean immediate) {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 2, 0)) {
                this.setLongSockopt(39, immediate ? 1L : 0L);
            }
        }

        public void setReqRelaxed(boolean isRelaxed) {
            if (ZMQ.version_full() >= ZMQ.make_version(4, 0, 0)) {
                this.setLongSockopt(53, isRelaxed ? 1L : 0L);
            }
        }

        public void setReqCorrelate(boolean isCorrelate) {
            if (ZMQ.version_full() >= ZMQ.make_version(4, 0, 0)) {
                this.setLongSockopt(52, isCorrelate ? 1L : 0L);
            }
        }

        public void setProbeRouter(boolean isProbeRouter) {
            if (ZMQ.version_full() >= ZMQ.make_version(4, 0, 0)) {
                this.setLongSockopt(51, isProbeRouter ? 1L : 0L);
            }
        }

        public native void bind(String var1);

        public int bindToRandomPort(String addr) {
            return this.bindToRandomPort(addr, 2000, 20000, 100);
        }

        public int bindToRandomPort(String addr, int min_port) {
            return this.bindToRandomPort(addr, min_port, 20000, 100);
        }

        public int bindToRandomPort(String addr, int min_port, int max_port) {
            return this.bindToRandomPort(addr, min_port, max_port, 100);
        }

        public int bindToRandomPort(String addr, int min_port, int max_port, int max_tries) {
            Random rand = new Random();
            for (int i = 0; i < max_tries; ++i) {
                int port = rand.nextInt(max_port - min_port + 1) + min_port;
                try {
                    this.bind(String.format("%s:%s", addr, port));
                    return port;
                }
                catch (ZMQException e) {
                    if ((long)e.getErrorCode() == ZMQ.EADDRINUSE()) continue;
                    throw e;
                }
            }
            throw new ZMQException("Could not bind socket to random port.", (int)ZMQ.EADDRINUSE());
        }

        public String bindToSystemRandomPort(String addr) {
            if (ZMQ.version_full() < ZMQ.make_version(3, 2, 0)) {
                throw new UnsupportedOperationException();
            }
            this.bind(String.format("%s:*", addr));
            byte[] endpoint_bytes = this.getBytesSockopt(32);
            String endpoint_str = new String(Arrays.copyOf(endpoint_bytes, endpoint_bytes.length - 1));
            String port = endpoint_str.substring(endpoint_str.lastIndexOf(":") + 1);
            return port;
        }

        public native void unbind(String var1);

        public native void connect(String var1);

        public native void disconnect(String var1);

        public native boolean monitor(String var1, int var2) throws ZMQException;

        public boolean send(byte[] msg, int offset, int flags) {
            return this.send(msg, offset, msg.length, flags);
        }

        public native boolean send(byte[] var1, int var2, int var3, int var4);

        public native boolean sendZeroCopy(ByteBuffer var1, int var2, int var3);

        public boolean send(byte[] msg, int flags) {
            return this.send(msg, 0, msg.length, flags);
        }

        public boolean send(String msg) {
            byte[] b = msg.getBytes();
            return this.send(b, 0, b.length, 0);
        }

        public boolean sendMore(String msg) {
            byte[] b = msg.getBytes();
            return this.send(b, 0, b.length, 2);
        }

        public boolean send(String msg, int flags) {
            byte[] b = msg.getBytes();
            return this.send(b, 0, b.length, flags);
        }

        public native int sendByteBuffer(ByteBuffer var1, int var2);

        public native byte[] recv(int var1);

        public native int recv(byte[] var1, int var2, int var3, int var4);

        public native int recvZeroCopy(ByteBuffer var1, int var2, int var3);

        public byte[] recv() {
            return this.recv(0);
        }

        @Deprecated
        public String recvStr() {
            return this.recvStr(0);
        }

        public String recvStr(Charset charset) {
            return this.recvStr(0, charset);
        }

        @Deprecated
        public String recvStr(int flags) {
            return this.recvStr(flags, Charset.defaultCharset());
        }

        public String recvStr(int flags, Charset charset) {
            byte[] data = this.recv(flags);
            if (data == null) {
                return null;
            }
            return new String(data, charset);
        }

        public native int recvByteBuffer(ByteBuffer var1, int var2);

        protected Socket(Context context, int type) {
            this.context = context;
            this.construct(context, type);
        }

        protected native void construct(Context var1, int var2);

        protected native void destroy();

        public native long getLongSockopt(int var1);

        public native byte[] getBytesSockopt(int var1);

        public native void setLongSockopt(int var1, long var2);

        public native void setBytesSockopt(int var1, byte[] var2);

        private long getSocketHandle() {
            return this.socketHandle;
        }

        static {
            if (!EmbeddedLibraryTools.LOADED_EMBEDDED_LIBRARY) {
                System.loadLibrary("jzmq");
            }
            Socket.nativeInit();
        }
    }

    public static class Context
    implements Closeable {
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private long contextHandle;

        public void term() {
            if (this.closed.compareAndSet(false, true)) {
                this.destroy();
            }
        }

        public Socket socket(int type) {
            return new Socket(this, type);
        }

        public Poller poller() {
            return new Poller(this);
        }

        public Poller poller(int size) {
            return new Poller(this, size);
        }

        protected Context(int ioThreads) {
            this.construct(ioThreads);
        }

        protected native void construct(int var1);

        protected native void destroy();

        private long getContextHandle() {
            return this.contextHandle;
        }

        @Override
        public void close() {
            this.term();
        }

        public native boolean setMaxSockets(int var1);

        public native int getMaxSockets();
    }

    public static enum Error {
        ENOTSUP(ZMQ.ENOTSUP()),
        EPROTONOSUPPORT(ZMQ.EPROTONOSUPPORT()),
        ENOBUFS(ZMQ.ENOBUFS()),
        ENETDOWN(ZMQ.ENETDOWN()),
        EADDRINUSE(ZMQ.EADDRINUSE()),
        EADDRNOTAVAIL(ZMQ.EADDRNOTAVAIL()),
        ECONNREFUSED(ZMQ.ECONNREFUSED()),
        EINPROGRESS(ZMQ.EINPROGRESS()),
        EHOSTUNREACH(ZMQ.EHOSTUNREACH()),
        EMTHREAD(ZMQ.EMTHREAD()),
        EFSM(ZMQ.EFSM()),
        ENOCOMPATPROTO(ZMQ.ENOCOMPATPROTO()),
        ETERM(ZMQ.ETERM()),
        ENOTSOCK(ZMQ.ENOTSOCK()),
        EAGAIN(ZMQ.EAGAIN());

        private final long code;

        private Error(long code) {
            this.code = code;
        }

        public long getCode() {
            return this.code;
        }

        public static Error findByCode(int code) {
            for (Error e : (Error[])Error.class.getEnumConstants()) {
                if (e.getCode() != (long)code) continue;
                return e;
            }
            throw new IllegalArgumentException("Unknown " + Error.class.getName() + " enum code:" + code);
        }
    }
}

