/*
 * Decompiled with CFR 0.152.
 */
package otplike.slf4j;

import clojure.java.api.Clojure;
import clojure.lang.IFn;
import clojure.lang.Keyword;
import java.util.Collections;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public final class LoggerImpl
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 1L;
    private static final IFn is_enabled = Clojure.var((Object)"otplike.logger", (Object)"j-enabled?");
    private static final IFn log = Clojure.var((Object)"otplike.logger", (Object)"j-log");
    private static final Keyword throwable = Keyword.intern((String)"throwable");
    private static final int Emergency = 0;
    private static final int Alert = 1;
    private static final int Critical = 2;
    private static final int Error = 3;
    private static final int Warn = 4;
    private static final int Notice = 5;
    private static final int Info = 6;
    private static final int Debug = 7;
    private static final int Trace = 8;

    LoggerImpl(String name) {
        this.name = name;
    }

    public boolean isTraceEnabled() {
        return (Boolean)is_enabled.invoke((Object)this.name, (Object)8);
    }

    public void trace(String msg) {
        log.invoke((Object)this.name, (Object)8, (Object)msg, null);
    }

    public void trace(String format, Object arg) {
        log.invoke((Object)this.name, (Object)8, (Object)MessageFormatter.format((String)format, (Object)arg).getMessage(), null);
    }

    public void trace(String format, Object arg1, Object arg2) {
        log.invoke((Object)this.name, (Object)8, (Object)MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage(), null);
    }

    public void trace(String format, Object ... arguments) {
        log.invoke((Object)this.name, (Object)8, (Object)MessageFormatter.format((String)format, (Object)arguments).getMessage(), null);
    }

    public void trace(String msg, Throwable t) {
        log.invoke((Object)this.name, (Object)8, (Object)msg, Collections.singletonMap(throwable, t));
    }

    public boolean isDebugEnabled() {
        return (Boolean)is_enabled.invoke((Object)this.name, (Object)7);
    }

    public void debug(String msg) {
        log.invoke((Object)this.name, (Object)7, (Object)msg, null);
    }

    public void debug(String format, Object arg) {
        log.invoke((Object)this.name, (Object)7, (Object)MessageFormatter.format((String)format, (Object)arg).getMessage(), null);
    }

    public void debug(String format, Object arg1, Object arg2) {
        log.invoke((Object)this.name, (Object)7, (Object)MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage(), null);
    }

    public void debug(String format, Object ... arguments) {
        log.invoke((Object)this.name, (Object)7, (Object)MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage(), null);
    }

    public void debug(String msg, Throwable t) {
        log.invoke((Object)this.name, (Object)7, (Object)msg, Collections.singletonMap(throwable, t));
    }

    public boolean isInfoEnabled() {
        return (Boolean)is_enabled.invoke((Object)this.name, (Object)6);
    }

    public void info(String msg) {
        log.invoke((Object)this.name, (Object)6, (Object)msg, null);
    }

    public void info(String format, Object arg) {
        log.invoke((Object)this.name, (Object)6, (Object)MessageFormatter.format((String)format, (Object)arg).getMessage(), null);
    }

    public void info(String format, Object arg1, Object arg2) {
        log.invoke((Object)this.name, (Object)6, (Object)MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage(), null);
    }

    public void info(String format, Object ... arguments) {
        log.invoke((Object)this.name, (Object)6, (Object)MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage(), null);
    }

    public void info(String msg, Throwable t) {
        log.invoke((Object)this.name, (Object)6, (Object)msg, Collections.singletonMap(throwable, t));
    }

    public boolean isWarnEnabled() {
        return (Boolean)is_enabled.invoke((Object)this.name, (Object)4);
    }

    public void warn(String msg) {
        log.invoke((Object)this.name, (Object)4, (Object)msg, null);
    }

    public void warn(String format, Object arg) {
        log.invoke((Object)this.name, (Object)4, (Object)MessageFormatter.format((String)format, (Object)arg).getMessage(), null);
    }

    public void warn(String format, Object ... arguments) {
        log.invoke((Object)this.name, (Object)4, (Object)MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage(), null);
    }

    public void warn(String format, Object arg1, Object arg2) {
        log.invoke((Object)this.name, (Object)4, (Object)MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage(), null);
    }

    public void warn(String msg, Throwable t) {
        log.invoke((Object)this.name, (Object)4, (Object)msg, Collections.singletonMap(throwable, t));
    }

    public boolean isErrorEnabled() {
        return (Boolean)is_enabled.invoke((Object)this.name, (Object)3);
    }

    public void error(String msg) {
        log.invoke((Object)this.name, (Object)3, (Object)msg, null);
    }

    public void error(String format, Object arg) {
        log.invoke((Object)this.name, (Object)3, (Object)MessageFormatter.format((String)format, (Object)arg).getMessage(), null);
    }

    public void error(String format, Object arg1, Object arg2) {
        log.invoke((Object)this.name, (Object)3, (Object)MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage(), null);
    }

    public void error(String format, Object ... arguments) {
        log.invoke((Object)this.name, (Object)3, (Object)MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage(), null);
    }

    public void error(String msg, Throwable t) {
        log.invoke((Object)this.name, (Object)3, (Object)msg, Collections.singletonMap(throwable, t));
    }
}

