/*
 * Decompiled with CFR 0.152.
 */
package otplike.slf4j;

import clojure.java.api.Clojure;
import clojure.lang.IFn;
import clojure.lang.Keyword;
import java.util.Collections;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public final class LoggerImpl
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 1L;
    private static final IFn is_enabled = Clojure.var((Object)"otplike.logger", (Object)"j-enabled?");
    private static final IFn log = Clojure.var((Object)"otplike.logger", (Object)"j-log");
    private static final Keyword throwable = Keyword.intern((String)"throwable");
    private static final Keyword Error = Keyword.intern((String)"error");
    private static final Keyword Warn = Keyword.intern((String)"warning");
    private static final Keyword Info = Keyword.intern((String)"info");
    private static final Keyword Debug = Keyword.intern((String)"debug");
    private static final Keyword Trace = Keyword.intern((String)"trace");

    LoggerImpl(String name) {
        this.name = name;
    }

    public boolean isTraceEnabled() {
        return (Boolean)is_enabled.invoke((Object)this.name, (Object)Trace);
    }

    public void trace(String msg) {
        log.invoke((Object)this.name, (Object)Trace, (Object)msg, null);
    }

    public void trace(String format, Object arg) {
        log.invoke((Object)this.name, (Object)Trace, (Object)MessageFormatter.format((String)format, (Object)arg).getMessage(), null);
    }

    public void trace(String format, Object arg1, Object arg2) {
        log.invoke((Object)this.name, (Object)Trace, (Object)MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage(), null);
    }

    public void trace(String format, Object ... arguments) {
        log.invoke((Object)this.name, (Object)Trace, (Object)MessageFormatter.format((String)format, (Object)arguments).getMessage(), null);
    }

    public void trace(String msg, Throwable t) {
        log.invoke((Object)this.name, (Object)Trace, (Object)msg, Collections.singletonMap(throwable, t));
    }

    public boolean isDebugEnabled() {
        return (Boolean)is_enabled.invoke((Object)this.name, (Object)Debug);
    }

    public void debug(String msg) {
        log.invoke((Object)this.name, (Object)Debug, (Object)msg, null);
    }

    public void debug(String format, Object arg) {
        log.invoke((Object)this.name, (Object)Debug, (Object)MessageFormatter.format((String)format, (Object)arg).getMessage(), null);
    }

    public void debug(String format, Object arg1, Object arg2) {
        log.invoke((Object)this.name, (Object)Debug, (Object)MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage(), null);
    }

    public void debug(String format, Object ... arguments) {
        log.invoke((Object)this.name, (Object)Debug, (Object)MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage(), null);
    }

    public void debug(String msg, Throwable t) {
        log.invoke((Object)this.name, (Object)Debug, (Object)msg, Collections.singletonMap(throwable, t));
    }

    public boolean isInfoEnabled() {
        return (Boolean)is_enabled.invoke((Object)this.name, (Object)Info);
    }

    public void info(String msg) {
        log.invoke((Object)this.name, (Object)Info, (Object)msg, null);
    }

    public void info(String format, Object arg) {
        log.invoke((Object)this.name, (Object)Info, (Object)MessageFormatter.format((String)format, (Object)arg).getMessage(), null);
    }

    public void info(String format, Object arg1, Object arg2) {
        log.invoke((Object)this.name, (Object)Info, (Object)MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage(), null);
    }

    public void info(String format, Object ... arguments) {
        log.invoke((Object)this.name, (Object)Info, (Object)MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage(), null);
    }

    public void info(String msg, Throwable t) {
        log.invoke((Object)this.name, (Object)Info, (Object)msg, Collections.singletonMap(throwable, t));
    }

    public boolean isWarnEnabled() {
        return (Boolean)is_enabled.invoke((Object)this.name, (Object)Warn);
    }

    public void warn(String msg) {
        log.invoke((Object)this.name, (Object)Warn, (Object)msg, null);
    }

    public void warn(String format, Object arg) {
        log.invoke((Object)this.name, (Object)Warn, (Object)MessageFormatter.format((String)format, (Object)arg).getMessage(), null);
    }

    public void warn(String format, Object ... arguments) {
        log.invoke((Object)this.name, (Object)Warn, (Object)MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage(), null);
    }

    public void warn(String format, Object arg1, Object arg2) {
        log.invoke((Object)this.name, (Object)Warn, (Object)MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage(), null);
    }

    public void warn(String msg, Throwable t) {
        log.invoke((Object)this.name, (Object)Warn, (Object)msg, Collections.singletonMap(throwable, t));
    }

    public boolean isErrorEnabled() {
        return (Boolean)is_enabled.invoke((Object)this.name, (Object)Error);
    }

    public void error(String msg) {
        log.invoke((Object)this.name, (Object)Error, (Object)msg, null);
    }

    public void error(String format, Object arg) {
        log.invoke((Object)this.name, (Object)Error, (Object)MessageFormatter.format((String)format, (Object)arg).getMessage(), null);
    }

    public void error(String format, Object arg1, Object arg2) {
        log.invoke((Object)this.name, (Object)Error, (Object)MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage(), null);
    }

    public void error(String format, Object ... arguments) {
        log.invoke((Object)this.name, (Object)Error, (Object)MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage(), null);
    }

    public void error(String msg, Throwable t) {
        log.invoke((Object)this.name, (Object)Error, (Object)msg, Collections.singletonMap(throwable, t));
    }
}

