(defproject {{name}} "0.1.0-SNAPSHOT"
  :description "FIXME: Write a description"
  :url "http://fixme.com"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure "1.5.1"]
                 [org.clojure/core.async "0.1.267.0-0d7780-alpha"]
                 ;; ClojureScript
                 [org.clojure/clojurescript "0.0-2156"]
                 [om "0.5.0"]
                 [sablono "0.2.6"]
                 [cljs-http "0.1.8"]
                 [secretary "1.0.2"]
                 ;; Clojure/Clojurescript
                 [garden "1.1.5"]]
  :source-paths ["src/clj"]
  :plugins [[lein-cljsbuild "1.0.1"]
            [lein-garden "0.1.8"]
            [com.cemerick/clojurescript.test "0.2.2"]]
  :profiles {:dev {:plugins [[com.cemerick/austin "0.1.3"]]}}
  :aliases {"build-dev" ["do" "cljsbuild" "clean,"
                         "cljsbuild" "auto" "dev"]
            "build-prod" ["do" "cljsbuild" "clean,"
                          "cljsbuild" "auto" "prod"] 
            "build-release" ["do" "cljsbuild" "clean,"
                             "cljsbuild" "once" "prod,"
                             "garden" "once" "prod"]}
  :cljsbuild
  {:builds [{:id "dev"
             :source-paths ["src/cljs"]
             :compiler
             {:preamble ["react/react.min.js"]
              :output-to "dist/js/{{name}}.js"
              :output-dir "dist/js"
              :source-map "dist/js/{{name}}.js.map"
              :optimizations :whitespace
              :pretty-print true}}
            {:id "prod"
             :source-paths ["src/cljs"]
             :compiler
             {:preamble ["react/react.min.js"]
              :externs ["react/externs/react.js"]
              :output-to "dist/js/{{name}}.js"
              :optimizations :advanced
              :pretty-print false}}
            {:id "test"
             :source-paths ["src/cljs" "test/cljs"]
             :compiler
             {:preamble ["react/react.min.js"]
              :output-to "target/testable.js"
              :optimizations :whitespace
              :pretty-print true}}]
   :test-commands {"unit-tests" ["phantomjs" :runner
                                 "window.literal_js_was_evaluated=true"
                                 "test/extra_test_command_file.js"
                                 "target/testable.js"]}}
  :garden
  {:builds [{:id "dev"
             :stylesheet {{name}}.stylesheet/screen
             :compiler {:output-to "dist/css/screen.css"
                        :vendors [:moz :webkit]
                        :pretty-print? true}}
            {:id "prod"
             :stylesheet {{name}}.stylesheet/screen
             :compiler {:output-to "dist/css/screen.css"
                        :vendors [:moz :webkit]
                        :pretty-print? true}}]})
