(ns examples.hello
  (:use clj-scenegraph.core))

(comment

;; Swing
  
(def panel (sg-panel 640 480))
(sg-window panel)

;; Scenegraph
  

(def text (sg-text))

(doto text
  (set-text! "Hello World !")
  (set-text-antialias! :on)
  (set-font! "SansSerif" :plain 36)
  (set-fill-paint! :white)
  (set-location! 20 40)
  )

(def rect (sg-rectangle 0 0 50 50 4 4))

(doto rect
  (set-mode! :stroke-fill)
  (set-antialias! :on)
  (set-fill-paint! :black)
  (set-draw-paint! :red)
  (set-draw-stroke! 2 :butt :miter)
  (set-width! 50)
  (set-height! 120))

(def rect2 (sg-rectangle 0 0 50 50 4 4))

(def shadow3red (fx :shadow [3 (color-map :red)]))

(doto rect2
  (set-antialias! :on)
  (set-fill-paint! 0 0 255 128)
  (on-mouse-entered event node (set-fill-paint! text :red))
  (on-mouse-exited event node (set-fill-paint! text :green))
  )


;(on-mouse-entered rect event node (set-draw-paint! node :yellow))
;(on-mouse-exited rect event node (set-draw-paint! node :red))

;(on-focus-gained  rect event node (println "focus-gained"))
;(on-focus-lost  rect event node (println "focus-lost"))
;(on-key-pressed  rect event node (println "key-pressed"))
;(on-key-released  rect event node (println "key-released"))
;(on-key-typed  rect event node (println "key-typed"))
;(on-mouse-clicked  rect event node (println "mouse-clicked"))
;(on-mouse-dragged  rect event node (println "mouse-dragged"))
;(on-mouse-entered  rect event node (println "mouse-entered"))
;(on-mouse-exited  rect event node (println "mouse-exited"))
;(on-mouse-moved  rect event node (println "mouse-moved"))
;(on-mouse-pressed  rect event node (println "mouse-pressed"))
;(on-mouse-released  rect event node (println "mouse-released"))
;(on-mouse-wheel-moved  rect event node (println "wheel-moved"))
;(on-bounds-changed rect event (println "bounds-changed"))

(def group (sg-group))
(doto group
  (add! (translate 120 15 text))
  (add! (translate 40 30 (sg-effect shadow3red rect)))
  (add! (translate 40 40 (rotate 0.8 rect2)))
  )

(set-scene! panel (translate 30 30 (rotate 0.3 group)))

)
