/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.component;

import com.javadocking.component.DockHeader;
import com.javadocking.dock.LeafDock;
import com.javadocking.drag.DragListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class DefaultDockHeader
extends JPanel
implements DockHeader {
    private static final int HEADER_SIZE = 10;
    private static Color color = Color.white;
    private static Color shadow = Color.lightGray;
    private LeafDock dock;
    private DragListener dragListener;
    private int position;

    public DefaultDockHeader(LeafDock dock, int position) {
        super(new BorderLayout());
        this.setPosition(position);
        this.dock = dock;
    }

    public void setDragListener(DragListener dragListener) {
        this.dragListener = dragListener;
        this.addMouseMotionListener(dragListener);
        this.addMouseListener(dragListener);
    }

    public DragListener getDragListener() {
        return this.dragListener;
    }

    public void dispose() {
    }

    public LeafDock getDock() {
        return this.dock;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
        if (position == 3 || position == 4) {
            this.setMinimumSize(new Dimension(10, 10));
            this.setMaximumSize(new Dimension(Short.MAX_VALUE, 10));
            this.setPreferredSize(new Dimension(10, 10));
        } else {
            this.setMinimumSize(new Dimension(10, 10));
            this.setMaximumSize(new Dimension(10, Short.MAX_VALUE));
            this.setPreferredSize(new Dimension(10, 10));
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(Color.darkGray);
        int lineOffset = 5;
        int headerOffset = 3;
        if (this.position == 3 || this.position == 4) {
            int width = this.getSize().width;
            graphics.setColor(color);
            graphics.drawLine(lineOffset, headerOffset, width - lineOffset, headerOffset);
            graphics.drawLine(lineOffset, headerOffset + 1, width - lineOffset, headerOffset + 1);
            graphics.setColor(shadow);
            graphics.drawLine(width - lineOffset + 1, headerOffset, width - lineOffset + 1, headerOffset + 2);
            graphics.drawLine(lineOffset, headerOffset + 2, width - lineOffset, headerOffset + 2);
        } else {
            int height = this.getSize().height;
            graphics.setColor(color);
            graphics.drawLine(headerOffset, lineOffset, headerOffset, height - lineOffset);
            graphics.drawLine(headerOffset + 1, lineOffset, headerOffset + 1, height - lineOffset);
            graphics.setColor(shadow);
            graphics.drawLine(headerOffset, height - lineOffset + 1, headerOffset + 2, height - lineOffset + 1);
            graphics.drawLine(headerOffset + 2, lineOffset, headerOffset + 2, height - lineOffset);
        }
    }

    public static Color getShadow() {
        return shadow;
    }

    public static void setShadow(Color shadow) {
        DefaultDockHeader.shadow = shadow;
    }

    public static Color getColor() {
        return color;
    }

    public static void setColor(Color color) {
        DefaultDockHeader.color = color;
    }
}

