/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.component;

import com.javadocking.DockingManager;
import com.javadocking.component.SelectableHeader;
import com.javadocking.dockable.DefaultCompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.dockable.DraggableContent;
import com.javadocking.dockable.action.DefaultDockableStateAction;
import com.javadocking.drag.DragListener;
import com.javadocking.util.DockingUtil;
import com.javadocking.visualizer.Visualizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class ImageMinimzeHeader
extends JComponent
implements DraggableContent,
SelectableHeader {
    private static final String DOCKABLE_TITLE_PROPERTY = "title";
    private static final String DOCKABLE_DESCRIPTION_PROPERTY = "description";
    private Dockable dockable;
    private Border selectedBorder = BorderFactory.createLineBorder(Color.gray);
    private Border deselectedBorder = BorderFactory.createLineBorder(Color.gray);
    private boolean selected;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Dimension headerSize = new Dimension(80, 80);
    private int borderWidth = 1;
    private Image smallImage;
    private Dimension smallImageSize;
    private int position = 3;
    private PropertyChangeListener dockableChangeListener;

    public ImageMinimzeHeader(Dockable dockable, int position) {
        this.dockable = dockable;
        this.position = position;
        this.setOpaque(false);
        this.setBorder(this.deselectedBorder);
        this.addToolTip(dockable);
        this.addMouseListener(new SelectionListener());
        this.setMinimumSize(this.headerSize);
        this.setMaximumSize(this.headerSize);
        this.setPreferredSize(this.headerSize);
        this.dockableChangeListener = new DockableChangeListener();
        dockable.addPropertyChangeListener(this.dockableChangeListener);
        try {
            Component component = dockable.getContent();
            if (component.getSize().width <= 0 || component.getSize().height <= 0) {
                JWindow frame = new JWindow();
                frame.setLocation(-5000000, -5000000);
                component.setSize(new Dimension(component.getPreferredSize()));
                frame.setSize(component.getPreferredSize());
                frame.getContentPane().add(component);
                frame.setVisible(true);
                Dimension usableHeaderSize = new Dimension(this.headerSize.width - 2 * this.borderWidth, this.headerSize.height - 2 * this.borderWidth);
                float stretchHeight = (float)component.getPreferredSize().height / (float)usableHeaderSize.height;
                float stretchWidth = (float)component.getPreferredSize().width / (float)usableHeaderSize.width;
                float stretch = Math.min(stretchHeight, stretchWidth);
                this.smallImageSize = new Dimension((int)((float)component.getPreferredSize().width / stretch), (int)((float)component.getPreferredSize().height / stretch));
                BufferedImage dockableImage = new BufferedImage(component.getPreferredSize().width, component.getPreferredSize().height, 2);
                Graphics graphics = dockableImage.getGraphics();
                component.paint(graphics);
                graphics.dispose();
                this.smallImage = dockableImage.getScaledInstance(this.smallImageSize.width, this.smallImageSize.height, 4);
                dockableImage.flush();
                frame.dispose();
            } else {
                Dimension usableHeaderSize = new Dimension(this.headerSize.width - 2 * this.borderWidth, this.headerSize.height - 2 * this.borderWidth);
                float stretchHeight = (float)component.getSize().height / (float)usableHeaderSize.height;
                float stretchWidth = (float)component.getSize().width / (float)usableHeaderSize.width;
                float stretch = Math.min(stretchHeight, stretchWidth);
                this.smallImageSize = new Dimension((int)((float)component.getWidth() / stretch), (int)((float)component.getHeight() / stretch));
                BufferedImage dockableImage = new BufferedImage(component.getWidth(), component.getHeight(), 2);
                Graphics graphics = dockableImage.getGraphics();
                component.paint(graphics);
                graphics.dispose();
                this.smallImage = dockableImage.getScaledInstance(this.smallImageSize.width, this.smallImageSize.height, 4);
                dockableImage.flush();
            }
        }
        catch (Exception exception) {
            this.smallImage = null;
            System.out.println("Exception occured while creating the image minimize header.");
            exception.printStackTrace();
        }
    }

    public void dispose() {
        this.dockable.removePropertyChangeListener(this.dockableChangeListener);
    }

    public void addDragListener(DragListener dragListener) {
        this.addMouseListener(dragListener);
        this.addMouseMotionListener(dragListener);
    }

    public Border getDeselectedBorder() {
        return this.deselectedBorder;
    }

    public void setDeselectedBorder(Border border) {
        this.deselectedBorder = border;
    }

    public Border getSelectedBorder() {
        return this.selectedBorder;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelectedBorder(Border selectedBorder) {
        this.selectedBorder = selectedBorder;
    }

    public Dimension getHeaderSize() {
        return this.headerSize;
    }

    public void setHeaderSize(Dimension headerSize) {
        this.headerSize = headerSize;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setSelected(boolean selected) {
        boolean oldValue = this.selected;
        if (oldValue != selected) {
            if (selected) {
                this.setBorder(this.selectedBorder);
            } else {
                this.setBorder(this.deselectedBorder);
            }
        }
        this.revalidate();
        this.repaint();
        this.propertyChangeSupport.firePropertyChange("selected", oldValue, selected);
    }

    public Dimension getPreferredSize() {
        return this.headerSize;
    }

    public Dimension getMaximumSize() {
        return this.headerSize;
    }

    public Dimension getMinimumSize() {
        return this.headerSize;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
        super.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
        super.removePropertyChangeListener(listener);
    }

    protected void paintChildren(Graphics graphics) {
        if (this.smallImage != null) {
            ((Graphics2D)graphics).drawImage(this.smallImage, this.borderWidth, this.borderWidth, this.getSize().width - this.borderWidth, this.getSize().height - this.borderWidth, 0, 0, this.getSize().width - this.borderWidth * 2, this.getSize().height - this.borderWidth * 2, null);
        }
        super.paintChildren(graphics);
    }

    private void addToolTip(Dockable dockable) {
        String description = dockable.getDescription();
        if (description != null) {
            this.setToolTipText(description);
        }
    }

    private class DockableChangeListener
    implements PropertyChangeListener {
        private DockableChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(ImageMinimzeHeader.DOCKABLE_DESCRIPTION_PROPERTY) || propertyChangeEvent.getPropertyName().equals(ImageMinimzeHeader.DOCKABLE_TITLE_PROPERTY)) {
                ImageMinimzeHeader.this.addToolTip(ImageMinimzeHeader.this.dockable);
                ImageMinimzeHeader.this.revalidate();
                ImageMinimzeHeader.this.repaint();
            }
        }
    }

    private class SelectionListener
    implements MouseListener {
        private boolean react = true;

        private SelectionListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                JPopupMenu popupMenu;
                this.react = false;
                DefaultCompositeDockable compositeDockable = null;
                Object object = ImageMinimzeHeader.this.dockable.getVisualizer();
                if (object instanceof Visualizer) {
                    int selectedIndex = -1;
                    Visualizer visualizer = (Visualizer)object;
                    Dockable[] dockables = new Dockable[visualizer.getVisualizedDockableCount()];
                    for (int index = 0; index < visualizer.getVisualizedDockableCount(); ++index) {
                        Dockable dockableOfComposite;
                        dockables[index] = dockableOfComposite = visualizer.getVisualizedDockable(index);
                        if (!ImageMinimzeHeader.this.dockable.equals(dockableOfComposite)) continue;
                        selectedIndex = index;
                    }
                    compositeDockable = new DefaultCompositeDockable(dockables, selectedIndex);
                }
                if ((popupMenu = DockingManager.getComponentFactory().createPopupMenu(ImageMinimzeHeader.this.dockable, compositeDockable)) != null) {
                    popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            } else {
                this.react = true;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.react) {
                if (mouseEvent.getClickCount() == 2) {
                    DefaultDockableStateAction restoreAction = new DefaultDockableStateAction(DockingUtil.retrieveDockableOfDockModel(ImageMinimzeHeader.this.dockable.getID()), 1);
                    restoreAction.actionPerformed(new ActionEvent(this, 1001, "Restore"));
                } else {
                    ImageMinimzeHeader.this.setSelected(!ImageMinimzeHeader.this.isSelected());
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }
    }
}

