/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.component;

import com.javadocking.DockingManager;
import com.javadocking.component.Header;
import com.javadocking.dockable.Dockable;
import com.javadocking.util.DockingUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MaximizeHeader
extends JPanel
implements Header {
    protected static final int HEADER_HEIGHT = 30;
    protected static final int DIVIDER_WIDTH = 6;
    private static final String DOCKABLE_ICON_PROPERTY = "icon";
    private static final String DOCKABLE_TITLE_PROPERTY = "title";
    private static final String DOCKABLE_DESCRIPTION_PROPERTY = "description";
    private Dockable dockable;
    private JLabel titleLabel;
    private JPanel actionPanel;
    private JLabel iconLabel;
    private PropertyChangeListener dockableChangeListener;

    public MaximizeHeader(Dockable dockable, int position) {
        Action[][] actionMatrix;
        this.dockable = dockable;
        this.setLayout(new BoxLayout(this, 0));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.setMinimumSize(new Dimension(30, 30));
        this.iconLabel = DockingManager.getComponentFactory().createJLabel();
        this.iconLabel.setIcon(dockable.getIcon());
        this.add(Box.createRigidArea(new Dimension(6, 0)));
        this.add((Component)this.iconLabel, "West");
        this.add(Box.createRigidArea(new Dimension(6, 0)));
        this.add(Box.createHorizontalGlue());
        this.titleLabel = DockingManager.getComponentFactory().createJLabel();
        this.titleLabel.setText(dockable.getTitle());
        this.titleLabel.setHorizontalAlignment(0);
        this.add(this.titleLabel);
        this.actionPanel = new JPanel();
        this.actionPanel.setLayout(new BoxLayout(this.actionPanel, 0));
        this.add(Box.createRigidArea(new Dimension(6, 0)));
        this.add(Box.createHorizontalGlue());
        this.add(this.actionPanel);
        this.add(Box.createRigidArea(new Dimension(6, 0)));
        Dockable dockableFromModel = DockingUtil.retrieveDockableOfDockModel(dockable.getID());
        if (dockableFromModel == null) {
            dockableFromModel = dockable;
        }
        if ((actionMatrix = dockableFromModel.getActions()) != null) {
            for (int group = actionMatrix.length - 1; group >= 0; --group) {
                Action[] actionGroup = actionMatrix[group];
                if (actionGroup == null) continue;
                for (int index = 0; index < actionGroup.length; ++index) {
                    this.actionPanel.add(DockingManager.getComponentFactory().createIconButton(actionGroup[index]));
                }
                if (group == 0) continue;
                this.actionPanel.add(Box.createRigidArea(new Dimension(3, 0)));
            }
        }
        this.addTooltip();
        this.dockableChangeListener = new DockableChangeListener();
        dockable.addPropertyChangeListener(this.dockableChangeListener);
    }

    public void dispose() {
        this.dockable.removePropertyChangeListener(this.dockableChangeListener);
    }

    public int getPosition() {
        return 3;
    }

    public void setPosition(int orientation) {
    }

    private void addTooltip() {
        String description = this.dockable.getDescription();
        if (description != null) {
            this.setToolTipText(description);
            this.titleLabel.setToolTipText(description);
            this.iconLabel.setToolTipText(description);
            this.actionPanel.setToolTipText(description);
        }
    }

    private class DockableChangeListener
    implements PropertyChangeListener {
        private DockableChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ((propertyChangeEvent.getPropertyName().equals(MaximizeHeader.DOCKABLE_DESCRIPTION_PROPERTY) || propertyChangeEvent.getPropertyName().equals(MaximizeHeader.DOCKABLE_TITLE_PROPERTY) || propertyChangeEvent.getPropertyName().equals(MaximizeHeader.DOCKABLE_ICON_PROPERTY)) && MaximizeHeader.this.iconLabel != null) {
                MaximizeHeader.this.iconLabel.setIcon(MaximizeHeader.this.dockable.getIcon());
            }
            if (MaximizeHeader.this.titleLabel != null) {
                MaximizeHeader.this.titleLabel.setText(MaximizeHeader.this.dockable.getTitle());
            }
            MaximizeHeader.this.addTooltip();
            MaximizeHeader.this.revalidate();
            MaximizeHeader.this.repaint();
        }
    }
}

