/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.component;

import com.javadocking.component.DockHeader;
import com.javadocking.dock.LeafDock;
import com.javadocking.drag.DragListener;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class PointGripDockHeader
extends JPanel
implements DockHeader {
    private static final int HEADER_SIZE = 14;
    private static final Stroke STROKE;
    private static Color light;
    private static Color shadow;
    private LeafDock dock;
    private DragListener dragListener;
    private int position;

    public PointGripDockHeader(LeafDock dock, int position) {
        super(new BorderLayout());
        this.setPosition(position);
        this.dock = dock;
    }

    public void dispose() {
    }

    public void setDragListener(DragListener dragListener) {
        this.dragListener = dragListener;
        this.addMouseMotionListener(dragListener);
        this.addMouseListener(dragListener);
    }

    public DragListener getDragListener() {
        return this.dragListener;
    }

    public LeafDock getDock() {
        return this.dock;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
        if (position == 3 || position == 4) {
            this.setMinimumSize(new Dimension(14, 14));
            this.setMaximumSize(new Dimension(Short.MAX_VALUE, 14));
            this.setPreferredSize(new Dimension(14, 14));
        } else {
            this.setMinimumSize(new Dimension(14, 14));
            this.setMaximumSize(new Dimension(14, Short.MAX_VALUE));
            this.setPreferredSize(new Dimension(14, 14));
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(Color.darkGray);
        if (this.position == 3 || this.position == 4) {
            int width = this.getSize().width;
            graphics.setColor(light);
            graphics.drawLine(4, 3, width - 6, 3);
            graphics.drawArc(2, 3, 6, 6, -90, -180);
            graphics.setColor(shadow);
            graphics.drawLine(4, 9, width - 6, 9);
            graphics.drawArc(width - 8, 3, 6, 6, -90, 180);
            ((Graphics2D)graphics).setStroke(STROKE);
            graphics.drawLine(6, 5, width - 6, 5);
            graphics.drawLine(8, 7, width - 6, 7);
        } else {
            int height = this.getSize().height;
            graphics.setColor(light);
            graphics.drawLine(3, 4, 3, height - 6);
            graphics.drawArc(3, 2, 6, 6, -180, -180);
            graphics.setColor(shadow);
            graphics.drawLine(9, 4, 9, height - 6);
            graphics.drawArc(3, height - 9, 6, 6, 180, 180);
            ((Graphics2D)graphics).setStroke(STROKE);
            graphics.drawLine(5, 6, 5, height - 6);
            graphics.drawLine(7, 8, 7, height - 6);
        }
    }

    static {
        light = Color.white;
        shadow = Color.gray;
        float[] pattern = new float[]{1.0f, 3.0f};
        STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, pattern, 0.0f);
        Color lafLight = (Color)UIManager.getDefaults().get("InternalFrame.borderLight");
        Color lafShadow = (Color)UIManager.getDefaults().get("TabbedPane.borderHightlightColor");
        if (lafLight != null) {
            light = lafLight;
        }
        if (lafShadow != null) {
            shadow = lafShadow;
        }
    }
}

