/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.component;

import com.javadocking.DockingManager;
import com.javadocking.component.DockHeader;
import com.javadocking.dock.LeafDock;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.DragListener;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SingleDockHeader
extends JPanel
implements DockHeader {
    protected static final int HEADER_HEIGHT = 30;
    protected static final int DIVIDER_WIDTH = 6;
    private static final String DOCKABLE_ICON_PROPERTY = "icon";
    private static final String DOCKABLE_TITLE_PROPERTY = "title";
    private static final String DOCKABLE_DESCRIPTION_PROPERTY = "description";
    private Dockable dockable;
    private LeafDock dock;
    private JLabel titleLabel;
    private DragListener dragListener;
    private JPanel actionPanel;
    private JLabel iconLabel;
    private PropertyChangeListener dockableChangeListener;

    public SingleDockHeader(LeafDock dock, int position) {
        if (dock.getDockableCount() != 1) {
            throw new IllegalArgumentException("The dock should contain one and nly one dockable.");
        }
        this.dockable = dock.getDockable(0);
        this.setLayout(new BoxLayout(this, 0));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.setMinimumSize(new Dimension(30, 30));
        this.iconLabel = DockingManager.getComponentFactory().createJLabel();
        this.iconLabel.setIcon(this.dockable.getIcon());
        this.add(Box.createRigidArea(new Dimension(6, 0)));
        this.add((Component)this.iconLabel, "West");
        this.add(Box.createRigidArea(new Dimension(6, 0)));
        this.add(Box.createHorizontalGlue());
        this.titleLabel = DockingManager.getComponentFactory().createJLabel();
        this.titleLabel.setText(this.dockable.getTitle());
        this.titleLabel.setHorizontalAlignment(0);
        this.add(this.titleLabel);
        this.actionPanel = new JPanel();
        this.actionPanel.setLayout(new BoxLayout(this.actionPanel, 0));
        this.add(Box.createRigidArea(new Dimension(6, 0)));
        this.add(Box.createHorizontalGlue());
        this.add(this.actionPanel);
        this.add(Box.createRigidArea(new Dimension(6, 0)));
        Action[][] actionMatrix = this.dockable.getActions();
        if (actionMatrix != null) {
            for (int group = actionMatrix.length - 1; group >= 0; --group) {
                Action[] actionGroup = actionMatrix[group];
                if (actionGroup == null) continue;
                for (int index = 0; index < actionGroup.length; ++index) {
                    this.actionPanel.add(DockingManager.getComponentFactory().createIconButton(actionGroup[index]));
                }
                if (group == 0) continue;
                this.actionPanel.add(Box.createRigidArea(new Dimension(3, 0)));
            }
        }
        this.addTooltip();
        this.dockableChangeListener = new DockableChangeListener();
        this.dockable.addPropertyChangeListener(this.dockableChangeListener);
    }

    public void dispose() {
        this.dockable.removePropertyChangeListener(this.dockableChangeListener);
    }

    public void setDragListener(DragListener dragListener) {
        this.dragListener = dragListener;
        this.titleLabel.addMouseMotionListener(dragListener);
        this.titleLabel.addMouseListener(dragListener);
        this.iconLabel.addMouseMotionListener(dragListener);
        this.iconLabel.addMouseListener(dragListener);
        this.addMouseMotionListener(dragListener);
        this.addMouseListener(dragListener);
    }

    public DragListener getDragListener() {
        return this.dragListener;
    }

    public LeafDock getDock() {
        return this.dock;
    }

    public int getPosition() {
        return 3;
    }

    public void setPosition(int orientation) {
    }

    private void addTooltip() {
        String description = this.dockable.getDescription();
        if (description != null) {
            this.setToolTipText(description);
            this.titleLabel.setToolTipText(description);
            this.iconLabel.setToolTipText(description);
            this.actionPanel.setToolTipText(description);
        }
    }

    private class DockableChangeListener
    implements PropertyChangeListener {
        private DockableChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ((propertyChangeEvent.getPropertyName().equals(SingleDockHeader.DOCKABLE_DESCRIPTION_PROPERTY) || propertyChangeEvent.getPropertyName().equals(SingleDockHeader.DOCKABLE_TITLE_PROPERTY) || propertyChangeEvent.getPropertyName().equals(SingleDockHeader.DOCKABLE_ICON_PROPERTY)) && SingleDockHeader.this.iconLabel != null) {
                SingleDockHeader.this.iconLabel.setIcon(SingleDockHeader.this.dockable.getIcon());
            }
            if (SingleDockHeader.this.titleLabel != null) {
                SingleDockHeader.this.titleLabel.setText(SingleDockHeader.this.dockable.getTitle());
            }
            SingleDockHeader.this.addTooltip();
            SingleDockHeader.this.revalidate();
            SingleDockHeader.this.repaint();
        }
    }
}

