/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dock;

import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.Dock;
import com.javadocking.dock.Position;
import com.javadocking.dock.factory.DockFactory;
import com.javadocking.dock.factory.SingleDockFactory;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.event.ChildDockEvent;
import com.javadocking.event.DockingEventSupport;
import com.javadocking.event.DockingListener;
import com.javadocking.util.PropertiesUtil;
import com.javadocking.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JPanel;

public class CompositeGridDock
extends JPanel
implements CompositeDock {
    private static final double centerPriorityRectangleRelativeOffset = 0.25;
    private static final double leftPriorityRectangleRelativeOffset = 0.125;
    private static final double rightPriorityRectangleRelativeOffset = 0.125;
    public static final int FILL_SQUARE_HORIZONTAL = 0;
    public static final int FILL_SQUARE_VERTICAL = 1;
    public static final int FILL_FLOW_HORIZONTAL = 2;
    public static final int FILL_FLOW_VERTICAL = 3;
    private CompositeDock parentDock;
    private List childDocks = new ArrayList();
    private DockFactory childDockFactory;
    private int columnCount = 1;
    private int fillMode = 2;
    private Rectangle priorityRectangle = new Rectangle();
    private Rectangle helpRectangle = new Rectangle();
    private JPanel dockPanel;
    private DockingEventSupport dockingEventSupport = new DockingEventSupport();
    private JPanel ghostDockPanel;

    public CompositeGridDock() {
        this(new SingleDockFactory());
    }

    public CompositeGridDock(DockFactory childDockFactory) {
        super(new BorderLayout());
        this.childDockFactory = childDockFactory;
        this.initializeUi(1);
    }

    public int getDockPriority(Dockable dockable, Point relativeLocation) {
        if (!this.checkDockingModes(dockable)) {
            return 0;
        }
        if (this.childDockFactory.createDock(dockable, this.getDockingMode()) != null) {
            if (this.canAddDockableWithPriority(dockable, relativeLocation)) {
                return 3;
            }
            return 2;
        }
        if (dockable instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockable;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                Dockable childDockable = compositeDockable.getDockable(index);
                if (this.childDockFactory.createDock(childDockable, this.getDockingMode()) == null) {
                    return 0;
                }
                if (!this.checkDockingModes(childDockable)) {
                    return 0;
                }
                if (childDockable.getContent() == null) {
                    return 0;
                }
                ++index;
            }
            if (this.canAddDockableWithPriority(dockable, relativeLocation)) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    public int retrieveDockingRectangle(Dockable dockable, Point relativeLocation, Point dockableOffset, Rectangle rectangle) {
        int priority = this.getDockPriority(dockable, relativeLocation);
        if (priority != 0) {
            if (this.childDocks.size() == 0) {
                rectangle.setBounds(0, 0, this.getSize().width, this.getSize().height);
            } else {
                int dockPosition = this.getDockPosition(dockable, relativeLocation);
                if (dockPosition == this.childDocks.size()) {
                    Component childDock = (Component)this.childDocks.get(this.childDocks.size() - 1);
                    rectangle.setSize(childDock.getWidth(), childDock.getHeight());
                    rectangle.setLocation(childDock.getLocation().x + childDock.getWidth(), childDock.getLocation().y);
                } else if (dockPosition == 0) {
                    Component childDock = (Component)this.childDocks.get(0);
                    rectangle.setSize(childDock.getWidth() / 2, childDock.getHeight());
                    rectangle.setLocation(childDock.getLocation().x, childDock.getLocation().y);
                } else {
                    Component childDockBefore = (Component)this.childDocks.get(dockPosition - 1);
                    Component childDockAfter = (Component)this.childDocks.get(dockPosition);
                    if (childDockBefore.getLocation().x < childDockAfter.getLocation().x) {
                        rectangle.setSize(childDockBefore.getWidth() / 2 + childDockAfter.getWidth() / 2, childDockBefore.getHeight());
                        rectangle.setLocation(childDockBefore.getLocation().x + childDockBefore.getWidth() / 2, childDockBefore.getLocation().y);
                    } else {
                        this.helpRectangle.setBounds(childDockBefore.getLocation().x, childDockBefore.getLocation().y, childDockBefore.getSize().width, childDockBefore.getSize().height);
                        if (this.helpRectangle.contains(relativeLocation)) {
                            rectangle.setSize(childDockBefore.getWidth() / 2, childDockBefore.getHeight());
                            rectangle.setLocation(childDockBefore.getLocation().x + childDockBefore.getWidth() / 2, childDockBefore.getLocation().y);
                        } else {
                            rectangle.setSize(childDockAfter.getWidth() / 2, childDockAfter.getHeight());
                            rectangle.setLocation(childDockAfter.getLocation().x, childDockAfter.getLocation().y);
                        }
                    }
                }
            }
        }
        return priority;
    }

    public boolean addDockable(Dockable dockableToAdd, Point relativeLocation, Point dockableOffset) {
        if (this.getDockPriority(dockableToAdd, relativeLocation) == 0) {
            return false;
        }
        int position = this.getDockPosition(dockableToAdd, relativeLocation);
        Dock childDock = this.childDockFactory.createDock(dockableToAdd, this.getDockingMode());
        if (childDock != null) {
            childDock.setParentDock(this);
            childDock.addDockable(dockableToAdd, new Point(0, 0), new Point(0, 0));
            this.addChildDock(childDock, new Position(position));
            SwingUtil.repaintParent(this);
            return true;
        }
        if (dockableToAdd instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockableToAdd;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                Dock oneChildDock = this.childDockFactory.createDock(compositeDockable.getDockable(index), this.getDockingMode());
                if (oneChildDock == null) continue;
                oneChildDock.setParentDock(this);
                oneChildDock.addDockable(compositeDockable.getDockable(index), new Point(0, 0), new Point(0, 0));
                this.addChildDock(oneChildDock, new Position(position));
                ++position;
            }
            SwingUtil.repaintParent(this);
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.childDocks.size() == 0;
    }

    public boolean isFull() {
        return false;
    }

    public CompositeDock getParentDock() {
        return this.parentDock;
    }

    public void setParentDock(CompositeDock parentDock) {
        this.parentDock = parentDock;
    }

    public void saveProperties(String prefix, Properties properties, Map childDockIds) {
        PropertiesUtil.setInteger(properties, prefix + "fillMode", this.fillMode);
        PropertiesUtil.setInteger(properties, prefix + "columnCount", this.columnCount);
        String className = this.childDockFactory.getClass().getName();
        PropertiesUtil.setString(properties, prefix + "childDockFactory", className);
        this.childDockFactory.saveProperties(prefix + "childDockFactory.", properties);
        for (int index = 0; index < this.childDocks.size(); ++index) {
            Dock dock = (Dock)this.childDocks.get(index);
            String childDockId = (String)childDockIds.get(dock);
            Position.setPositionProperty(properties, prefix + "childDock" + childDockId + "." + "position", this.getChildDockPosition(dock));
        }
    }

    public void loadProperties(String prefix, Properties properties, Map newChildDocks, Map dockables, Window owner) throws IOException {
        int fillMode = 2;
        fillMode = PropertiesUtil.getInteger(properties, prefix + "fillMode", fillMode);
        this.setFillMode(fillMode);
        try {
            String className = SingleDockFactory.class.getName();
            className = PropertiesUtil.getString(properties, prefix + "childDockFactory", className);
            Class<?> clazz = Class.forName(className);
            this.childDockFactory = (DockFactory)clazz.newInstance();
            this.childDockFactory.loadProperties(prefix + "childDockFactory.", properties);
        }
        catch (ClassNotFoundException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new SingleDockFactory();
        }
        catch (IllegalAccessException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new SingleDockFactory();
        }
        catch (InstantiationException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new SingleDockFactory();
        }
        String[] childDockIdsArray = new String[newChildDocks.keySet().size()];
        Iterator keyIterator = newChildDocks.keySet().iterator();
        while (keyIterator.hasNext()) {
            String childDockId = (String)keyIterator.next();
            Position position = null;
            position = Position.getPositionProperty(properties, prefix + "childDock" + childDockId + "." + "position", position);
            childDockIdsArray[position.getPosition((int)0)] = childDockId;
        }
        int position = 0;
        for (int index = 0; index < childDockIdsArray.length; ++index) {
            Dock dock = (Dock)newChildDocks.get(childDockIdsArray[index]);
            if (dock.isEmpty()) continue;
            this.addChildDock(dock, new Position(position));
            ++position;
        }
        int savedColumnCount = this.columnCount;
        savedColumnCount = PropertiesUtil.getInteger(properties, prefix + "columnCount", savedColumnCount);
        int savedRowCount = (int)Math.ceil((double)this.childDocks.size() / (double)savedColumnCount);
        while (this.childDocks.size() <= savedRowCount * (savedColumnCount - 1)) {
            --savedColumnCount;
        }
        if (savedColumnCount <= 0) {
            savedColumnCount = 1;
        }
        if (savedColumnCount != this.columnCount) {
            this.rebuildUI(savedColumnCount);
        }
    }

    public void addDockingListener(DockingListener listener) {
        this.dockingEventSupport.addDockingListener(listener);
    }

    public void removeDockingListener(DockingListener listener) {
        this.dockingEventSupport.removeDockingListener(listener);
    }

    public void addChildDock(Dock dock, Position position) throws IllegalStateException {
        int gridPosition = this.getChildDockCount();
        if (position.getDimensions() == 1 && position.getPosition(0) >= 0 && position.getPosition(0) <= this.getChildDockCount()) {
            gridPosition = position.getPosition(0);
        }
        this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, null, this, dock));
        this.childDocks.add(gridPosition, dock);
        dock.setParentDock(this);
        this.rebuildUI(this.calculateColumnCount());
        this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, null, this, dock));
        SwingUtil.repaintParent(this);
    }

    public int getChildDockCount() {
        return this.childDocks.size();
    }

    public Dock getChildDock(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getChildDockCount()) {
            throw new IndexOutOfBoundsException("Index " + index);
        }
        return (Dock)this.childDocks.get(index);
    }

    public Position getChildDockPosition(Dock childDock) throws IllegalArgumentException {
        int position = this.childDocks.indexOf(childDock);
        if (position >= 0) {
            return new Position(position);
        }
        throw new IllegalArgumentException("The dock is not docked in this composite dock.");
    }

    public void emptyChild(Dock emptyChildDock) {
        if (this.childDocks.contains(emptyChildDock)) {
            this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, null, emptyChildDock));
            this.childDocks.remove(emptyChildDock);
            this.rebuildUI(this.calculateColumnCount());
            this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, null, emptyChildDock));
            if (this.isEmpty() && this.ghostDockPanel == null && this.getParentDock() != null) {
                this.getParentDock().emptyChild(this);
            }
            SwingUtil.repaintParent(this);
        }
    }

    public void ghostChild(Dock emptyChildDock) {
        if (this.childDocks.contains(emptyChildDock)) {
            this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, null, emptyChildDock));
            this.childDocks.remove(emptyChildDock);
            this.ghostDockPanel = this.dockPanel;
            this.ghostDockPanel.setVisible(false);
            this.initializeUi(this.calculateColumnCount());
            for (int index = 0; index < this.childDocks.size(); ++index) {
                Dock childDock = (Dock)this.childDocks.get(index);
                this.ghostDockPanel.remove((Component)((Object)childDock));
                this.dockPanel.add((Component)((Object)childDock));
            }
            this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, null, emptyChildDock));
            SwingUtil.repaintParent(this);
        }
    }

    public void clearGhosts() {
        if (this.ghostDockPanel != null) {
            this.remove(this.ghostDockPanel);
            this.ghostDockPanel = null;
            if (this.isEmpty() && this.getParentDock() != null) {
                this.getParentDock().emptyChild(this);
            }
        }
    }

    public DockFactory getChildDockFactory() {
        return this.childDockFactory;
    }

    public void setChildDockFactory(DockFactory childDockFactory) {
        if (childDockFactory == null) {
            throw new IllegalArgumentException("The child dock factory cannot be null.");
        }
        this.childDockFactory = childDockFactory;
    }

    public int getFillMode() {
        return this.fillMode;
    }

    public void setFillMode(int newFillMode) {
        if (newFillMode != this.fillMode) {
            this.fillMode = newFillMode;
            this.rebuildUI(this.calculateColumnCount());
        }
    }

    protected int getDockPosition(Dockable newDockable, Point relativePosition) {
        if (this.childDocks.size() == 0) {
            return 0;
        }
        for (int index = 0; index < this.childDocks.size(); ++index) {
            Component childDock = (Component)this.childDocks.get(index);
            this.helpRectangle.setBounds(childDock.getLocation().x, childDock.getLocation().y, childDock.getSize().width, childDock.getSize().height);
            if (!this.helpRectangle.contains(relativePosition)) continue;
            this.helpRectangle.setSize(childDock.getSize().width / 2, childDock.getSize().height);
            if (this.helpRectangle.contains(relativePosition)) {
                return index;
            }
            return index + 1;
        }
        return this.childDocks.size();
    }

    protected boolean canAddDockableWithPriority(Dockable dockable, Point relativeLocation) {
        if (this.childDocks.size() == 0) {
            Dimension size = this.getSize();
            this.priorityRectangle.setBounds((int)((double)size.width * 0.25), (int)((double)size.height * 0.25), (int)((double)size.width * 0.5), (int)((double)size.height * 0.5));
            return this.priorityRectangle.contains(relativeLocation);
        }
        for (int index = 0; index < this.childDocks.size(); ++index) {
            Component childDock = (Component)this.childDocks.get(index);
            this.helpRectangle.setBounds(childDock.getLocation().x, childDock.getLocation().y, childDock.getSize().width, childDock.getSize().height);
            if (!this.helpRectangle.contains(relativeLocation)) continue;
            this.priorityRectangle.setBounds(childDock.getLocation().x, childDock.getLocation().y, (int)((double)childDock.getSize().width * 0.125), childDock.getSize().height);
            if (this.priorityRectangle.contains(relativeLocation)) {
                return true;
            }
            this.priorityRectangle.setBounds(childDock.getLocation().x + (int)((double)childDock.getSize().width * 0.875), childDock.getLocation().y, (int)((double)childDock.getSize().width * 0.125), childDock.getSize().height);
            return this.priorityRectangle.contains(relativeLocation);
        }
        return false;
    }

    protected int calculateColumnCount() {
        int dockCount = this.childDocks.size();
        if (dockCount == 0) {
            return 1;
        }
        if (this.getSize().width == 0 || this.getSize().height == 0 || this.fillMode == 0 || this.fillMode == 1) {
            int newColumnCount = (int)Math.ceil(Math.sqrt(dockCount));
            if (this.fillMode == 1 && (newColumnCount - 1) * newColumnCount >= dockCount) {
                --newColumnCount;
            }
            if (newColumnCount <= 0) {
                newColumnCount = 1;
            }
            return newColumnCount;
        }
        Dimension maxPreferredSize = new Dimension(0, 0);
        for (int index = 0; index < dockCount; ++index) {
            Dimension childSize = ((Component)this.childDocks.get(index)).getPreferredSize();
            maxPreferredSize.setSize(Math.max(maxPreferredSize.width, childSize.width), Math.max(maxPreferredSize.height, childSize.height));
        }
        if (maxPreferredSize.width <= 0) {
            maxPreferredSize.width = 1;
        }
        if (maxPreferredSize.height <= 0) {
            maxPreferredSize.height = 1;
        }
        if (this.fillMode == 2) {
            int newColumnCount = (int)Math.ceil(Math.sqrt((double)(this.getSize().width * maxPreferredSize.height * dockCount) / (double)(this.getSize().height * maxPreferredSize.width)));
            if (newColumnCount <= 0) {
                newColumnCount = 1;
            }
            int newRowCount = (int)Math.ceil((double)dockCount / (double)newColumnCount);
            while (dockCount <= newRowCount * (newColumnCount - 1)) {
                --newColumnCount;
            }
            if (newColumnCount <= 0) {
                newColumnCount = 1;
            }
            return newColumnCount;
        }
        if (this.fillMode == 3) {
            int newRowCount = (int)Math.ceil(Math.sqrt((double)(this.getSize().height * maxPreferredSize.width * dockCount) / (double)(this.getSize().width * maxPreferredSize.height)));
            if (newRowCount <= 0) {
                newRowCount = 1;
            }
            int newColCount = (int)Math.ceil((double)dockCount / (double)newRowCount);
            return newColCount;
        }
        throw new IllegalStateException("The fill mode [" + this.fillMode + "] is unknown.");
    }

    protected boolean checkDockingModes(Dockable dockable) {
        int dockPositions = dockable.getDockingModes();
        return (dockPositions & 0x400) != 0;
    }

    protected int getDockingMode() {
        return 1024;
    }

    private void initializeUi(int newColumnCount) {
        this.columnCount = newColumnCount;
        this.setLayout(new BorderLayout());
        this.dockPanel = new JPanel();
        this.dockPanel.setLayout(new GridLayout(0, this.columnCount));
        this.add((Component)this.dockPanel, "Center");
    }

    private void rebuildUI(int newColumnCount) {
        int index;
        for (index = 0; index < this.getComponentCount(); ++index) {
            Component component = this.getComponent(index);
            if (component.equals(this.ghostDockPanel)) continue;
            this.remove(component);
        }
        this.initializeUi(newColumnCount);
        for (index = 0; index < this.childDocks.size(); ++index) {
            Dock childDock = (Dock)this.childDocks.get(index);
            this.dockPanel.add((Component)((Object)childDock));
        }
    }
}

