/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dock;

import com.javadocking.dock.CompositeDock;
import com.javadocking.dock.Dock;
import com.javadocking.dock.Position;
import com.javadocking.dock.factory.DockFactory;
import com.javadocking.dock.factory.SingleDockFactory;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.event.ChildDockEvent;
import com.javadocking.event.DockingEventSupport;
import com.javadocking.event.DockingListener;
import com.javadocking.util.DockingUtil;
import com.javadocking.util.PropertiesUtil;
import com.javadocking.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class CompositeLineDock
extends JPanel
implements CompositeDock {
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    private static final int priorityBorder = 10;
    private CompositeDock parentDock;
    private List childDocks = new ArrayList();
    private DockFactory childDockFactory;
    private int orientation = 0;
    private boolean grid;
    private int horizontalDockingMode = 256;
    private int verticalDockingMode = 512;
    private Rectangle priorityRectangle = new Rectangle();
    private Rectangle helpRectangle = new Rectangle();
    private JPanel dockPanel;
    private JPanel alignmentPanel;
    private DockingEventSupport dockingEventSupport = new DockingEventSupport();
    private JPanel ghostDockPanel;
    private JPanel ghostAlignmentPanel;
    private boolean realSizeRectangle = true;

    public CompositeLineDock() {
        this(0, false, new SingleDockFactory());
    }

    public CompositeLineDock(DockFactory childDockFactory) {
        this(0, false, childDockFactory);
    }

    public CompositeLineDock(int orientation, boolean grid) {
        this(orientation, grid, new SingleDockFactory());
    }

    public CompositeLineDock(int orientation, boolean grid, int horizontalDockingMode, int verticalDockingMode) {
        this(orientation, grid, new SingleDockFactory(), horizontalDockingMode, verticalDockingMode);
    }

    public CompositeLineDock(int orientation, boolean grid, DockFactory childDockFactory) {
        this(orientation, grid, childDockFactory, 256, 512);
    }

    public CompositeLineDock(int orientation, boolean grid, DockFactory childDockFactory, int horizontalDockingMode, int verticalDockingMode) {
        super(new BorderLayout());
        this.childDockFactory = childDockFactory;
        this.orientation = orientation;
        this.grid = grid;
        this.horizontalDockingMode = horizontalDockingMode;
        this.verticalDockingMode = verticalDockingMode;
        this.initializeUi();
    }

    public int getDockPriority(Dockable dockable, Point relativeLocation) {
        if (!this.checkDockingModes(dockable)) {
            return 0;
        }
        if (this.childDockFactory.createDock(dockable, this.getDockingMode()) != null) {
            if (this.canAddDockableWithPriority(dockable, relativeLocation)) {
                return 3;
            }
            return 2;
        }
        if (dockable instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockable;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                Dockable childDockable = compositeDockable.getDockable(index);
                if (this.childDockFactory.createDock(childDockable, this.getDockingMode()) == null) {
                    return 0;
                }
                if (!this.checkDockingModes(childDockable)) {
                    return 0;
                }
                if (childDockable.getContent() == null) {
                    return 0;
                }
                ++index;
            }
            if (this.canAddDockableWithPriority(dockable, relativeLocation)) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    public int retrieveDockingRectangle(Dockable dockable, Point relativeLocation, Point dockableOffset, Rectangle rectangle) {
        int priority = this.getDockPriority(dockable, relativeLocation);
        if (priority != 0) {
            if (this.childDocks.size() == 0) {
                if (this.realSizeRectangle) {
                    if (this.orientation == 0) {
                        int width = 0;
                        width = dockable instanceof CompositeDockable ? DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)((CompositeDockable)dockable), (int)256).width : dockable.getContent().getPreferredSize().width;
                        rectangle.setBounds(0, 0, width, this.getSize().height);
                    } else {
                        int height = 0;
                        height = dockable instanceof CompositeDockable ? DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)((CompositeDockable)dockable), (int)512).height : dockable.getContent().getPreferredSize().height;
                        rectangle.setBounds(0, 0, this.getSize().width, height);
                    }
                } else {
                    rectangle.setBounds(0, 0, this.getSize().width, this.getSize().height);
                }
            } else {
                int index;
                int nextDockStart;
                if (this.realSizeRectangle) {
                    Component dockComponent;
                    Point dockablePanelPosition = new Point();
                    dockablePanelPosition.setLocation(relativeLocation);
                    for (int index2 = 0; index2 < this.childDocks.size(); ++index2) {
                        dockComponent = (Component)((Object)((Dock)this.childDocks.get(index2)));
                        Point dockPosition = new Point();
                        dockPosition.setLocation(dockComponent.getLocation().x, dockComponent.getLocation().y);
                        rectangle.setLocation(dockPosition);
                        rectangle.setSize(dockComponent.getSize().width, dockComponent.getSize().height);
                        if (!rectangle.contains(dockablePanelPosition)) continue;
                        if (index2 == this.childDocks.size() - 1) {
                            if (this.orientation == 0) {
                                dockPosition.setLocation(dockComponent.getLocation().x + dockComponent.getSize().width / 2, dockComponent.getLocation().y);
                                rectangle.setLocation(dockPosition);
                                rectangle.setSize(dockComponent.getSize().width, dockComponent.getSize().height);
                                if (rectangle.contains(dockablePanelPosition)) {
                                    dockPosition.setLocation(dockComponent.getLocation().x + dockComponent.getSize().width, dockComponent.getLocation().y);
                                } else {
                                    dockPosition.setLocation(dockComponent.getLocation().x, dockComponent.getLocation().y);
                                    rectangle.setLocation(dockPosition);
                                    rectangle.setSize(dockComponent.getSize().width, dockComponent.getSize().height);
                                }
                            } else {
                                dockPosition.setLocation(dockComponent.getLocation().x, dockComponent.getLocation().y + dockComponent.getSize().height / 2);
                                rectangle.setLocation(dockPosition);
                                rectangle.setSize(dockComponent.getSize().width, dockComponent.getSize().height);
                                if (rectangle.contains(dockablePanelPosition)) {
                                    dockPosition.setLocation(dockComponent.getLocation().x, dockComponent.getLocation().y + dockComponent.getSize().height);
                                } else {
                                    dockPosition.setLocation(dockComponent.getLocation().x, dockComponent.getLocation().y);
                                    rectangle.setLocation(dockPosition);
                                    rectangle.setSize(dockComponent.getSize().width, dockComponent.getSize().height);
                                }
                            }
                        }
                        if (dockable instanceof CompositeDockable) {
                            CompositeDockable compositeDockable = (CompositeDockable)dockable;
                            if (this.realSizeRectangle) {
                                if (this.orientation == 0) {
                                    int width = DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)compositeDockable, (int)256).width;
                                    rectangle.setSize(width, dockComponent.getSize().height);
                                } else {
                                    int height = DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)compositeDockable, (int)512).height;
                                    rectangle.setSize(dockComponent.getSize().width, height);
                                }
                            }
                        } else if (this.orientation == 0) {
                            Dimension rectangleSize = new Dimension(dockable.getContent().getPreferredSize().width, dockComponent.getSize().height);
                            rectangle.setSize(rectangleSize);
                        } else {
                            Dimension rectangleSize = new Dimension(dockComponent.getSize().width, dockable.getContent().getPreferredSize().height);
                            rectangle.setSize(rectangleSize);
                        }
                        rectangle.setLocation(dockPosition);
                        return priority;
                    }
                    if (this.orientation == 0) {
                        Point dockPosition = new Point();
                        dockComponent = (Component)((Object)((Dock)this.childDocks.get(this.childDocks.size() - 1)));
                        dockPosition.setLocation(dockComponent.getLocation().x + dockComponent.getSize().width, dockComponent.getLocation().y);
                        int width = 0;
                        width = dockable instanceof CompositeDockable ? DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)((CompositeDockable)dockable), (int)256).width : dockable.getContent().getPreferredSize().width;
                        rectangle.setLocation(dockPosition);
                        rectangle.setSize(width, dockComponent.getSize().height);
                        return priority;
                    }
                    Point dockPosition = new Point();
                    dockComponent = (Component)((Object)((Dock)this.childDocks.get(this.childDocks.size() - 1)));
                    dockPosition.setLocation(dockComponent.getLocation().x, dockComponent.getLocation().y + dockComponent.getSize().height);
                    int height = 0;
                    height = dockable instanceof CompositeDockable ? DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)((CompositeDockable)dockable), (int)512).height : dockable.getContent().getPreferredSize().height;
                    rectangle.setLocation(dockPosition);
                    rectangle.setSize(dockComponent.getSize().width, height);
                    return priority;
                }
                if (this.orientation == 0) {
                    int currentDockWidth = 0;
                    int nextDockWidth = ((Component)this.childDocks.get((int)0)).getSize().width;
                    nextDockStart = 0;
                    rectangle.setBounds(0, 0, nextDockWidth / 2, this.dockPanel.getSize().height);
                    for (index = 0; index < this.childDocks.size() - 1; ++index) {
                        if (rectangle.contains(relativeLocation)) {
                            return priority;
                        }
                        currentDockWidth = nextDockWidth;
                        nextDockWidth = ((Component)this.childDocks.get((int)(index + 1))).getSize().width;
                        rectangle.setBounds((nextDockStart += currentDockWidth) - currentDockWidth / 2, 0, (currentDockWidth + nextDockWidth) / 2, this.dockPanel.getSize().height);
                    }
                    if (rectangle.contains(relativeLocation)) {
                        return priority;
                    }
                    currentDockWidth = nextDockWidth;
                    rectangle.setBounds((nextDockStart += currentDockWidth) - currentDockWidth / 2, 0, currentDockWidth / 2, this.dockPanel.getSize().height);
                    if (rectangle.contains(relativeLocation)) {
                        return priority;
                    }
                }
                if (this.orientation == 1) {
                    int currentDockHeight = 0;
                    int nextDockHeight = ((Component)this.childDocks.get((int)0)).getSize().height;
                    nextDockStart = 0;
                    rectangle.setBounds(0, 0, this.dockPanel.getSize().width, nextDockHeight / 2);
                    for (index = 0; index < this.childDocks.size() - 1; ++index) {
                        if (rectangle.contains(relativeLocation)) {
                            return priority;
                        }
                        currentDockHeight = nextDockHeight;
                        nextDockHeight = ((Component)this.childDocks.get((int)(index + 1))).getSize().height;
                        rectangle.setBounds(0, (nextDockStart += currentDockHeight) - currentDockHeight / 2, this.dockPanel.getSize().width, (currentDockHeight + nextDockHeight) / 2);
                    }
                    if (rectangle.contains(relativeLocation)) {
                        return priority;
                    }
                    currentDockHeight = nextDockHeight;
                    rectangle.setBounds(0, (nextDockStart += currentDockHeight) - currentDockHeight / 2, this.dockPanel.getSize().width, currentDockHeight / 2);
                    if (rectangle.contains(relativeLocation)) {
                        return priority;
                    }
                }
            }
        }
        return priority;
    }

    public boolean addDockable(Dockable dockableToAdd, Point relativeLocation, Point dockableOffset) {
        if (this.getDockPriority(dockableToAdd, relativeLocation) == 0) {
            return false;
        }
        int position = this.getDockPosition(dockableToAdd, relativeLocation);
        Dock childDock = this.childDockFactory.createDock(dockableToAdd, this.getDockingMode());
        if (childDock != null) {
            childDock.setParentDock(this);
            childDock.addDockable(dockableToAdd, new Point(0, 0), new Point(0, 0));
            this.addChildDock(childDock, new Position(position));
            SwingUtil.repaintParent(this);
            return true;
        }
        if (dockableToAdd instanceof CompositeDockable) {
            CompositeDockable compositeDockable = (CompositeDockable)dockableToAdd;
            for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                Dock oneChildDock = this.childDockFactory.createDock(compositeDockable.getDockable(index), this.getDockingMode());
                if (oneChildDock == null) continue;
                oneChildDock.setParentDock(this);
                oneChildDock.addDockable(compositeDockable.getDockable(index), new Point(0, 0), new Point(0, 0));
                this.addChildDock(oneChildDock, new Position(position));
                ++position;
            }
            SwingUtil.repaintParent(this);
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.childDocks.size() == 0;
    }

    public boolean isFull() {
        return false;
    }

    public CompositeDock getParentDock() {
        return this.parentDock;
    }

    public void setParentDock(CompositeDock parentDock) {
        this.parentDock = parentDock;
    }

    public void saveProperties(String prefix, Properties properties, Map childDockIds) {
        PropertiesUtil.setInteger(properties, prefix + "horizontalDockingMode", this.horizontalDockingMode);
        PropertiesUtil.setInteger(properties, prefix + "verticalDockingMode", this.verticalDockingMode);
        PropertiesUtil.setInteger(properties, prefix + "orientation", this.orientation);
        PropertiesUtil.setBoolean(properties, prefix + "grid", this.grid);
        String className = this.childDockFactory.getClass().getName();
        PropertiesUtil.setString(properties, prefix + "childDockFactory", className);
        this.childDockFactory.saveProperties(prefix + "childDockFactory.", properties);
        for (int index = 0; index < this.childDocks.size(); ++index) {
            Dock dock = (Dock)this.childDocks.get(index);
            String childDockId = (String)childDockIds.get(dock);
            Position.setPositionProperty(properties, prefix + "childDock" + childDockId + "." + "position", this.getChildDockPosition(dock));
        }
    }

    public void loadProperties(String prefix, Properties properties, Map newChildDocks, Map dockablesMap, Window owner) throws IOException {
        int horizontalDockingMode = 256;
        int verticalDockingMode = 512;
        int orientation = 0;
        boolean grid = false;
        horizontalDockingMode = PropertiesUtil.getInteger(properties, prefix + "horizontalDockingMode", horizontalDockingMode);
        verticalDockingMode = PropertiesUtil.getInteger(properties, prefix + "verticalDockingMode", verticalDockingMode);
        orientation = PropertiesUtil.getInteger(properties, prefix + "orientation", orientation);
        grid = PropertiesUtil.getBoolean(properties, prefix + "grid", grid);
        this.setOrientation(orientation);
        this.setGrid(grid);
        this.horizontalDockingMode = horizontalDockingMode;
        this.verticalDockingMode = verticalDockingMode;
        try {
            String className = SingleDockFactory.class.getName();
            className = PropertiesUtil.getString(properties, prefix + "childDockFactory", className);
            Class<?> clazz = Class.forName(className);
            this.childDockFactory = (DockFactory)clazz.newInstance();
            this.childDockFactory.loadProperties(prefix + "childDockFactory.", properties);
        }
        catch (ClassNotFoundException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new SingleDockFactory();
        }
        catch (IllegalAccessException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new SingleDockFactory();
        }
        catch (InstantiationException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new SingleDockFactory();
        }
        String[] childDockIdsArray = new String[newChildDocks.keySet().size()];
        Iterator keyIterator = newChildDocks.keySet().iterator();
        while (keyIterator.hasNext()) {
            String childDockId = (String)keyIterator.next();
            Position position = null;
            position = Position.getPositionProperty(properties, prefix + "childDock" + childDockId + "." + "position", position);
            childDockIdsArray[position.getPosition((int)0)] = childDockId;
        }
        int position = 0;
        for (int index = 0; index < childDockIdsArray.length; ++index) {
            Dock dock = (Dock)newChildDocks.get(childDockIdsArray[index]);
            if (dock.isEmpty()) continue;
            this.addChildDock(dock, new Position(position));
            ++position;
        }
    }

    public void addDockingListener(DockingListener listener) {
        this.dockingEventSupport.addDockingListener(listener);
    }

    public void removeDockingListener(DockingListener listener) {
        this.dockingEventSupport.removeDockingListener(listener);
    }

    public void addChildDock(Dock dock, Position position) throws IllegalStateException {
        int linePosition = this.getChildDockCount();
        if (position.getDimensions() == 1 && position.getPosition(0) >= 0 && position.getPosition(0) <= this.getChildDockCount()) {
            linePosition = position.getPosition(0);
        }
        this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, null, this, dock));
        this.childDocks.add(linePosition, dock);
        dock.setParentDock(this);
        this.dockPanel.removeAll();
        for (int index = 0; index < this.childDocks.size(); ++index) {
            this.dockPanel.add((Component)this.childDocks.get(index));
        }
        this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, null, this, dock));
        SwingUtil.repaintParent(this);
    }

    public int getChildDockCount() {
        return this.childDocks.size();
    }

    public Dock getChildDock(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.getChildDockCount()) {
            throw new IndexOutOfBoundsException("Index " + index);
        }
        return (Dock)this.childDocks.get(index);
    }

    public Position getChildDockPosition(Dock childDock) throws IllegalArgumentException {
        int position = this.childDocks.indexOf(childDock);
        if (position >= 0) {
            return new Position(position);
        }
        throw new IllegalArgumentException("The dock is not docked in this composite dock.");
    }

    public void emptyChild(Dock emptyChildDock) {
        if (this.childDocks.contains(emptyChildDock)) {
            this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, null, emptyChildDock));
            this.dockPanel.remove((Component)((Object)emptyChildDock));
            this.childDocks.remove(emptyChildDock);
            this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, null, emptyChildDock));
            if (this.isEmpty() && this.ghostDockPanel == null && this.ghostAlignmentPanel == null && this.getParentDock() != null) {
                this.getParentDock().emptyChild(this);
            }
            SwingUtil.repaintParent(this);
        }
    }

    public void ghostChild(Dock emptyChildDock) {
        if (this.childDocks.contains(emptyChildDock)) {
            this.dockingEventSupport.fireDockingWillChange(new ChildDockEvent(this, this, null, emptyChildDock));
            this.childDocks.remove(emptyChildDock);
            this.ghostDockPanel = this.dockPanel;
            this.ghostAlignmentPanel = this.alignmentPanel;
            this.ghostAlignmentPanel.setVisible(false);
            this.initializeUi();
            for (int index = 0; index < this.childDocks.size(); ++index) {
                Dock childDock = (Dock)this.childDocks.get(index);
                this.ghostDockPanel.remove((Component)((Object)childDock));
                this.dockPanel.add((Component)((Object)childDock));
            }
            this.dockingEventSupport.fireDockingChanged(new ChildDockEvent(this, this, null, emptyChildDock));
        }
    }

    public void clearGhosts() {
        if (this.ghostDockPanel != null) {
            this.remove(this.ghostAlignmentPanel);
            this.ghostAlignmentPanel = null;
            this.ghostDockPanel = null;
            if (this.isEmpty() && this.getParentDock() != null) {
                this.getParentDock().emptyChild(this);
            }
        }
    }

    public DockFactory getChildDockFactory() {
        return this.childDockFactory;
    }

    public void setChildDockFactory(DockFactory childDockFactory) {
        if (childDockFactory == null) {
            throw new IllegalArgumentException("The child dock factory cannot be null.");
        }
        this.childDockFactory = childDockFactory;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int newOrientation) {
        if (newOrientation != this.orientation) {
            this.orientation = newOrientation;
            this.rebuildUI();
        }
    }

    public boolean getGrid() {
        return this.grid;
    }

    public void setGrid(boolean newGrid) {
        if (newGrid != this.grid) {
            this.grid = newGrid;
            this.rebuildUI();
        }
    }

    public boolean getRealSizeRectangle() {
        return this.realSizeRectangle;
    }

    public void setRealSizeRectangle(boolean realSizeRectangle) {
        this.realSizeRectangle = realSizeRectangle;
    }

    protected boolean checkDockingModes(Dockable dockable) {
        int dockPositions = dockable.getDockingModes();
        if (this.getOrientation() == 0 && (dockPositions & this.horizontalDockingMode) == 0) {
            return false;
        }
        return this.getOrientation() != 1 || (dockPositions & this.verticalDockingMode) != 0;
    }

    protected int getDockingMode() {
        switch (this.getOrientation()) {
            case 0: {
                return this.horizontalDockingMode;
            }
            case 1: {
                return this.verticalDockingMode;
            }
        }
        throw new IllegalArgumentException("The orinetation [" + this.getOrientation() + "] is illegal for this dock.");
    }

    protected int getDockPosition(Dockable newDockable, Point relativePosition) {
        if (this.childDocks.size() == 0) {
            return 0;
        }
        if (this.orientation == 0) {
            int currentDockWidth = 0;
            int nextDockWidth = ((Component)this.childDocks.get((int)0)).getSize().width;
            int nextDockStart = 0;
            this.helpRectangle.setBounds(0, 0, nextDockWidth / 2, this.dockPanel.getSize().height);
            for (int index = 0; index < this.childDocks.size() - 1; ++index) {
                if (this.helpRectangle.contains(relativePosition)) {
                    return index;
                }
                currentDockWidth = nextDockWidth;
                nextDockWidth = ((Component)this.childDocks.get((int)(index + 1))).getSize().width;
                this.helpRectangle.setBounds((nextDockStart += currentDockWidth) - currentDockWidth / 2, 0, (currentDockWidth + nextDockWidth) / 2, this.dockPanel.getSize().height);
            }
            if (this.helpRectangle.contains(relativePosition)) {
                return this.childDocks.size() - 1;
            }
            currentDockWidth = nextDockWidth;
            nextDockWidth = 0;
            this.helpRectangle.setBounds((nextDockStart += currentDockWidth) - currentDockWidth / 2, 0, (currentDockWidth + nextDockWidth) / 2, this.dockPanel.getSize().height);
            if (this.helpRectangle.contains(relativePosition)) {
                return this.childDocks.size();
            }
        } else {
            int currentDockHeight = 0;
            int nextDockHeight = ((Component)this.childDocks.get((int)0)).getSize().height;
            int nextDockStart = 0;
            this.helpRectangle.setBounds(0, 0, this.dockPanel.getSize().width, nextDockHeight / 2);
            for (int index = 0; index < this.childDocks.size() - 1; ++index) {
                if (this.helpRectangle.contains(relativePosition)) {
                    return index;
                }
                currentDockHeight = nextDockHeight;
                nextDockHeight = ((Component)this.childDocks.get((int)(index + 1))).getSize().height;
                this.helpRectangle.setBounds(0, (nextDockStart += currentDockHeight) - currentDockHeight / 2, this.dockPanel.getSize().width, (currentDockHeight + nextDockHeight) / 2);
            }
            if (this.helpRectangle.contains(relativePosition)) {
                return this.childDocks.size() - 1;
            }
            currentDockHeight = nextDockHeight;
            nextDockHeight = 0;
            this.helpRectangle.setBounds(0, (nextDockStart += currentDockHeight) - currentDockHeight / 2, this.dockPanel.getSize().width, (currentDockHeight + nextDockHeight) / 2);
            if (this.helpRectangle.contains(relativePosition)) {
                return this.childDocks.size();
            }
        }
        return this.childDocks.size();
    }

    protected boolean canAddDockableWithPriority(Dockable dockable, Point relativeLocation) {
        if (this.childDocks.size() == 0) {
            this.priorityRectangle.setBounds(10, 10, this.getSize().width - 20, this.getSize().height - 20);
            return this.priorityRectangle.contains(relativeLocation);
        }
        if (this.orientation == 0) {
            this.priorityRectangle.setBounds(-10, 10, 20, this.dockPanel.getSize().height - 20);
            for (int index = 0; index < this.childDocks.size(); ++index) {
                if (this.priorityRectangle.contains(relativeLocation)) {
                    return true;
                }
                int childWidth = ((Component)this.childDocks.get((int)index)).getSize().width;
                this.priorityRectangle.translate(childWidth, 0);
            }
            if (this.priorityRectangle.contains(relativeLocation)) {
                return true;
            }
        } else {
            this.priorityRectangle.setBounds(10, -10, this.dockPanel.getSize().width - 20, 20);
            for (int index = 0; index < this.childDocks.size(); ++index) {
                if (this.priorityRectangle.contains(relativeLocation)) {
                    return true;
                }
                int childHeight = ((Component)this.childDocks.get((int)index)).getSize().height;
                this.priorityRectangle.translate(0, childHeight);
            }
            if (this.priorityRectangle.contains(relativeLocation)) {
                return true;
            }
        }
        return false;
    }

    private void initializeUi() {
        this.dockPanel = new JPanel();
        if (this.grid) {
            if (this.orientation == 1) {
                this.dockPanel.setLayout(new GridLayout(0, 1));
            } else {
                this.dockPanel.setLayout(new GridLayout(1, 0));
            }
        } else if (this.orientation == 1) {
            this.dockPanel.setLayout(new BoxLayout(this.dockPanel, 1));
        } else {
            this.dockPanel.setLayout(new BoxLayout(this.dockPanel, 0));
        }
        this.alignmentPanel = new JPanel();
        if (this.orientation == 1) {
            this.alignmentPanel.setLayout(new BoxLayout(this.alignmentPanel, 1));
        } else {
            this.alignmentPanel.setLayout(new BoxLayout(this.alignmentPanel, 0));
        }
        if (this.orientation == 0) {
            this.alignmentPanel.add(Box.createVerticalGlue());
        } else {
            this.alignmentPanel.add(Box.createHorizontalGlue());
        }
        this.alignmentPanel.add(this.dockPanel);
        this.add((Component)this.alignmentPanel, "Center");
    }

    private void rebuildUI() {
        this.removeAll();
        this.initializeUi();
        for (int index = 0; index < this.childDocks.size(); ++index) {
            Dock childDock = (Dock)this.childDocks.get(index);
            this.dockPanel.add((Component)((Object)childDock));
        }
    }
}

