/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dock;

import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class Position {
    static final String PROPERTY_POSITION = "position";
    private static final char COMMA = ',';
    public static final int CENTER = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    private int[] positions;

    public Position() {
        this.positions = new int[0];
    }

    public Position(int position) {
        this.positions = new int[1];
        this.positions[0] = position;
    }

    public Position(int positionX, int positionY) {
        this.positions = new int[2];
        this.positions[0] = positionX;
        this.positions[1] = positionY;
    }

    public Position(int positionX, int positionY, int positionZ) {
        this.positions = new int[3];
        this.positions[0] = positionX;
        this.positions[1] = positionY;
        this.positions[2] = positionZ;
    }

    public Position(int[] positions) {
        this.positions = positions;
    }

    public int getDimensions() {
        return this.positions.length;
    }

    public int getPosition(int dimension) {
        if (dimension < 0 || dimension >= this.positions.length) {
            throw new IllegalArgumentException("Illegal dimension [" + dimension + "].");
        }
        return this.positions[dimension];
    }

    public boolean equals(Object object) {
        if (!(object instanceof Position)) {
            return false;
        }
        Position other = (Position)object;
        if (other.getDimensions() != this.getDimensions()) {
            return false;
        }
        for (int dimension = 0; dimension < this.getDimensions(); ++dimension) {
            if (this.getPosition(dimension) == other.getPosition(dimension)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        for (int dimension = 0; dimension < this.getDimensions(); ++dimension) {
            result = 37 * result + this.getPosition(dimension);
        }
        return result;
    }

    public String toString() {
        StringBuffer positionString = new StringBuffer("(");
        for (int dimension = 0; dimension < this.getDimensions() - 1; ++dimension) {
            positionString.append(this.getPosition(dimension));
            positionString.append(',');
        }
        if (this.getDimensions() > 0) {
            positionString.append(this.getPosition(this.getDimensions() - 1));
        }
        positionString.append(")");
        return positionString.toString();
    }

    public static Position getPositionProperty(Properties properties, String name, Position defaultValue) {
        String stringValue = properties.getProperty(name);
        if (stringValue == null || stringValue.length() == 0) {
            return defaultValue;
        }
        try {
            stringValue = stringValue.trim();
            StringTokenizer tokenizer = new StringTokenizer(stringValue, "[{(,/)}]");
            ArrayList<Integer> positionList = new ArrayList<Integer>();
            while (tokenizer.hasMoreElements()) {
                String positionString = tokenizer.nextToken();
                int position = Integer.parseInt(positionString);
                positionList.add(new Integer(position));
            }
            int[] positions = new int[positionList.size()];
            for (int index = 0; index < positionList.size(); ++index) {
                positions[index] = (Integer)positionList.get(index);
            }
            return new Position(positions);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static void setPositionProperty(Properties properties, String name, Position value) {
        if (value != null) {
            StringBuffer positionString = new StringBuffer("(");
            for (int dimension = 0; dimension < value.getDimensions() - 1; ++dimension) {
                positionString.append(value.getPosition(dimension));
                positionString.append(',');
            }
            if (value.getDimensions() > 0) {
                positionString.append(value.getPosition(value.getDimensions() - 1));
            }
            positionString.append(")");
            properties.put(name, positionString.toString());
        }
    }
}

