/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dock.docker;

import com.javadocking.dockable.Dockable;
import com.javadocking.util.PropertiesUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;

class LastDockables {
    private static int counter = -2147483647;
    private Map dockables = new WeakHashMap();

    LastDockables() {
    }

    public void add(Dockable dockable) {
        this.dockables.put(dockable, new Integer(counter));
        counter = counter < Integer.MAX_VALUE ? ++counter : -2147483647;
    }

    public Dockable getLastValidDockable() {
        ArrayList<Dockable> dockablesToRemove = new ArrayList<Dockable>();
        Dockable lastDockable = null;
        Integer lastDockableValue = new Integer(Integer.MIN_VALUE);
        Iterator dockableIterator = this.dockables.keySet().iterator();
        while (dockableIterator.hasNext()) {
            Dockable dockable = (Dockable)dockableIterator.next();
            if (dockable.getDock() == null) {
                dockablesToRemove.add(dockable);
                continue;
            }
            if (lastDockableValue.compareTo((Integer)this.dockables.get(dockable)) > 0) continue;
            lastDockable = dockable;
            lastDockableValue = (Integer)this.dockables.get(dockable);
        }
        Iterator removeIterator = dockablesToRemove.iterator();
        while (removeIterator.hasNext()) {
            this.dockables.remove(removeIterator.next());
        }
        return lastDockable;
    }

    public void saveProperties(String prefix, Properties properties) {
        int count = 0;
        Iterator iterator = this.dockables.keySet().iterator();
        while (iterator.hasNext()) {
            Dockable dockable = (Dockable)iterator.next();
            Integer value = (Integer)this.dockables.get(dockable);
            if (value == null) continue;
            PropertiesUtil.setString(properties, prefix + "dockable" + count, dockable.getID());
            PropertiesUtil.setInteger(properties, prefix + "value" + count, value);
            ++count;
        }
        PropertiesUtil.setInteger(properties, prefix + "count", count);
    }

    public void loadProperties(String prefix, Properties properties, Map dockablesMap) throws IOException {
        int count = 0;
        count = PropertiesUtil.getInteger(properties, prefix + "count", count);
        int maxValue = -2147483647;
        for (int index = 0; index < count; ++index) {
            String id = PropertiesUtil.getString(properties, prefix + "dockable" + index, null);
            int value = PropertiesUtil.getInteger(properties, prefix + "value" + index, -2147483647);
            if (id == null) continue;
            Dockable dockable = (Dockable)dockablesMap.get(id);
            if (dockable != null) {
                this.dockables.put(dockable, new Integer(value));
            }
            if (value <= maxValue) continue;
            maxValue = value;
        }
        counter = maxValue + 1;
    }
}

