/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dock.factory;

import com.javadocking.dock.CompositeTabDock;
import com.javadocking.dock.Dock;
import com.javadocking.dock.factory.CompositeDockFactory;
import com.javadocking.dock.factory.DockFactory;
import com.javadocking.dock.factory.LeafDockFactory;
import com.javadocking.dock.factory.SingleDockFactory;
import com.javadocking.dock.factory.TabDockFactory;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.util.DockingUtil;
import com.javadocking.util.PropertiesUtil;
import java.awt.Dimension;
import java.util.Properties;

public class CompositeTabDockFactory
implements CompositeDockFactory {
    private DockFactory alternativeDockFactory = new LeafDockFactory();
    private DockFactory childDockFactory = new SingleDockFactory(null);

    public Dock createDock(Dockable dockable, int dockingMode) {
        Dock dock = this.childDockFactory.createDock(dockable, dockingMode);
        if (dock != null) {
            return dock;
        }
        int dockPositions = dockable.getDockingModes();
        if ((dockPositions & 0x10) != 0) {
            return new CompositeTabDock(this);
        }
        return this.alternativeDockFactory.createDock(dockable, dockingMode);
    }

    public Dimension getDockPreferredSize(Dockable dockable, int dockingMode) {
        Dock dock = this.childDockFactory.createDock(dockable, dockingMode);
        if (dock != null) {
            return this.childDockFactory.getDockPreferredSize(dockable, dockingMode);
        }
        int dockPositions = dockable.getDockingModes();
        if ((dockPositions & 0x10) != 0) {
            if (dockable instanceof CompositeDockable) {
                return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 16);
            }
            return dockable.getContent().getPreferredSize();
        }
        return this.alternativeDockFactory.getDockPreferredSize(dockable, dockingMode);
    }

    public void saveProperties(String prefix, Properties properties) {
        String leafChildDockFactoryClassName = this.childDockFactory.getClass().getName();
        PropertiesUtil.setString(properties, prefix + "childDockFactory", leafChildDockFactoryClassName);
        this.childDockFactory.saveProperties(prefix + "childDockFactory.", properties);
        String alternativeDockFactoryClassName = this.alternativeDockFactory.getClass().getName();
        PropertiesUtil.setString(properties, prefix + "alternativeDockFactory", alternativeDockFactoryClassName);
        this.alternativeDockFactory.saveProperties(prefix + "alternativeDockFactory.", properties);
    }

    public void loadProperties(String prefix, Properties properties) {
        try {
            String leafChildDockFactoryClassName = LeafDockFactory.class.getName();
            leafChildDockFactoryClassName = PropertiesUtil.getString(properties, prefix + "childDockFactory", leafChildDockFactoryClassName);
            Class<?> leafChildDockFactoryClazz = Class.forName(leafChildDockFactoryClassName);
            this.childDockFactory = (DockFactory)leafChildDockFactoryClazz.newInstance();
            this.childDockFactory.loadProperties(prefix + "childDockFactory.", properties);
        }
        catch (ClassNotFoundException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new TabDockFactory();
        }
        catch (IllegalAccessException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new TabDockFactory();
        }
        catch (InstantiationException exception) {
            System.out.println("Could not create the child dock factory.");
            exception.printStackTrace();
            this.childDockFactory = new TabDockFactory();
        }
        try {
            String alternativeDockFactoryClassName = LeafDockFactory.class.getName();
            alternativeDockFactoryClassName = PropertiesUtil.getString(properties, prefix + "alternativeDockFactory", alternativeDockFactoryClassName);
            Class<?> alternativeDockFactoryClazz = Class.forName(alternativeDockFactoryClassName);
            this.alternativeDockFactory = (DockFactory)alternativeDockFactoryClazz.newInstance();
            this.alternativeDockFactory.loadProperties(prefix + "alternativeDockFactory.", properties);
        }
        catch (ClassNotFoundException exception) {
            System.out.println("Could not create the alternative dock factory.");
            exception.printStackTrace();
            this.alternativeDockFactory = new LeafDockFactory();
        }
        catch (IllegalAccessException exception) {
            System.out.println("Could not create the alternative dock factory.");
            exception.printStackTrace();
            this.alternativeDockFactory = new LeafDockFactory();
        }
        catch (InstantiationException exception) {
            System.out.println("Could not create the alternative dock factory.");
            exception.printStackTrace();
            this.alternativeDockFactory = new LeafDockFactory();
        }
    }

    public DockFactory getAlternativeDockFactory() {
        return this.alternativeDockFactory;
    }

    public void setAlternativeDockFactory(DockFactory alternativeDockFactory) {
        if (alternativeDockFactory == null) {
            throw new IllegalArgumentException("The alternative dock factory cannot be null.");
        }
        this.alternativeDockFactory = alternativeDockFactory;
    }

    public DockFactory getChildDockFactory() {
        return this.childDockFactory;
    }

    public void setChildDockFactory(DockFactory leafChildDockFactory) {
        if (leafChildDockFactory == null) {
            throw new IllegalArgumentException("The leaf dock factory cannot be null.");
        }
        this.childDockFactory = leafChildDockFactory;
    }
}

