/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dock.factory;

import com.javadocking.dock.CompositeLineDock;
import com.javadocking.dock.Dock;
import com.javadocking.dock.factory.DockFactory;
import com.javadocking.dock.factory.ToolBarDockFactory;
import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.util.DockingUtil;
import java.awt.Dimension;
import java.util.Properties;

public class CompositeToolBarDockFactory
implements DockFactory {
    public Dock createDock(Dockable dockable, int dockingMode) {
        if ((dockingMode & 0x800) != 0) {
            return new CompositeLineDock(0, false, new ToolBarDockFactory(), 2048, 4096);
        }
        if ((dockingMode & 0x1000) != 0) {
            return new CompositeLineDock(1, false, new ToolBarDockFactory(), 2048, 4096);
        }
        if ((dockingMode & 0x4000) != 0) {
            return new CompositeLineDock(0, false, new ToolBarDockFactory(), 16384, 32768);
        }
        if ((dockingMode & 0x8000) != 0) {
            return new CompositeLineDock(1, false, new ToolBarDockFactory(), 16384, 32768);
        }
        return null;
    }

    public Dimension getDockPreferredSize(Dockable dockable, int dockingMode) {
        if (dockable instanceof CompositeDockable) {
            if ((dockingMode & 0x800) != 0) {
                return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 256);
            }
            if ((dockingMode & 0x1000) != 0) {
                return DockingUtil.getCompositeDockablePreferredSize((CompositeDockable)dockable, 512);
            }
        }
        if (dockable.getContent() != null) {
            return dockable.getContent().getPreferredSize();
        }
        return new Dimension(0, 0);
    }

    public void saveProperties(String prefix, Properties properties) {
    }

    public void loadProperties(String prefix, Properties properties) {
    }
}

