/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.dockable.action;

import com.javadocking.dockable.CompositeDockable;
import com.javadocking.dockable.DefaultCompositeDockable;
import com.javadocking.dockable.Dockable;
import com.javadocking.dockable.action.DefaultDockableStateAction;
import com.javadocking.dockable.action.DockableStateAction;
import com.javadocking.dockable.action.PopupMenuFactory;
import com.javadocking.util.DockingUtil;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class DefaultPopupMenuFactory
implements PopupMenuFactory {
    public static final int DOCKABLE_ACTIONS = 1;
    public static final int CLOSE_ALL_ACTION = 2;
    public static final int CLOSE_OTHERS_ACTION = 4;
    public static final int MINIMIZE_ALL_ACTION = 8;
    public static final int MINIMIZE_OTHERS_ACTION = 16;
    public static final int RESTORE_ALL_ACTION = 32;
    private int popupActions = Integer.MAX_VALUE;

    public JPopupMenu createPopupMenu(Dockable selectedDockable, CompositeDockable compositeDockable) {
        JPopupMenu popupMenu = new JPopupMenu();
        int count = 0;
        int currentState = -1;
        if (selectedDockable != null && (1 & this.popupActions) != 0) {
            currentState = selectedDockable.getState();
            Dockable dockable = DockingUtil.retrieveDockableOfDockModel(selectedDockable.getID());
            if (dockable == null) {
                throw new IllegalStateException("The dragged dockable should be docked in the dock model.");
            }
            Action[][] actionMatrix = dockable.getActions();
            if (actionMatrix == null) {
                return null;
            }
            boolean firstGroup = true;
            for (int group = 0; group < actionMatrix.length; ++group) {
                Action[] actionGroup = actionMatrix[group];
                if (actionGroup == null || actionGroup.length <= 0) continue;
                if (firstGroup) {
                    firstGroup = false;
                } else {
                    popupMenu.addSeparator();
                }
                for (int index = 0; index < actionGroup.length; ++index) {
                    popupMenu.add(new JMenuItem(actionGroup[index]));
                    ++count;
                }
            }
        }
        if (compositeDockable != null && compositeDockable.getDockableCount() > 0 && (compositeDockable.getSelectedDockable() == null || compositeDockable.getDockableCount() > 1)) {
            DefaultDockableStateAction closeAllAction = null;
            DefaultDockableStateAction minimizeAllAction = null;
            DefaultDockableStateAction restoreAllAction = null;
            DefaultDockableStateAction closeOthersAction = null;
            DefaultDockableStateAction minimizeOthersAction = null;
            if (currentState != 2 && (2 & this.popupActions) != 0 && this.createAction(2, compositeDockable)) {
                closeAllAction = new DefaultDockableStateAction(compositeDockable, 2, "Close All", null);
            }
            if (currentState != 8 && (8 & this.popupActions) != 0 && this.createAction(8, compositeDockable)) {
                minimizeAllAction = new DefaultDockableStateAction(compositeDockable, 8, "Minimize All", null);
            }
            if (currentState != 1 && (0x20 & this.popupActions) != 0 && this.createAction(1, compositeDockable)) {
                restoreAllAction = new DefaultDockableStateAction(compositeDockable, 1, "Restore All", null);
            }
            if (compositeDockable.getSelectedDockable() != null && compositeDockable.getDockableCount() > 1) {
                ArrayList<Dockable> otherDockablesList = new ArrayList<Dockable>();
                Dockable selectedDockableOfComposite = compositeDockable.getSelectedDockable();
                for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
                    Dockable dockableToAdd = compositeDockable.getDockable(index);
                    if (dockableToAdd.equals(selectedDockableOfComposite)) continue;
                    otherDockablesList.add(dockableToAdd);
                }
                Dockable[] otherDockables = new Dockable[compositeDockable.getDockableCount() - 1];
                otherDockables = otherDockablesList.toArray(otherDockables);
                DefaultCompositeDockable compositeDockableExceptSelected = new DefaultCompositeDockable(otherDockables);
                if (currentState != 2 && (4 & this.popupActions) != 0 && this.createAction(2, compositeDockableExceptSelected)) {
                    closeOthersAction = new DefaultDockableStateAction(compositeDockableExceptSelected, 2, "Close Others", null);
                }
                if (currentState != 8 && (0x10 & this.popupActions) != 0 && this.createAction(8, compositeDockableExceptSelected)) {
                    minimizeOthersAction = new DefaultDockableStateAction(compositeDockableExceptSelected, 8, "Minimize Others", null);
                }
            }
            if (count > 0 && (closeAllAction != null || restoreAllAction != null || closeOthersAction != null || minimizeAllAction != null || minimizeOthersAction != null)) {
                popupMenu.addSeparator();
            }
            if (closeAllAction != null) {
                ++count;
                popupMenu.add(new JMenuItem(closeAllAction));
            }
            if (closeOthersAction != null) {
                ++count;
                popupMenu.add(new JMenuItem(closeOthersAction));
            }
            if (minimizeAllAction != null) {
                ++count;
                popupMenu.add(new JMenuItem(minimizeAllAction));
            }
            if (minimizeOthersAction != null) {
                ++count;
                popupMenu.add(new JMenuItem(minimizeOthersAction));
            }
            if (restoreAllAction != null) {
                ++count;
                popupMenu.add(new JMenuItem(restoreAllAction));
            }
        }
        if (count > 0) {
            return popupMenu;
        }
        return null;
    }

    public int getPopupActions() {
        return this.popupActions;
    }

    public void setPopupActions(int popupActions) {
        this.popupActions = popupActions;
    }

    private boolean createAction(int newState, CompositeDockable compositeDockable) {
        for (int index = 0; index < compositeDockable.getDockableCount(); ++index) {
            Dockable childDockable = compositeDockable.getDockable(index);
            if ((childDockable.getPossibleStates() & newState) == 0) {
                return false;
            }
            if (childDockable.getState() == newState) {
                return false;
            }
            if (this.hasDockableStateAction(childDockable, newState)) continue;
            return false;
        }
        return true;
    }

    private boolean hasDockableStateAction(Dockable dockable, int newState) {
        Action[][] actionMatrix = dockable.getActions();
        if (actionMatrix == null) {
            return false;
        }
        for (int row = 0; row < actionMatrix.length; ++row) {
            Action[] actionRow = actionMatrix[row];
            if (actionRow == null) continue;
            for (int column = 0; column < actionRow.length; ++column) {
                DockableStateAction dockableStateAction;
                Action action = actionRow[column];
                if (!(action instanceof DockableStateAction) || (dockableStateAction = (DockableStateAction)action).getNewDockableState() != newState) continue;
                return true;
            }
        }
        return false;
    }
}

