/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag;

import java.awt.Component;
import java.awt.Cursor;
import javax.swing.SwingUtilities;

class DragCursorManager {
    private Cursor oldCursor;
    private Cursor cursor;
    private Component cursorComponent;
    private Component glassPane;
    private boolean glassPaneOldVisible;

    DragCursorManager() {
    }

    public void setCursor(Component component, Cursor newCursor) {
        if (newCursor.equals(this.cursor) && component.equals(this.cursorComponent)) {
            return;
        }
        Component newGlassPane = SwingUtilities.getRootPane(component).getGlassPane();
        if (newGlassPane == null) {
            return;
        }
        if (newCursor.equals(this.cursor) && newGlassPane.equals(this.glassPane)) {
            return;
        }
        if (this.glassPane != null) {
            this.glassPane.setVisible(this.glassPaneOldVisible);
            this.glassPane.setCursor(this.oldCursor);
        }
        this.glassPane = newGlassPane;
        this.glassPaneOldVisible = this.glassPane.isVisible();
        if (this.oldCursor == null) {
            this.oldCursor = this.glassPane.getCursor();
        }
        this.glassPane.setCursor(newCursor);
        this.glassPane.setVisible(true);
        this.cursor = newCursor;
        this.cursorComponent = component;
    }

    public void resetCursor() {
        if (this.oldCursor != null) {
            this.glassPane.setCursor(this.oldCursor);
            this.glassPane.setVisible(this.glassPaneOldVisible);
        }
        this.glassPane = null;
        this.cursorComponent = null;
        this.oldCursor = null;
        this.cursor = null;
        this.glassPaneOldVisible = false;
    }
}

