/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag;

import com.javadocking.DockingManager;
import com.javadocking.dock.Dock;
import com.javadocking.dock.FloatDock;
import com.javadocking.dock.LeafDock;
import com.javadocking.dock.SingleDock;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.DragCursorManager;
import com.javadocking.drag.Dragger;
import com.javadocking.drag.ExternalizedDraggerSupport;
import com.javadocking.drag.dockretriever.DockRetriever;
import com.javadocking.drag.dockretriever.StaticDockRetriever;
import com.javadocking.drag.painter.DefaultRectanglePainter;
import com.javadocking.drag.painter.DockableDragPainter;
import com.javadocking.drag.painter.SwDockableDragPainter;
import com.javadocking.util.DockingUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class StaticSingleDragger
implements Dragger {
    private DockRetriever dockRetriever = new StaticDockRetriever();
    private LeafDock originDock;
    private Point screenLocation = new Point();
    private Point locationInDestinationDock = new Point();
    private Point dockableOffset = new Point();
    private Dockable draggedDockable;
    private DragCursorManager cursorManager = new DragCursorManager();
    private DockableDragPainter dockableDragPainter = new SwDockableDragPainter(new DefaultRectanglePainter());
    private Rectangle dockableDragRectangle = new Rectangle();

    public StaticSingleDragger() {
        this(new SwDockableDragPainter(new DefaultRectanglePainter()));
    }

    public StaticSingleDragger(DockableDragPainter dockableDragPainter) {
        this.dockableDragPainter = dockableDragPainter;
    }

    public boolean startDragging(MouseEvent mouseEvent) {
        Component mouseComponent = (Component)mouseEvent.getSource();
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        this.reset();
        this.originDock = (LeafDock)((Object)SwingUtilities.getAncestorOfClass(LeafDock.class, mouseComponent));
        if (this.originDock != null && this.originDock.getDockableCount() > 0) {
            Dimension size;
            this.draggedDockable = this.originDock.getDockable(0);
            this.dockableOffset.setLocation(x, y);
            if (this.originDock instanceof Component) {
                this.dockableOffset = SwingUtilities.convertPoint(mouseComponent, this.dockableOffset, (Component)((Object)this.originDock));
            }
            if ((double)this.dockableOffset.x > (size = this.draggedDockable.getContent().getPreferredSize()).getWidth()) {
                this.dockableOffset.x = (int)Math.round(size.getWidth());
            }
            if ((double)this.dockableOffset.y > size.getHeight()) {
                this.dockableOffset.y = (int)Math.round(size.getHeight());
            }
            return true;
        }
        return false;
    }

    public void drag(MouseEvent mouseEvent) {
        Component mouseComponent = (Component)mouseEvent.getSource();
        this.computeScreenLocation(mouseEvent);
        if (this.draggedDockable.getState() == 16) {
            ExternalizedDraggerSupport.moveExternalizedDockable(this.draggedDockable, this.screenLocation, this.dockableOffset);
            return;
        }
        Dock[] destinationDocks = this.dockRetriever.retrieveHighestPriorityDock(this.screenLocation, this.draggedDockable);
        if (destinationDocks == null) {
            this.dockableDragPainter.paintDockableDrag(this.draggedDockable, null, null, this.screenLocation);
            this.cursorManager.setCursor(mouseComponent, this.retrieveCanNotDockCursor());
            return;
        }
        Dock destinationDock = destinationDocks[0];
        if (destinationDock != null) {
            if (destinationDock instanceof Component) {
                this.locationInDestinationDock.setLocation(this.screenLocation.x, this.screenLocation.y);
                SwingUtilities.convertPointFromScreen(this.locationInDestinationDock, (Component)((Object)destinationDock));
                destinationDock.retrieveDockingRectangle(this.draggedDockable, this.locationInDestinationDock, this.dockableOffset, this.dockableDragRectangle);
                this.dockableDragPainter.paintDockableDrag(this.draggedDockable, destinationDock, this.dockableDragRectangle, this.locationInDestinationDock);
                this.cursorManager.setCursor((Component)((Object)destinationDock), this.retrieveCanDockCursor());
            } else if (destinationDock instanceof FloatDock) {
                boolean move = false;
                Dock rootDock = this.originDock;
                LeafDock dockUnderRoot = null;
                while (rootDock.getParentDock() != null) {
                    dockUnderRoot = rootDock;
                    rootDock = rootDock.getParentDock();
                }
                if (rootDock instanceof FloatDock) {
                    ArrayList childrenOfDockable = new ArrayList();
                    ArrayList childrenOfDock = new ArrayList();
                    DockingUtil.retrieveDockables(this.draggedDockable, childrenOfDockable);
                    DockingUtil.retrieveDockables(dockUnderRoot, childrenOfDock);
                    if (this.sameElements(childrenOfDockable, childrenOfDock)) {
                        move = true;
                    }
                }
                if (this.originDock instanceof Component) {
                    if (move) {
                        this.locationInDestinationDock.setLocation(this.screenLocation.x - this.dockableOffset.x, this.screenLocation.y - this.dockableOffset.y);
                        this.dockableDragRectangle.setLocation(this.locationInDestinationDock);
                        Window window = SwingUtilities.getWindowAncestor((Component)((Object)dockUnderRoot));
                        this.dockableDragRectangle.setSize(window.getSize());
                        this.locationInDestinationDock.setLocation(this.locationInDestinationDock.x + this.dockableOffset.x, this.locationInDestinationDock.y + this.dockableOffset.y);
                    } else {
                        destinationDock.retrieveDockingRectangle(this.draggedDockable, this.screenLocation, this.dockableOffset, this.dockableDragRectangle);
                        this.locationInDestinationDock.setLocation(this.dockableDragRectangle.x, this.dockableDragRectangle.y);
                        this.dockableDragRectangle.setLocation(this.locationInDestinationDock);
                        this.locationInDestinationDock.setLocation(this.locationInDestinationDock.x + this.dockableOffset.x, this.locationInDestinationDock.y + this.dockableOffset.y);
                    }
                    this.dockableDragPainter.paintDockableDrag(this.draggedDockable, destinationDock, this.dockableDragRectangle, this.locationInDestinationDock);
                    this.cursorManager.setCursor(mouseComponent, this.retrieveCanDockCursor());
                } else {
                    this.dockableDragPainter.paintDockableDrag(this.draggedDockable, destinationDock, null, this.screenLocation);
                }
                this.cursorManager.setCursor(mouseComponent, this.retrieveCanDockCursor());
            } else {
                this.dockableDragPainter.paintDockableDrag(this.draggedDockable, destinationDock, null, this.screenLocation);
                this.cursorManager.setCursor(mouseComponent, this.retrieveCanDockCursor());
            }
        } else {
            this.dockableDragPainter.paintDockableDrag(this.draggedDockable, null, null, this.screenLocation);
            this.cursorManager.setCursor(mouseComponent, this.retrieveCanNotDockCursor());
        }
    }

    public void cancelDragging(MouseEvent mouseEvent) {
        this.cursorManager.resetCursor();
        this.clearPainting();
        if (this.originDock instanceof SingleDock) {
            ((SingleDock)this.originDock).clearGhosts();
        }
        this.reset();
    }

    public void stopDragging(MouseEvent mouseEvent) {
        this.cursorManager.resetCursor();
        this.dockableDragPainter.clear();
        this.computeScreenLocation(mouseEvent);
        if (this.draggedDockable.getState() == 16) {
            ExternalizedDraggerSupport.moveExternalizedDockable(this.draggedDockable, this.screenLocation, this.dockableOffset);
            this.reset();
            return;
        }
        Dock[] destinationDocks = this.dockRetriever.retrieveHighestPriorityDock(this.screenLocation, this.draggedDockable);
        if (destinationDocks == null) {
            return;
        }
        Dock destinationDock = destinationDocks[0];
        if (destinationDock != null && !destinationDock.equals(this.originDock)) {
            this.locationInDestinationDock.setLocation(this.screenLocation.x, this.screenLocation.y);
            if (destinationDock instanceof Component) {
                SwingUtilities.convertPointFromScreen(this.locationInDestinationDock, (Component)((Object)destinationDock));
            }
            if (destinationDock instanceof FloatDock) {
                Dock rootDock = this.originDock;
                LeafDock dockUnderRoot = null;
                while (rootDock.getParentDock() != null) {
                    dockUnderRoot = rootDock;
                    rootDock = rootDock.getParentDock();
                }
                if (rootDock instanceof FloatDock) {
                    ArrayList childrenOfDockable = new ArrayList();
                    ArrayList childrenOfDock = new ArrayList();
                    DockingUtil.retrieveDockables(this.draggedDockable, childrenOfDockable);
                    DockingUtil.retrieveDockables(dockUnderRoot, childrenOfDock);
                    if (this.sameElements(childrenOfDockable, childrenOfDock)) {
                        ((FloatDock)rootDock).moveDock(dockUnderRoot, this.locationInDestinationDock, this.dockableOffset);
                        return;
                    }
                }
            }
            if (!this.originDock.equals(this.draggedDockable.getDock())) {
                throw new IllegalStateException("The origin dock is not the parent of the dockable.");
            }
            DockingManager.getDockingExecutor().changeDocking(this.draggedDockable, destinationDock, this.locationInDestinationDock, this.dockableOffset);
            DockingManager.getDockingExecutor().cleanDock(this.originDock, false);
        }
        this.reset();
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        Component mouseComponent = (Component)mouseEvent.getSource();
        this.originDock = (LeafDock)((Object)SwingUtilities.getAncestorOfClass(LeafDock.class, mouseComponent));
        if (this.originDock != null && this.originDock.getDockableCount() > 0) {
            Dockable clickedDockable = this.originDock.getDockable(0);
            JPopupMenu popupMenu = DockingManager.getComponentFactory().createPopupMenu(clickedDockable, null);
            if (popupMenu != null) {
                popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public DockableDragPainter getDockableDragPainter() {
        return this.dockableDragPainter;
    }

    public void setDockableDragPainter(DockableDragPainter dockableDragPainter) {
        this.dockableDragPainter = dockableDragPainter;
    }

    protected Cursor retrieveCanDockCursor() {
        return DockingManager.getCanDockCursor();
    }

    protected Cursor retrieveCanNotDockCursor() {
        return DockingManager.getCanNotDockCursor();
    }

    private void reset() {
        this.originDock = null;
    }

    private void computeScreenLocation(MouseEvent mouseEvent) {
        this.screenLocation.setLocation(mouseEvent.getX(), mouseEvent.getY());
        SwingUtilities.convertPointToScreen(this.screenLocation, (Component)mouseEvent.getSource());
    }

    private void clearPainting() {
        this.dockableDragPainter.clear();
    }

    private boolean sameElements(List firstList, List secondList) {
        if (firstList.size() != secondList.size()) {
            return false;
        }
        for (int index = 0; index < firstList.size(); ++index) {
            if (secondList.contains(firstList.get(index))) continue;
            return false;
        }
        return true;
    }
}

