/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag.painter;

import com.javadocking.dock.Dock;
import com.javadocking.dockable.Dockable;
import com.javadocking.drag.painter.DragComponentFactory;
import com.javadocking.drag.painter.RectanglePainter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class RectangleDragComponentFactory
implements DragComponentFactory {
    private RectanglePainter rectanglePainter;
    private boolean drawLabel;

    public RectangleDragComponentFactory(RectanglePainter rectanglePainter) {
        this(rectanglePainter, false);
    }

    public RectangleDragComponentFactory(RectanglePainter rectanglePainter, boolean drawLabel) {
        this.rectanglePainter = rectanglePainter;
        this.drawLabel = drawLabel;
    }

    public Component createDragComponent(Dockable dockable, Dock dock, Rectangle rectangle) {
        if (this.drawLabel) {
            this.rectanglePainter.setLabel(dockable.getTitle());
        }
        return new RectangleComponent(this.rectanglePainter, rectangle.width, rectangle.height);
    }

    public RectanglePainter getRectanglePainter() {
        return this.rectanglePainter;
    }

    public void setRectanglePainter(RectanglePainter rectanglePainter) {
        this.rectanglePainter = rectanglePainter;
    }

    public boolean isDrawLabel() {
        return this.drawLabel;
    }

    public void setDrawLabel(boolean drawLabel) {
        this.drawLabel = drawLabel;
    }

    private static class RectangleComponent
    extends JComponent {
        private RectanglePainter rectanglePainter;

        public RectangleComponent(RectanglePainter rectanglePainter, int width, int height) {
            this.rectanglePainter = rectanglePainter;
            this.setBounds(0, 0, width, height);
            this.setOpaque(false);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            this.rectanglePainter.paintRectangle(graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }
}

