/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.drag.painter;

import com.javadocking.drag.painter.DefaultRectanglePainter;
import com.javadocking.drag.painter.RectanglePainter;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import javax.swing.JWindow;

class TransparentWindow
extends JWindow {
    private Image screenImage;
    private Image windowImage;
    private Graphics windowImageGraphics;
    private RectanglePainter rectanglePainter = new DefaultRectanglePainter();

    public TransparentWindow(RectanglePainter rectanglePainter) {
        this.rectanglePainter = rectanglePainter;
    }

    public void paint(Graphics graphics) {
        if (this.windowImage == null) {
            this.windowImage = this.createImage(this.getWidth(), this.getHeight());
        }
        this.windowImageGraphics = this.windowImage.getGraphics();
        this.windowImageGraphics.drawImage(this.screenImage, 0, 0, this.getWidth(), this.getHeight(), this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), null);
        this.rectanglePainter.paintRectangle(this.windowImageGraphics, 0, 0, this.getWidth(), this.getHeight());
        graphics.drawImage(this.windowImage, 0, 0, null);
        this.windowImageGraphics.dispose();
    }

    public void dispose() {
        super.dispose();
        if (this.screenImage != null) {
            this.screenImage.flush();
            this.screenImage = null;
        }
        if (this.windowImage != null) {
            this.windowImage.flush();
            this.windowImage = null;
        }
    }

    public void doRepaint() {
        Graphics g = this.getGraphics();
        this.paint(g);
    }

    public void captureScreen() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        try {
            Robot robot = new Robot();
            Rectangle rectangle = new Rectangle(0, 0, dim.width, dim.height);
            this.screenImage = robot.createScreenCapture(rectangle);
            this.windowImage = null;
        }
        catch (AWTException exception) {
            System.out.println("Robot exception.");
        }
    }
}

