/*
 * Decompiled with CFR 0.152.
 */
package com.javadocking.model;

import com.javadocking.dock.Dock;
import com.javadocking.dock.FloatDock;
import com.javadocking.model.DockModel;
import com.javadocking.model.DockModelPropertiesUtil;
import com.javadocking.util.PropertiesUtil;
import com.javadocking.visualizer.Visualizer;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DefaultDockModel
implements DockModel {
    private String source;
    private Map ownerIDsMap = new HashMap();
    private List owners = new ArrayList();
    private Map rootDockKeys = new HashMap();
    private Map ownerRootDockKeys = new HashMap();
    private Map ownerFocusListeners = new HashMap();
    private Map visualizerKeys = new HashMap();
    private Map ownerVisualizerKeys = new HashMap();
    private boolean loadOwnerRectangle = true;

    public DefaultDockModel() {
    }

    public DefaultDockModel(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void addOwner(String ownerId, Window window) {
        if (this.owners.contains(ownerId)) {
            throw new IllegalArgumentException("There is already an owner window with ID [" + ownerId + "].");
        }
        if (!this.owners.contains(window)) {
            this.owners.add(window);
            this.ownerIDsMap.put(window, ownerId);
            this.ownerRootDockKeys.put(window, new HashSet());
            this.ownerVisualizerKeys.put(window, new HashSet());
            OwnerToFrontListener ownerToFrontListener = new OwnerToFrontListener(window);
            this.ownerFocusListeners.put(window, ownerToFrontListener);
            window.addWindowFocusListener(ownerToFrontListener);
        }
    }

    public String getOwnerID(Window owner) {
        return (String)this.ownerIDsMap.get(owner);
    }

    public int getOwnerCount() {
        return this.owners.size();
    }

    public Window getOwner(int index) {
        if (index < 0 || index >= this.getOwnerCount()) {
            throw new IndexOutOfBoundsException("Index " + index);
        }
        return (Window)this.owners.get(index);
    }

    public void removeOwner(Window owner) {
        if (!this.owners.contains(owner)) {
            throw new IllegalArgumentException("The window is not an owner window of the dock model.");
        }
        Iterator rootDockIterator = this.getRootKeys(owner);
        while (rootDockIterator.hasNext()) {
            String rootDockKey = (String)rootDockIterator.next();
            this.rootDockKeys.remove(rootDockKey);
        }
        this.owners.remove(owner);
        this.ownerIDsMap.remove(owner);
        this.ownerRootDockKeys.remove(owner);
        this.ownerVisualizerKeys.remove(owner);
    }

    public void addRootDock(String rootKey, Dock dock, Window owner) {
        if (!this.owners.contains(owner)) {
            throw new IllegalArgumentException("Owner [" + owner + "] is not an owner window of this dock model.");
        }
        if (dock.getParentDock() != null) {
            throw new IllegalArgumentException("The dock is not a root dock. Its parent should be null.");
        }
        if (this.rootDockKeys.containsValue(dock)) {
            throw new IllegalArgumentException("There is already a root dock with key [" + rootKey + "] in this dock model.");
        }
        this.rootDockKeys.put(rootKey, dock);
        Set rootDockKeysOfOwner = (Set)this.ownerRootDockKeys.get(owner);
        rootDockKeysOfOwner.add(rootKey);
        if (dock instanceof FloatDock) {
            OwnerToFrontListener ownerToFrontListener = (OwnerToFrontListener)this.ownerFocusListeners.get(owner);
            ((FloatDock)dock).addWindowFocusListener(ownerToFrontListener);
        }
    }

    public Dock getRootDock(String rootKey) {
        return (Dock)this.rootDockKeys.get(rootKey);
    }

    public void removeRootDock(Dock dock) {
        Iterator rootDockKeyIterator = this.rootDockKeys.keySet().iterator();
        while (rootDockKeyIterator.hasNext()) {
            String rootDockKey = (String)rootDockKeyIterator.next();
            Dock rootDock = this.getRootDock(rootDockKey);
            if (!rootDock.equals(dock)) continue;
            this.rootDockKeys.remove(rootDockKey);
            Iterator ownerRootDocksIterator = this.ownerRootDockKeys.values().iterator();
            while (ownerRootDocksIterator.hasNext()) {
                Set ownerRootDocks = (Set)ownerRootDocksIterator.next();
                if (!ownerRootDocks.remove(rootDockKey)) continue;
                return;
            }
        }
        throw new IllegalArgumentException("The dock is not a root dock of this dock model.");
    }

    public Iterator getRootKeys(Window owner) {
        Set rootDockKeysOfOwner = (Set)this.ownerRootDockKeys.get(owner);
        return rootDockKeysOfOwner.iterator();
    }

    public void addVisualizer(String key, Visualizer visualizer, Window owner) {
        if (!this.owners.contains(owner)) {
            throw new IllegalArgumentException("Owner [" + owner + "] is not an owner window of this dock model.");
        }
        if (this.visualizerKeys.containsValue(visualizer)) {
            throw new IllegalArgumentException("There is already a visualizer with key [" + key + "] in this dock model.");
        }
        this.visualizerKeys.put(key, visualizer);
        Set visualizerKeysOfOwner = (Set)this.ownerVisualizerKeys.get(owner);
        visualizerKeysOfOwner.add(key);
    }

    public Visualizer getVisualizer(String key) {
        return (Visualizer)this.visualizerKeys.get(key);
    }

    public Iterator getVisualizerKeys(Window owner) {
        Set visualizerKeysOfOwner = (Set)this.ownerVisualizerKeys.get(owner);
        return visualizerKeysOfOwner.iterator();
    }

    public void removeVisualizer(Visualizer visualizerToRemove) {
        Iterator visualizerKeyIterator = this.visualizerKeys.keySet().iterator();
        while (visualizerKeyIterator.hasNext()) {
            String visualizerKey = (String)visualizerKeyIterator.next();
            Visualizer visualizer = this.getVisualizer(visualizerKey);
            if (!visualizer.equals(visualizerToRemove)) continue;
            this.visualizerKeys.remove(visualizerKey);
            Iterator ownerVisualizerIterator = this.ownerVisualizerKeys.values().iterator();
            while (ownerVisualizerIterator.hasNext()) {
                Set ownerVisualizers = (Set)ownerVisualizerIterator.next();
                if (!ownerVisualizers.remove(visualizerKey)) continue;
                return;
            }
        }
        throw new IllegalArgumentException("The visualizer is not a visualizer of this dock model.");
    }

    public FloatDock getFloatDock(Window owner) {
        Iterator rootDockKeyIterator = this.getRootKeys(owner);
        while (rootDockKeyIterator.hasNext()) {
            String rootDockKey = (String)rootDockKeyIterator.next();
            Dock rootDock = this.getRootDock(rootDockKey);
            if (!(rootDock instanceof FloatDock)) continue;
            return (FloatDock)rootDock;
        }
        return null;
    }

    public String getFloatDockKey(Window owner) {
        Iterator rootDockKeyIterator = this.getRootKeys(owner);
        while (rootDockKeyIterator.hasNext()) {
            String rootDockKey = (String)rootDockKeyIterator.next();
            Dock rootDock = this.getRootDock(rootDockKey);
            if (!(rootDock instanceof FloatDock)) continue;
            return rootDockKey;
        }
        return null;
    }

    public void loadProperties(String sourceName, String prefix, Properties properties, Map dockablesMap, Map ownersMap, Map docksMap, Map visualizersMap) throws IOException {
        this.loadOwnerRectangle = PropertiesUtil.getBoolean(properties, prefix + "loadOwnerRectangle", this.loadOwnerRectangle);
        this.source = sourceName;
        DockModelPropertiesUtil.loadDockModelProperties(this, prefix, properties, dockablesMap, ownersMap, docksMap, visualizersMap, this.isLoadOwnerRectangle());
    }

    public void saveProperties(String prefix, Properties properties, Map docks) {
        PropertiesUtil.setBoolean(properties, prefix + "loadOwnerRectangle", this.loadOwnerRectangle);
        DockModelPropertiesUtil.saveDockModelProperties(this, prefix, properties, docks);
    }

    public boolean isLoadOwnerRectangle() {
        return this.loadOwnerRectangle;
    }

    public void setLoadOwnerRectangle(boolean loadFrameRectangle) {
        this.loadOwnerRectangle = loadFrameRectangle;
    }

    private class OwnerToFrontListener
    implements WindowFocusListener {
        private Window ownerWindow;

        public OwnerToFrontListener(Window ownerWindow) {
            this.ownerWindow = ownerWindow;
        }

        public void windowGainedFocus(WindowEvent windowEvent) {
            if (!DefaultDockModel.this.owners.contains(this.ownerWindow)) {
                throw new IllegalStateException("The window is not an owner window of the dock model.");
            }
            if (DefaultDockModel.this.owners.indexOf(this.ownerWindow) != 0) {
                DefaultDockModel.this.owners.remove(this.ownerWindow);
                DefaultDockModel.this.owners.add(0, this.ownerWindow);
            }
        }

        public void windowLostFocus(WindowEvent windowEvent) {
        }
    }
}

